/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.resources.IResourceHandler;

public abstract class AbstractResourceParser {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected void handleAndroidResourceFiles(String apk, Set<String> fileNameFilter, IResourceHandler handler) {
        File apkF = new File(apk);
        if (!apkF.exists()) {
            throw new RuntimeException("file '" + apk + "' does not exist!");
        }
        try (ZipFile archive = new ZipFile(apkF);){
            Enumeration<? extends ZipEntry> entries = archive.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                InputStream is = archive.getInputStream(entry);
                Throwable throwable = null;
                try {
                    handler.handleResourceFile(entryName, fileNameFilter, is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error when looking for XML resource files in apk " + apk, (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

