/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.resources.controls;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import soot.SootClass;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.flags.InputType;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class EditTextControl
extends AndroidLayoutControl {
    protected static final ISourceSinkDefinition UI_PASSWORD_SOURCE_DEF = new MethodSourceSinkDefinition(null, null, Collections.singleton(AccessPathTuple.fromPathElements((String)"android.widget.TextView", Collections.singletonList("content"), Collections.singletonList("android.text.Editable"), (SourceSinkType)SourceSinkType.Source)), MethodSourceSinkDefinition.CallType.MethodCall);
    protected static final ISourceSinkDefinition UI_ELEMENT_SOURCE_DEF = new MethodSourceSinkDefinition(null, null, Collections.singleton(AccessPathTuple.fromPathElements((String)"android.widget.TextView", Collections.singletonList("content"), Collections.singletonList("android.text.Editable"), (SourceSinkType)SourceSinkType.Source)), MethodSourceSinkDefinition.CallType.MethodCall);
    private int inputType;
    private boolean isPassword;
    private String text;
    private Collection<Integer> inputTypeFlags;

    EditTextControl(SootClass viewClass) {
        super(viewClass);
    }

    public EditTextControl(int id, SootClass viewClass) {
        super(id, viewClass);
    }

    public EditTextControl(int id, SootClass viewClass, Map<String, Object> additionalAttributes) {
        super(id, viewClass, additionalAttributes);
    }

    void setInputType(int inputType) {
        this.inputType = inputType;
        this.inputTypeFlags = InputType.getFlags(inputType);
    }

    public int getInputType() {
        return this.inputType;
    }

    public boolean satisfiesInputType(int ... type) {
        if (this.inputTypeFlags == null) {
            return false;
        }
        for (int i : type) {
            if (this.inputTypeFlags.contains(i)) continue;
            return false;
        }
        return true;
    }

    public String getText() {
        return this.text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleAttribute(AXmlAttribute<?> attribute, boolean loadOptionalData) {
        String attrName = attribute.getName().trim();
        int type = attribute.getType();
        if (attrName.equals("inputType") && type == 17) {
            this.setInputType((Integer)attribute.getValue());
            return;
        } else if (attrName.equals("password")) {
            if (type == 17) {
                this.isPassword = (Integer)attribute.getValue() != 0;
                return;
            } else {
                if (type != 18) throw new RuntimeException("Unknown representation of boolean data type");
                this.isPassword = (Boolean)attribute.getValue();
            }
            return;
        } else if (loadOptionalData && type == 3 && attrName.equals("text")) {
            this.text = (String)attribute.getValue();
            return;
        } else {
            super.handleAttribute(attribute, loadOptionalData);
        }
    }

    public boolean isSensitive() {
        if (this.isPassword) {
            return true;
        }
        if (this.satisfiesInputType(InputType.numberPassword)) {
            return true;
        }
        if (this.satisfiesInputType(InputType.textVisiblePassword)) {
            return true;
        }
        if (this.satisfiesInputType(InputType.textWebPassword)) {
            return true;
        }
        return this.satisfiesInputType(InputType.textPassword);
    }

    public ISourceSinkDefinition getSourceDefinition() {
        return this.isSensitive() ? UI_PASSWORD_SOURCE_DEF : UI_ELEMENT_SOURCE_DEF;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.inputType;
        result = 31 * result + (this.isPassword ? 1231 : 1237);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EditTextControl other = (EditTextControl)((Object)obj);
        if (this.inputType != other.inputType) {
            return false;
        }
        if (this.isPassword != other.isPassword) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    static {
        UI_PASSWORD_SOURCE_DEF.setCategory(new ISourceSinkCategory(){

            public String getHumanReadableDescription() {
                return "Password Input";
            }

            public String toString() {
                return "Password Input";
            }

            public String getID() {
                return "PASSWORD";
            }
        });
        UI_ELEMENT_SOURCE_DEF.setCategory(new ISourceSinkCategory(){

            public String getHumanReadableDescription() {
                return "UI Element";
            }

            public String toString() {
                return "UI Element";
            }

            public String getID() {
                return "UIELEMENT";
            }
        });
    }
}

