/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Bottom;
import fj.F;
import fj.F2;
import fj.F3;
import fj.F4;
import fj.F5;
import fj.F6;
import fj.F7;
import fj.F8;
import fj.Function;
import fj.P;
import fj.P1;
import fj.Semigroup;
import fj.Show;
import fj.Unit;
import fj.data.Array;
import fj.data.Either;
import fj.data.List;
import fj.data.NonEmptyList;
import fj.data.Option;
import fj.data.Stream;
import fj.data.Validation$$Lambda$1;
import fj.data.Validation$$Lambda$2;
import fj.data.Validation$$Lambda$3;
import fj.data.Validation$$Lambda$4;
import fj.data.Validation$$Lambda$5;
import fj.data.Validation$$Lambda$6;
import fj.data.Validation$$Lambda$7;
import fj.function.Effect1;
import java.util.Iterator;

public class Validation<E, T>
implements Iterable<T> {
    private final Either<E, T> e;
    public static final F<String, Validation<NumberFormatException, Byte>> parseByte = new F<String, Validation<NumberFormatException, Byte>>(){

        @Override
        public Validation<NumberFormatException, Byte> f(String s2) {
            return Validation.parseByte(s2);
        }
    };
    public static final F<String, Validation<NumberFormatException, Double>> parseDouble = new F<String, Validation<NumberFormatException, Double>>(){

        @Override
        public Validation<NumberFormatException, Double> f(String s2) {
            return Validation.parseDouble(s2);
        }
    };
    public static final F<String, Validation<NumberFormatException, Float>> parseFloat = new F<String, Validation<NumberFormatException, Float>>(){

        @Override
        public Validation<NumberFormatException, Float> f(String s2) {
            return Validation.parseFloat(s2);
        }
    };
    public static final F<String, Validation<NumberFormatException, Integer>> parseInt = new F<String, Validation<NumberFormatException, Integer>>(){

        @Override
        public Validation<NumberFormatException, Integer> f(String s2) {
            return Validation.parseInt(s2);
        }
    };
    public static final F<String, Validation<NumberFormatException, Long>> parseLong = new F<String, Validation<NumberFormatException, Long>>(){

        @Override
        public Validation<NumberFormatException, Long> f(String s2) {
            return Validation.parseLong(s2);
        }
    };
    public static final F<String, Validation<NumberFormatException, Short>> parseShort = new F<String, Validation<NumberFormatException, Short>>(){

        @Override
        public Validation<NumberFormatException, Short> f(String s2) {
            return Validation.parseShort(s2);
        }
    };

    protected Validation(Either<E, T> e) {
        this.e = e;
    }

    public boolean isFail() {
        return this.e.isLeft();
    }

    public boolean isSuccess() {
        return this.e.isRight();
    }

    public E fail() {
        if (this.isFail()) {
            return this.e.left().value();
        }
        throw Bottom.error("Validation: fail on success value");
    }

    public T success() {
        if (this.isSuccess()) {
            return this.e.right().value();
        }
        throw Bottom.error("Validation: success on fail value");
    }

    public <X> X validation(F<E, X> fail, F<T, X> success) {
        return this.e.either(fail, success);
    }

    public FailProjection<E, T> f() {
        return new FailProjection(this);
    }

    public Either<E, T> toEither() {
        return this.e;
    }

    public T successE(P1<String> err) {
        return this.e.right().valueE(err);
    }

    public T successE(String err) {
        return this.e.right().valueE(P.p(err));
    }

    public T orSuccess(P1<T> t) {
        return this.e.right().orValue(t);
    }

    public T orSuccess(T t) {
        return this.e.right().orValue(P.p(t));
    }

    public T on(F<E, T> f) {
        return this.e.right().on(f);
    }

    public Unit foreach(F<T, Unit> f) {
        return this.e.right().foreach(f);
    }

    public void foreachDoEffect(Effect1<T> f) {
        this.e.right().foreachDoEffect(f);
    }

    public <A> Validation<E, A> map(F<T, A> f) {
        return this.isFail() ? Validation.fail(this.fail()) : Validation.success(f.f(this.success()));
    }

    public <A> Validation<E, A> bind(F<T, Validation<E, A>> f) {
        return this.isSuccess() ? f.f(this.success()) : Validation.fail(this.fail());
    }

    public <A> Validation<E, A> sequence(Validation<E, A> v) {
        return this.bind(Function.constant(v));
    }

    public <A> Option<Validation<A, T>> filter(F<T, Boolean> f) {
        return this.e.right().filter(f).map(Validation.validation());
    }

    public <A> Validation<E, A> apply(Validation<E, F<T, A>> v) {
        return v.bind(new F<F<T, A>, Validation<E, A>>(){

            @Override
            public Validation<E, A> f(F<T, A> f) {
                return Validation.this.map(f);
            }
        });
    }

    public boolean forall(F<T, Boolean> f) {
        return this.e.right().forall(f);
    }

    public boolean exists(F<T, Boolean> f) {
        return this.e.right().exists(f);
    }

    public List<T> toList() {
        return this.e.right().toList();
    }

    public Option<T> toOption() {
        return this.e.right().toOption();
    }

    public Array<T> toArray() {
        return this.e.right().toArray();
    }

    public Stream<T> toStream() {
        return this.e.right().toStream();
    }

    public <A> Validation<E, A> accumapply(Semigroup<E> s2, Validation<E, F<T, A>> v) {
        return this.isFail() ? Validation.fail(v.isFail() ? s2.sum(v.fail(), this.fail()) : this.fail()) : (v.isFail() ? Validation.fail(v.fail()) : Validation.success(v.success().f(this.success())));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> s2, Validation<E, A> va, F<T, F<A, B>> f) {
        return va.accumapply(s2, this.map(f));
    }

    public <A, B> Validation<E, B> accumulate(Semigroup<E> s2, Validation<E, A> va, F2<T, A, B> f) {
        return va.accumapply(s2, this.map(Function.curry(f)));
    }

    public <A> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va) {
        return this.accumulate(s2, va, new F2<T, A, Unit>(){

            @Override
            public Unit f(T t, A a) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, F<T, F<A, F<B, C>>> f) {
        return vb.accumapply(s2, this.accumulate(s2, va, f));
    }

    public <A, B, C> Validation<E, C> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, F3<T, A, B, C> f) {
        return vb.accumapply(s2, this.accumulate(s2, va, Function.curry(f)));
    }

    public <A, B> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb) {
        return this.accumulate(s2, va, vb, new F3<T, A, B, Unit>(){

            @Override
            public Unit f(T t, A a, B b) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F<T, F<A, F<B, F<C, D>>>> f) {
        return vc.accumapply(s2, this.accumulate(s2, va, vb, f));
    }

    public <A, B, C, D> Validation<E, D> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, F4<T, A, B, C, D> f) {
        return vc.accumapply(s2, this.accumulate(s2, va, vb, Function.curry(f)));
    }

    public <A, B, C> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc) {
        return this.accumulate(s2, va, vb, vc, new F4<T, A, B, C, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F<T, F<A, F<B, F<C, F<D, E$>>>>> f) {
        return vd.accumapply(s2, this.accumulate(s2, va, vb, vc, f));
    }

    public <A, B, C, D, E$> Validation<E, E$> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, F5<T, A, B, C, D, E$> f) {
        return vd.accumapply(s2, this.accumulate(s2, va, vb, vc, Function.curry(f)));
    }

    public <A, B, C, D> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd) {
        return this.accumulate(s2, va, vb, vc, vd, new F5<T, A, B, C, D, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F<T, F<A, F<B, F<C, F<D, F<E$, F$>>>>>> f) {
        return ve.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, f));
    }

    public <A, B, C, D, E$, F$> Validation<E, F$> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, F6<T, A, B, C, D, E$, F$> f) {
        return ve.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, Function.curry(f)));
    }

    public <A, B, C, D, E$> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve) {
        return this.accumulate(s2, va, vb, vc, vd, ve, new F6<T, A, B, C, D, E$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, G>>>>>>> f) {
        return vf.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, ve, f));
    }

    public <A, B, C, D, E$, F$, G> Validation<E, G> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, F7<T, A, B, C, D, E$, F$, G> f) {
        return vf.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, ve, Function.curry(f)));
    }

    public <A, B, C, D, E$, F$> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf) {
        return this.accumulate(s2, va, vb, vc, vd, ve, vf, new F7<T, A, B, C, D, E$, F$, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e, F$ f) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F<T, F<A, F<B, F<C, F<D, F<E$, F<F$, F<G, H>>>>>>>> f) {
        return vg.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, ve, vf, f));
    }

    public <A, B, C, D, E$, F$, G, H> Validation<E, H> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg, F8<T, A, B, C, D, E$, F$, G, H> f) {
        return vg.accumapply(s2, this.accumulate(s2, va, vb, vc, vd, ve, vf, Function.curry(f)));
    }

    public <A, B, C, D, E$, F$, G> Option<E> accumulate(Semigroup<E> s2, Validation<E, A> va, Validation<E, B> vb, Validation<E, C> vc, Validation<E, D> vd, Validation<E, E$> ve, Validation<E, F$> vf, Validation<E, G> vg) {
        return this.accumulate(s2, va, vb, vc, vd, ve, vf, vg, new F8<T, A, B, C, D, E$, F$, G, Unit>(){

            @Override
            public Unit f(T t, A a, B b, C c, D d, E$ e, F$ f, G g2) {
                return Unit.unit();
            }
        }).f().toOption();
    }

    @Override
    public Iterator<T> iterator() {
        return this.toEither().right().iterator();
    }

    public Validation<List<E>, T> accumulate() {
        if (this.isFail()) {
            return Validation.fail(List.single(this.fail()));
        }
        return Validation.success(this.success());
    }

    public <B> Validation<List<E>, B> accumulate(F<T, B> f) {
        if (this.isFail()) {
            return Validation.fail(List.single(this.fail()));
        }
        return Validation.success(f.f(this.success()));
    }

    public <B, C> Validation<List<E>, C> accumulate(Validation<E, B> v2, F2<T, B, C> f) {
        List<E> list = List.nil();
        if (this.isFail()) {
            list = list.cons(this.fail());
        }
        if (v2.isFail()) {
            list = list.cons(v2.fail());
        }
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success()));
    }

    public <B, C, D> Validation<List<E>, D> accumulate(Validation<E, B> v2, Validation<E, C> v3, F3<T, B, C, D> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success()));
    }

    public <B, C, D, $E> Validation<List<E>, E> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, F4<T, B, C, D, E> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success()));
    }

    public <B, C, D, $E, $F> Validation<List<E>, $F> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, F5<T, B, C, D, $E, $F> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success()));
    }

    public <B, C, D, $E, $F, G> Validation<List<E>, G> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, F6<T, B, C, D, $E, $F, G> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success()));
    }

    public <B, C, D, $E, $F, G, H> Validation<List<E>, H> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, Validation<E, G> v7, F7<T, B, C, D, $E, $F, G, H> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success(), v7.success()));
    }

    public <B, C, D, $E, $F, G, H, I> Validation<List<E>, I> accumulate(Validation<E, B> v2, Validation<E, C> v3, Validation<E, D> v4, Validation<E, $E> v5, Validation<E, $F> v6, Validation<E, G> v7, Validation<E, H> v8, F8<T, B, C, D, $E, $F, G, H, I> f) {
        List<E> list = Validation.fails(List.list(this, v2, v3, v4, v5));
        if (!list.isEmpty()) {
            return Validation.fail(list);
        }
        return Validation.success(f.f(this.success(), v2.success(), v3.success(), v4.success(), v5.success(), v6.success(), v7.success(), v8.success()));
    }

    public static <A, E> Validation<List<E>, List<A>> sequence(List<Validation<E, A>> list) {
        F2 f2 = Validation$$Lambda$1.lambdaFactory$();
        return list.foldRight(f2, Validation.success(List.nil()));
    }

    public static <A, E> List<E> fails(List<Validation<E, ?>> list) {
        return list.filter(Validation$$Lambda$2.lambdaFactory$()).map(Validation$$Lambda$3.lambdaFactory$());
    }

    public static <A, E> List<A> successes(List<Validation<?, A>> list) {
        return list.filter(Validation$$Lambda$4.lambdaFactory$()).map(Validation$$Lambda$5.lambdaFactory$());
    }

    public Validation<NonEmptyList<E>, T> nel() {
        return this.isSuccess() ? Validation.success(this.success()) : Validation.fail(NonEmptyList.nel(this.fail()));
    }

    public static <E, T> Validation<E, T> validation(Either<E, T> e) {
        return new Validation<E, T>(e);
    }

    public static <E, T> F<Either<E, T>, Validation<E, T>> validation() {
        return new F<Either<E, T>, Validation<E, T>>(){

            @Override
            public Validation<E, T> f(Either<E, T> e) {
                return Validation.validation(e);
            }
        };
    }

    public static <E, T> F<Validation<E, T>, Either<E, T>> either() {
        return new F<Validation<E, T>, Either<E, T>>(){

            @Override
            public Either<E, T> f(Validation<E, T> v) {
                return v.toEither();
            }
        };
    }

    public static <E, T> Validation<E, T> success(T t) {
        return Validation.validation(Either.right(t));
    }

    public static <E, T> Validation<E, T> fail(E e) {
        return Validation.validation(Either.left(e));
    }

    public static <E, T> Validation<NonEmptyList<E>, T> failNEL(E e) {
        return Validation.fail(NonEmptyList.nel(e));
    }

    public static <E, T> Validation<E, T> condition(boolean c, E e, T t) {
        return c ? Validation.success(t) : Validation.fail(e);
    }

    public static Validation<NumberFormatException, Byte> parseByte(String s2) {
        try {
            return Validation.success(Byte.parseByte(s2));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Double> parseDouble(String s2) {
        try {
            return Validation.success(Double.parseDouble(s2));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Float> parseFloat(String s2) {
        try {
            return Validation.success(Float.valueOf(Float.parseFloat(s2)));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Integer> parseInt(String s2) {
        try {
            return Validation.success(Integer.parseInt(s2));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Long> parseLong(String s2) {
        try {
            return Validation.success(Long.parseLong(s2));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public static Validation<NumberFormatException, Short> parseShort(String s2) {
        try {
            return Validation.success(Short.parseShort(s2));
        }
        catch (NumberFormatException e) {
            return Validation.fail(e);
        }
    }

    public String toString() {
        return Show.validationShow(Show.anyShow(), Show.anyShow()).showS(this);
    }

    private static /* synthetic */ Validation lambda$sequence$41(Validation v, Validation acc) {
        if (acc.isFail() && v.isFail()) {
            return Validation.validation(acc.toEither().left().map(Validation$$Lambda$6.lambdaFactory$(v)));
        }
        if (acc.isSuccess() && v.isSuccess()) {
            return acc.map(Validation$$Lambda$7.lambdaFactory$(v));
        }
        return acc;
    }

    static /* synthetic */ Validation access$lambda$0(Validation validation, Validation validation2) {
        return Validation.lambda$sequence$41(validation, validation2);
    }

    static /* synthetic */ Boolean access$lambda$1(Validation validation) {
        return validation.isFail();
    }

    static /* synthetic */ Object access$lambda$2(Validation validation) {
        return validation.fail();
    }

    static /* synthetic */ Boolean access$lambda$3(Validation validation) {
        return validation.isSuccess();
    }

    static /* synthetic */ Object access$lambda$4(Validation validation) {
        return validation.success();
    }

    static /* synthetic */ List access$lambda$5(Validation validation, List list) {
        return list.cons(validation.fail());
    }

    static /* synthetic */ List access$lambda$6(Validation validation, List list) {
        return list.cons(validation.success());
    }

    public final class FailProjection<E, T>
    implements Iterable<E> {
        private final Validation<E, T> v;

        private FailProjection(Validation<E, T> v) {
            this.v = v;
        }

        public Validation<E, T> validation() {
            return this.v;
        }

        public E failE(P1<String> err) {
            return this.v.toEither().left().valueE(err);
        }

        public E failE(String err) {
            return this.failE(P.p(err));
        }

        public E orFail(P1<E> e) {
            return (E)this.v.toEither().left().orValue((E)e);
        }

        public E orFail(E e) {
            return (E)this.orFail((E)P.p(e));
        }

        public E on(F<T, E> f) {
            return this.v.toEither().left().on(f);
        }

        public Unit foreach(F<E, Unit> f) {
            return this.v.toEither().left().foreach(f);
        }

        public void foreachDoEffect(Effect1<E> f) {
            this.v.toEither().left().foreachDoEffect(f);
        }

        public <A> Validation<A, T> map(F<E, A> f) {
            return Validation.validation(this.v.toEither().left().map(f));
        }

        public <A> Validation<A, T> bind(F<E, Validation<A, T>> f) {
            return this.v.isFail() ? f.f(this.v.fail()) : Validation.success(this.v.success());
        }

        public <A> Validation<A, T> sequence(final Validation<A, T> v) {
            return this.bind(new F<E, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(E e) {
                    return v;
                }
            });
        }

        public <A> Option<Validation<E, A>> filter(F<E, Boolean> f) {
            return this.v.toEither().left().filter(f).map(Validation.validation());
        }

        public <A> Validation<A, T> apply(Validation<F<E, A>, T> v) {
            return v.f().bind(new F<F<E, A>, Validation<A, T>>(){

                @Override
                public Validation<A, T> f(F<E, A> f) {
                    return FailProjection.this.map(f);
                }
            });
        }

        public boolean forall(F<E, Boolean> f) {
            return this.v.toEither().left().forall(f);
        }

        public boolean exists(F<E, Boolean> f) {
            return this.v.toEither().left().exists(f);
        }

        public List<E> toList() {
            return this.v.toEither().left().toList();
        }

        public Option<E> toOption() {
            return this.v.toEither().left().toOption();
        }

        public Array<E> toArray() {
            return this.v.toEither().left().toArray();
        }

        public Stream<E> toStream() {
            return this.v.toEither().left().toStream();
        }

        @Override
        public Iterator<E> iterator() {
            return this.v.toEither().left().iterator();
        }
    }
}

