/*
 * Decompiled with CFR 0.152.
 */
package heros.fieldsens;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import heros.fieldsens.AccessPath;
import heros.fieldsens.AccessPathHandler;
import heros.fieldsens.CallEdge;
import heros.fieldsens.CallEdgeResolver;
import heros.fieldsens.Context;
import heros.fieldsens.ControlFlowJoinResolver;
import heros.fieldsens.Debugger;
import heros.fieldsens.FlowFunction;
import heros.fieldsens.InterestCallback;
import heros.fieldsens.MethodAnalyzer;
import heros.fieldsens.Resolver;
import heros.fieldsens.ReturnSiteResolver;
import heros.fieldsens.ZeroCallEdgeResolver;
import heros.fieldsens.structs.FactAtStatement;
import heros.fieldsens.structs.WrappedFact;
import heros.fieldsens.structs.WrappedFactAtStatement;
import heros.utilities.DefaultValueMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> {
    private static final Logger logger = LoggerFactory.getLogger(PerAccessPathMethodAnalyzer.class);
    private Fact sourceFact;
    private final AccessPath<Field> accessPath;
    private Map<WrappedFactAtStatement<Field, Fact, Stmt, Method>, WrappedFactAtStatement<Field, Fact, Stmt, Method>> reachableStatements = Maps.newHashMap();
    private List<WrappedFactAtStatement<Field, Fact, Stmt, Method>> summaries = Lists.newLinkedList();
    private Context<Field, Fact, Stmt, Method> context;
    private Method method;
    private DefaultValueMap<FactAtStatement<Fact, Stmt>, ReturnSiteResolver<Field, Fact, Stmt, Method>> returnSiteResolvers = new DefaultValueMap<FactAtStatement<Fact, Stmt>, ReturnSiteResolver<Field, Fact, Stmt, Method>>(){

        @Override
        protected ReturnSiteResolver<Field, Fact, Stmt, Method> createItem(FactAtStatement<Fact, Stmt> key) {
            return new ReturnSiteResolver(((PerAccessPathMethodAnalyzer)PerAccessPathMethodAnalyzer.this).context.factHandler, PerAccessPathMethodAnalyzer.this, key.stmt, PerAccessPathMethodAnalyzer.this.debugger);
        }
    };
    private DefaultValueMap<FactAtStatement<Fact, Stmt>, ControlFlowJoinResolver<Field, Fact, Stmt, Method>> ctrFlowJoinResolvers = new DefaultValueMap<FactAtStatement<Fact, Stmt>, ControlFlowJoinResolver<Field, Fact, Stmt, Method>>(){

        @Override
        protected ControlFlowJoinResolver<Field, Fact, Stmt, Method> createItem(FactAtStatement<Fact, Stmt> key) {
            return new ControlFlowJoinResolver(((PerAccessPathMethodAnalyzer)PerAccessPathMethodAnalyzer.this).context.factHandler, PerAccessPathMethodAnalyzer.this, key.stmt, PerAccessPathMethodAnalyzer.this.debugger);
        }
    };
    private CallEdgeResolver<Field, Fact, Stmt, Method> callEdgeResolver;
    private PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> parent;
    private Debugger<Field, Fact, Stmt, Method> debugger;

    public PerAccessPathMethodAnalyzer(Method method, Fact sourceFact, Context<Field, Fact, Stmt, Method> context, Debugger<Field, Fact, Stmt, Method> debugger) {
        this(method, sourceFact, context, debugger, new AccessPath(), null);
    }

    private PerAccessPathMethodAnalyzer(Method method, Fact sourceFact, Context<Field, Fact, Stmt, Method> context, Debugger<Field, Fact, Stmt, Method> debugger, AccessPath<Field> accPath, PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> parent) {
        this.debugger = debugger;
        if (method == null) {
            throw new IllegalArgumentException("Method must be not null");
        }
        this.parent = parent;
        this.method = method;
        this.sourceFact = sourceFact;
        this.accessPath = accPath;
        this.context = context;
        this.callEdgeResolver = parent == null ? (this.isZeroSource() ? new ZeroCallEdgeResolver(this, context.zeroHandler, debugger) : new CallEdgeResolver<Field, Fact, Stmt, Method>(this, debugger)) : (this.isZeroSource() ? parent.callEdgeResolver : new CallEdgeResolver<Field, Fact, Stmt, Method>(this, debugger, parent.callEdgeResolver));
        this.log("initialized");
    }

    public PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> createWithAccessPath(AccessPath<Field> accPath) {
        return new PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method>(this.method, this.sourceFact, this.context, this.debugger, accPath, this);
    }

    WrappedFact<Field, Fact, Stmt, Method> wrappedSource() {
        return new WrappedFact<Field, Fact, Stmt, Method>(this.sourceFact, this.accessPath, this.callEdgeResolver);
    }

    public AccessPath<Field> getAccessPath() {
        return this.accessPath;
    }

    private boolean isBootStrapped() {
        return this.callEdgeResolver.hasIncomingEdges() || !this.accessPath.isEmpty();
    }

    private void bootstrapAtMethodStartPoints() {
        this.callEdgeResolver.interest(this.callEdgeResolver);
        for (Object startPoint : this.context.icfg.getStartPointsOf(this.method)) {
            WrappedFactAtStatement target = new WrappedFactAtStatement(startPoint, this.wrappedSource());
            if (this.reachableStatements.containsKey(target)) continue;
            this.scheduleEdgeTo(target);
        }
    }

    public void addInitialSeed(Stmt stmt) {
        this.scheduleEdgeTo(new WrappedFactAtStatement<Field, Fact, Stmt, Method>(stmt, this.wrappedSource()));
    }

    private void scheduleEdgeTo(Collection<Stmt> successors, WrappedFact<Field, Fact, Stmt, Method> fact) {
        for (Stmt stmt : successors) {
            this.scheduleEdgeTo(new WrappedFactAtStatement<Field, Fact, Stmt, Method>(stmt, fact));
        }
    }

    void scheduleEdgeTo(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        assert (this.context.icfg.getMethodOf(factAtStmt.getStatement()).equals(this.method));
        if (this.reachableStatements.containsKey(factAtStmt)) {
            this.log("Merging " + factAtStmt);
            this.context.factHandler.merge(this.reachableStatements.get(factAtStmt).getWrappedFact().getFact(), factAtStmt.getWrappedFact().getFact());
        } else {
            this.log("Edge to " + factAtStmt);
            this.reachableStatements.put(factAtStmt, factAtStmt);
            this.context.scheduler.schedule(new Job(factAtStmt));
            this.debugger.edgeTo(this, factAtStmt);
        }
    }

    void log(String message) {
        logger.trace("[{}; {}{}: " + message + "]", this.method, this.sourceFact, this.accessPath);
    }

    public String toString() {
        return this.method + "; " + this.sourceFact + this.accessPath;
    }

    void processCall(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        Collection calledMethods = this.context.icfg.getCalleesOfCallAt(factAtStmt.getStatement());
        for (Object calledMethod : calledMethods) {
            FlowFunction flowFunction = this.context.flowFunctions.getCallFlowFunction(factAtStmt.getStatement(), calledMethod);
            Set targetFacts = flowFunction.computeTargets(factAtStmt.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(factAtStmt.getAccessPath(), factAtStmt.getResolver(), this.debugger));
            for (FlowFunction.ConstrainedFact constrainedFact : targetFacts) {
                MethodAnalyzer<Field, Fact, Stmt, Method> analyzer = this.context.getAnalyzer(calledMethod);
                analyzer.addIncomingEdge(new CallEdge<Field, Fact, Stmt, Method>(this, factAtStmt, constrainedFact.getFact()));
            }
        }
        this.processCallToReturnEdge(factAtStmt);
    }

    void processExit(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        this.log("New Summary: " + factAtStmt);
        if (!this.summaries.add(factAtStmt)) {
            throw new AssertionError();
        }
        this.callEdgeResolver.applySummaries(factAtStmt);
        if (this.context.followReturnsPastSeeds && this.isZeroSource()) {
            Collection callSites = this.context.icfg.getCallersOf(this.method);
            for (Object callSite : callSites) {
                Collection returnSites = this.context.icfg.getReturnSitesOfCallAt(callSite);
                for (Object returnSite : returnSites) {
                    FlowFunction flowFunction = this.context.flowFunctions.getReturnFlowFunction(callSite, this.method, factAtStmt.getStatement(), returnSite);
                    Set targetFacts = flowFunction.computeTargets(factAtStmt.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(factAtStmt.getAccessPath(), factAtStmt.getResolver(), this.debugger));
                    for (FlowFunction.ConstrainedFact constrainedFact : targetFacts) {
                        this.context.getAnalyzer(this.context.icfg.getMethodOf(callSite)).addUnbalancedReturnFlow(new WrappedFactAtStatement(returnSite, constrainedFact.getFact()), callSite);
                    }
                }
            }
            if (callSites.isEmpty()) {
                FlowFunction flowFunction = this.context.flowFunctions.getReturnFlowFunction(null, this.method, factAtStmt.getStatement(), null);
                flowFunction.computeTargets(factAtStmt.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(factAtStmt.getAccessPath(), factAtStmt.getResolver(), this.debugger));
            }
        }
    }

    private void processCallToReturnEdge(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        if (this.isLoopStart(factAtStmt.getStatement())) {
            this.ctrFlowJoinResolvers.getOrCreate(factAtStmt.getAsFactAtStatement()).addIncoming(factAtStmt.getWrappedFact());
        } else {
            this.processNonJoiningCallToReturnFlow(factAtStmt);
        }
    }

    private void processNonJoiningCallToReturnFlow(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        Collection returnSites = this.context.icfg.getReturnSitesOfCallAt(factAtStmt.getStatement());
        for (Object returnSite : returnSites) {
            FlowFunction flowFunction = this.context.flowFunctions.getCallToReturnFlowFunction(factAtStmt.getStatement(), returnSite);
            Set targetFacts = flowFunction.computeTargets(factAtStmt.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(factAtStmt.getAccessPath(), factAtStmt.getResolver(), this.debugger));
            for (FlowFunction.ConstrainedFact constrainedFact : targetFacts) {
                this.scheduleEdgeTo(new WrappedFactAtStatement(returnSite, constrainedFact.getFact()));
            }
        }
    }

    private void processNormalFlow(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        if (this.isLoopStart(factAtStmt.getStatement())) {
            this.ctrFlowJoinResolvers.getOrCreate(factAtStmt.getAsFactAtStatement()).addIncoming(factAtStmt.getWrappedFact());
        } else {
            this.processNormalNonJoiningFlow(factAtStmt);
        }
    }

    private boolean isLoopStart(Stmt stmt) {
        int numberOfPredecessors = this.context.icfg.getPredsOf(stmt).size();
        if (numberOfPredecessors > 1 && !this.context.icfg.isExitStmt(stmt) || this.context.icfg.isStartPoint(stmt) && numberOfPredecessors > 0) {
            HashSet visited = Sets.newHashSet();
            LinkedList worklist = Lists.newLinkedList();
            worklist.addAll(this.context.icfg.getPredsOf(stmt));
            while (!worklist.isEmpty()) {
                Object current = worklist.remove(0);
                if (current.equals(stmt)) {
                    return true;
                }
                if (!visited.add(current)) continue;
                worklist.addAll(this.context.icfg.getPredsOf(current));
            }
        }
        return false;
    }

    void processFlowFromJoinStmt(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        if (this.context.icfg.isCallStmt(factAtStmt.getStatement())) {
            this.processNonJoiningCallToReturnFlow(factAtStmt);
        } else {
            this.processNormalNonJoiningFlow(factAtStmt);
        }
    }

    private void processNormalNonJoiningFlow(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
        final List successors = this.context.icfg.getSuccsOf(factAtStmt.getStatement());
        FlowFunction flowFunction = this.context.flowFunctions.getNormalFlowFunction(factAtStmt.getStatement());
        Set targetFacts = flowFunction.computeTargets(factAtStmt.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(factAtStmt.getAccessPath(), factAtStmt.getResolver(), this.debugger));
        for (final FlowFunction.ConstrainedFact constrainedFact : targetFacts) {
            if (constrainedFact.getConstraint() == null) {
                this.scheduleEdgeTo(successors, constrainedFact.getFact());
                continue;
            }
            constrainedFact.getFact().getResolver().resolve(constrainedFact.getConstraint(), new InterestCallback<Field, Fact, Stmt, Method>(){

                @Override
                public void interest(PerAccessPathMethodAnalyzer<Field, Fact, Stmt, Method> analyzer, Resolver<Field, Fact, Stmt, Method> resolver) {
                    analyzer.scheduleEdgeTo(successors, new WrappedFact(constrainedFact.getFact().getFact(), constrainedFact.getFact().getAccessPath(), resolver));
                }

                @Override
                public void canBeResolvedEmpty() {
                    PerAccessPathMethodAnalyzer.this.callEdgeResolver.resolve(constrainedFact.getConstraint(), this);
                }
            });
        }
    }

    public void addIncomingEdge(CallEdge<Field, Fact, Stmt, Method> incEdge) {
        if (this.isBootStrapped()) {
            this.context.factHandler.merge(this.sourceFact, incEdge.getCalleeSourceFact().getFact());
        } else {
            this.bootstrapAtMethodStartPoints();
        }
        this.callEdgeResolver.addIncoming(incEdge);
    }

    void applySummary(CallEdge<Field, Fact, Stmt, Method> incEdge, WrappedFactAtStatement<Field, Fact, Stmt, Method> exitFact) {
        Collection returnSites = this.context.icfg.getReturnSitesOfCallAt(incEdge.getCallSite());
        for (Object returnSite : returnSites) {
            FlowFunction flowFunction = this.context.flowFunctions.getReturnFlowFunction(incEdge.getCallSite(), this.method, exitFact.getStatement(), returnSite);
            Set targets = flowFunction.computeTargets(exitFact.getFact(), new AccessPathHandler<Field, Fact, Stmt, Method>(exitFact.getAccessPath(), exitFact.getResolver(), this.debugger));
            for (FlowFunction.ConstrainedFact targetFact : targets) {
                this.context.factHandler.restoreCallingContext(targetFact.getFact().getFact(), incEdge.getCallerCallSiteFact().getFact());
                this.scheduleReturnEdge(incEdge, targetFact.getFact(), returnSite);
            }
        }
    }

    public void scheduleUnbalancedReturnEdgeTo(WrappedFactAtStatement<Field, Fact, Stmt, Method> fact) {
        ReturnSiteResolver<Field, Fact, Stmt, Method> resolver = this.returnSiteResolvers.getOrCreate(fact.getAsFactAtStatement());
        resolver.addIncoming(new WrappedFact<Field, Fact, Stmt, Method>(fact.getWrappedFact().getFact(), fact.getWrappedFact().getAccessPath(), fact.getWrappedFact().getResolver()), null, AccessPath.Delta.empty());
    }

    private void scheduleReturnEdge(CallEdge<Field, Fact, Stmt, Method> incEdge, WrappedFact<Field, Fact, Stmt, Method> fact, Stmt returnSite) {
        AccessPath.Delta<Field> delta = this.accessPath.getDeltaTo(incEdge.getCalleeSourceFact().getAccessPath());
        ReturnSiteResolver<Field, Fact, Stmt, Method> returnSiteResolver = incEdge.getCallerAnalyzer().returnSiteResolvers.getOrCreate(new FactAtStatement<Fact, Stmt>(fact.getFact(), returnSite));
        returnSiteResolver.addIncoming(fact, incEdge.getCalleeSourceFact().getResolver(), delta);
    }

    void applySummaries(CallEdge<Field, Fact, Stmt, Method> incEdge) {
        for (WrappedFactAtStatement<Field, Fact, Stmt, Method> summary : this.summaries) {
            this.applySummary(incEdge, summary);
        }
    }

    public boolean isZeroSource() {
        return this.sourceFact.equals(this.context.zeroValue);
    }

    public CallEdgeResolver<Field, Fact, Stmt, Method> getCallEdgeResolver() {
        return this.callEdgeResolver;
    }

    public Method getMethod() {
        return this.method;
    }

    private class Job
    implements Runnable {
        private WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt;

        public Job(WrappedFactAtStatement<Field, Fact, Stmt, Method> factAtStmt) {
            this.factAtStmt = factAtStmt;
            PerAccessPathMethodAnalyzer.this.debugger.newJob(PerAccessPathMethodAnalyzer.this, factAtStmt);
        }

        @Override
        public void run() {
            PerAccessPathMethodAnalyzer.this.debugger.jobStarted(PerAccessPathMethodAnalyzer.this, this.factAtStmt);
            if (((PerAccessPathMethodAnalyzer)PerAccessPathMethodAnalyzer.this).context.icfg.isCallStmt(this.factAtStmt.getStatement())) {
                PerAccessPathMethodAnalyzer.this.processCall(this.factAtStmt);
            } else {
                if (((PerAccessPathMethodAnalyzer)PerAccessPathMethodAnalyzer.this).context.icfg.isExitStmt(this.factAtStmt.getStatement())) {
                    PerAccessPathMethodAnalyzer.this.processExit(this.factAtStmt);
                }
                if (!((PerAccessPathMethodAnalyzer)PerAccessPathMethodAnalyzer.this).context.icfg.getSuccsOf(this.factAtStmt.getStatement()).isEmpty()) {
                    PerAccessPathMethodAnalyzer.this.processNormalFlow(this.factAtStmt);
                }
            }
            PerAccessPathMethodAnalyzer.this.debugger.jobFinished(PerAccessPathMethodAnalyzer.this, this.factAtStmt);
        }

        public String toString() {
            return "Job: " + this.factAtStmt;
        }
    }
}

