/*
 * Decompiled with CFR 0.152.
 */
package polyglot.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import polyglot.util.FormatResult;
import polyglot.util.Item;
import polyglot.util.MaxLevels;
import polyglot.util.Overrun;
import polyglot.util.TextItem;

class BlockItem
extends Item {
    BlockItem parent;
    Item first;
    Item last;
    int indent;
    Map containsBreaks = new HashMap();

    BlockItem(BlockItem parent_, int indent_) {
        this.parent = parent_;
        this.last = null;
        this.first = null;
        this.indent = indent_;
    }

    void add(Item it) {
        if (this.first == null) {
            this.first = it;
        } else {
            if (it instanceof TextItem && this.last instanceof TextItem) {
                TextItem lasts = (TextItem)this.last;
                lasts.appendTextItem((TextItem)it);
                return;
            }
            this.last.next = it;
        }
        this.last = it;
    }

    FormatResult formatN(int lmargin, int pos, int rmargin, int fin, MaxLevels m3, int minLevel, int minLevelUnified) throws Overrun {
        int childfin = fin;
        if (childfin + BlockItem.getMinPosWidth(this.next, m3) > rmargin) {
            childfin = rmargin - BlockItem.getMinPosWidth(this.next, m3);
        }
        while (true) {
            FormatResult fr = BlockItem.format(this.first, pos + this.indent, pos, rmargin, childfin, new MaxLevels(m3.maxLevelInner, m3.maxLevelInner), 0, 0);
            int minLevel2 = Math.max(minLevel, fr.minLevel);
            int minLevelU2 = Math.max(minLevelUnified, fr.minLevel);
            try {
                return BlockItem.format(this.next, lmargin, fr.pos, rmargin, fin, m3, minLevel2, minLevelU2);
            }
            catch (Overrun o) {
                if (o.type == 1) {
                    o.type = 2;
                    throw o;
                }
                childfin -= o.amount;
                continue;
            }
            break;
        }
    }

    int sendOutput(PrintWriter o, int lmargin, int pos, boolean success, Item last) throws IOException {
        Item it = this.first;
        lmargin = pos + this.indent;
        while (it != null) {
            pos = it.sendOutput(o, lmargin, pos, success, last);
            if (last != null && it == last) {
                throw new IOException();
            }
            it = it.next;
        }
        return pos;
    }

    int selfMinWidth(MaxLevels m3) {
        return BlockItem.getMinWidth(this.first, new MaxLevels(m3.maxLevelInner, m3.maxLevelInner));
    }

    int selfMinPosWidth(MaxLevels m3) {
        return BlockItem.getMinPosWidth(this.first, new MaxLevels(m3.maxLevelInner, m3.maxLevelInner));
    }

    int selfMinIndent(MaxLevels m3) {
        return BlockItem.getMinIndent(this.first, new MaxLevels(m3.maxLevelInner, m3.maxLevelInner));
    }

    boolean selfContainsBreaks(MaxLevels m3) {
        if (this.containsBreaks.containsKey(m3)) {
            return this.containsBreaks.get(m3) != null;
        }
        boolean result = BlockItem.containsBreaks(this.first, new MaxLevels(m3.maxLevelInner, m3.maxLevelInner));
        this.containsBreaks.put(m3, result ? m3 : null);
        return result;
    }

    String selfToString() {
        if (this.indent == 0) {
            return "[" + this.first + "]";
        }
        return "[" + this.indent + this.first + "]";
    }
}

