/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import soot.Body;
import soot.Modifier;
import soot.PackManager;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.asm.AsmUtil;
import soot.baf.BafBody;
import soot.jimple.JimpleBody;
import soot.options.Options;
import soot.tagkit.AnnotationAnnotationElem;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.Attribute;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.Host;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.OuterClassTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;
import soot.util.backend.ASMBackendUtils;
import soot.util.backend.SootASMClassWriter;

public abstract class AbstractASMBackend {
    private final Map<SootMethod, BafBody> bafBodyCache = new HashMap<SootMethod, BafBody>();
    protected final SootClass sc;
    protected final int javaVersion;
    protected ClassVisitor cv;

    public AbstractASMBackend(SootClass sc, int javaVersion) {
        this.sc = sc;
        if (javaVersion == 0) {
            javaVersion = 1;
        }
        int minVersion = this.getMinJavaVersion(sc);
        if (javaVersion != 1 && javaVersion < minVersion) {
            throw new IllegalArgumentException("Enforced Java version " + ASMBackendUtils.translateJavaVersion(javaVersion) + " too low to support required features (" + ASMBackendUtils.translateJavaVersion(minVersion) + " required)");
        }
        this.javaVersion = AsmUtil.javaToBytecodeVersion(Math.max(javaVersion, minVersion));
    }

    protected BafBody getBafBody(SootMethod method) {
        Body activeBody = method.getActiveBody();
        if (activeBody instanceof BafBody) {
            return (BafBody)activeBody;
        }
        BafBody body = this.bafBodyCache.get(method);
        if (body != null) {
            return body;
        }
        if (!(activeBody instanceof JimpleBody)) {
            throw new RuntimeException("ASM-backend can only translate Baf and Jimple bodies! Found " + (activeBody == null ? "null" : activeBody.getClass().getName()) + '.');
        }
        body = PackManager.v().convertJimpleBodyToBaf(method);
        this.bafBodyCache.put(method, body);
        return body;
    }

    private int getMinJavaVersion(SootClass sc) {
        int minVersion = 2;
        if (Modifier.isAnnotation(sc.getModifiers()) || sc.hasTag("VisibilityAnnotationTag")) {
            minVersion = 6;
        }
        if (AbstractASMBackend.containsGenericSignatureTag(sc)) {
            minVersion = 6;
        }
        for (SootField sf : sc.getFields()) {
            if (minVersion >= 6) break;
            if (sf.hasTag("VisibilityAnnotationTag")) {
                minVersion = 6;
            }
            if (!AbstractASMBackend.containsGenericSignatureTag(sf)) continue;
            minVersion = 6;
        }
        for (SootMethod sm : new ArrayList<SootMethod>(sc.getMethods())) {
            if (minVersion >= 9) break;
            if (sm.hasTag("VisibilityAnnotationTag") || sm.hasTag("VisibilityParameterAnnotationTag")) {
                minVersion = Math.max(minVersion, 6);
            }
            if (AbstractASMBackend.containsGenericSignatureTag(sm)) {
                minVersion = Math.max(minVersion, 6);
            }
            if (!sm.hasActiveBody()) continue;
            minVersion = Math.max(minVersion, this.getMinJavaVersion(sm));
        }
        return minVersion;
    }

    private static boolean containsGenericSignatureTag(Host h2) {
        SignatureTag t = (SignatureTag)h2.getTag("SignatureTag");
        return t != null && t.getSignature().indexOf(60) >= 0;
    }

    protected int getMinJavaVersion(SootMethod sm) {
        return 8;
    }

    public void generateClassFile(OutputStream os) {
        SootASMClassWriter cw = new SootASMClassWriter(2);
        this.cv = cw;
        this.generateByteCode();
        try {
            os.write(cw.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write class file in the ASM-backend!", e);
        }
    }

    public void generateTextualRepresentation(PrintWriter pw) {
        this.cv = new TraceClassVisitor(pw);
        this.generateByteCode();
    }

    protected void generateByteCode() {
        SourceFileTag t;
        this.generateClassHeader();
        if (!Options.v().no_output_source_file_attribute() && (t = (SourceFileTag)this.sc.getTag("SourceFileTag")) != null) {
            this.cv.visitSource(t.getSourceFile(), null);
        }
        if (this.sc.hasOuterClass() || this.sc.hasTag("EnclosingMethodTag") || this.sc.hasTag("OuterClassTag")) {
            this.generateOuterClassReference();
        }
        this.generateAnnotations(this.cv, this.sc);
        this.generateAttributes();
        this.generateInnerClassReferences();
        this.generateFields();
        this.generateMethods();
        this.cv.visitEnd();
    }

    protected void generateMethods() {
        ArrayList<SootMethod> sortedMethods = new ArrayList<SootMethod>(this.sc.getMethods());
        Collections.sort(sortedMethods, new SootMethodComparator());
        for (SootMethod sm : sortedMethods) {
            MethodVisitor mv;
            String[] exceptions;
            if (sm.isPhantom()) continue;
            int access = AbstractASMBackend.getModifiers(sm.getModifiers(), sm);
            String name = sm.getName();
            StringBuilder descBuilder = new StringBuilder(5);
            descBuilder.append('(');
            for (Type t : sm.getParameterTypes()) {
                descBuilder.append(ASMBackendUtils.toTypeDesc(t));
            }
            descBuilder.append(')');
            descBuilder.append(ASMBackendUtils.toTypeDesc(sm.getReturnType()));
            SignatureTag sigTag = (SignatureTag)sm.getTag("SignatureTag");
            String sig = sigTag == null ? null : sigTag.getSignature();
            List<SootClass> exceptionList = sm.getExceptionsUnsafe();
            if (exceptionList != null) {
                exceptions = new String[exceptionList.size()];
                int i = 0;
                for (SootClass exc : exceptionList) {
                    exceptions[i] = ASMBackendUtils.slashify(exc.getName());
                    ++i;
                }
            } else {
                exceptions = new String[]{};
            }
            if ((mv = this.cv.visitMethod(access, name, descBuilder.toString(), sig, exceptions)) == null) continue;
            for (Tag t : sm.getTags()) {
                VisibilityParameterAnnotationTag vpt;
                ArrayList<VisibilityAnnotationTag> tags;
                if (!(t instanceof VisibilityParameterAnnotationTag) || (tags = (vpt = (VisibilityParameterAnnotationTag)t).getVisibilityAnnotations()) == null) continue;
                for (int j = 0; j < tags.size(); ++j) {
                    VisibilityAnnotationTag va = tags.get(j);
                    if (va == null) continue;
                    for (AnnotationTag at : va.getAnnotations()) {
                        AnnotationVisitor av = mv.visitParameterAnnotation(j, at.getType(), va.getVisibility() == 0);
                        this.generateAnnotationElems(av, at.getElems(), true);
                    }
                }
            }
            this.generateAnnotations(mv, sm);
            this.generateAttributes(mv, sm);
            if (sm.hasActiveBody()) {
                mv.visitCode();
                this.generateMethodBody(mv, sm);
                mv.visitMaxs(0, 0);
            }
            mv.visitEnd();
        }
    }

    protected void generateFields() {
        for (SootField f : this.sc.getFields()) {
            if (f.isPhantom()) continue;
            String name = f.getName();
            String desc = ASMBackendUtils.toTypeDesc(f.getType());
            SignatureTag sigTag = (SignatureTag)f.getTag("SignatureTag");
            String sig = sigTag == null ? null : sigTag.getSignature();
            Object value = ASMBackendUtils.getDefaultValue(f);
            int access = AbstractASMBackend.getModifiers(f.getModifiers(), f);
            FieldVisitor fv = this.cv.visitField(access, name, desc, sig, value);
            if (fv == null) continue;
            this.generateAnnotations(fv, f);
            this.generateAttributes(fv, f);
            fv.visitEnd();
        }
    }

    protected void generateInnerClassReferences() {
        if (!Options.v().no_output_inner_classes_attribute()) {
            InnerClassAttribute ica = (InnerClassAttribute)this.sc.getTag("InnerClassAttribute");
            if (ica != null) {
                ArrayList<InnerClassTag> sortedTags = new ArrayList<InnerClassTag>(ica.getSpecs());
                Collections.sort(sortedTags, new SootInnerClassComparator());
                this.writeInnerClassTags(sortedTags);
            } else {
                List<InnerClassTag> sortedTags = this.sc.getTags().stream().filter(t -> t instanceof InnerClassTag).map(t -> (InnerClassTag)t).sorted(new SootInnerClassComparator()).collect(Collectors.toList());
                this.writeInnerClassTags(sortedTags);
            }
        }
    }

    protected void writeInnerClassTags(List<InnerClassTag> sortedTags) {
        for (InnerClassTag ict : sortedTags) {
            String name = ASMBackendUtils.slashify(ict.getInnerClass());
            String outerClassName = ASMBackendUtils.slashify(ict.getOuterClass());
            String innerName = ASMBackendUtils.slashify(ict.getShortName());
            int access = ict.getAccessFlags();
            this.cv.visitInnerClass(name, outerClassName, innerName, access);
        }
    }

    protected void generateAttributes() {
        for (Tag t : this.sc.getTags()) {
            if (!(t instanceof Attribute)) continue;
            this.cv.visitAttribute(ASMBackendUtils.createASMAttribute((Attribute)t));
        }
    }

    protected void generateAttributes(FieldVisitor fv, SootField f) {
        for (Tag t : f.getTags()) {
            if (!(t instanceof Attribute)) continue;
            fv.visitAttribute(ASMBackendUtils.createASMAttribute((Attribute)t));
        }
    }

    protected void generateAttributes(MethodVisitor mv, SootMethod m3) {
        for (Tag t : m3.getTags()) {
            if (!(t instanceof Attribute)) continue;
            mv.visitAttribute(ASMBackendUtils.createASMAttribute((Attribute)t));
        }
    }

    protected void generateAnnotations(Object visitor, Host host) {
        for (Tag t : host.getTags()) {
            if (t instanceof VisibilityAnnotationTag) {
                VisibilityAnnotationTag vat = (VisibilityAnnotationTag)t;
                boolean runTimeVisible = vat.getVisibility() == 0;
                for (AnnotationTag at : vat.getAnnotations()) {
                    AnnotationVisitor av = null;
                    if (visitor instanceof ClassVisitor) {
                        av = ((ClassVisitor)visitor).visitAnnotation(at.getType(), runTimeVisible);
                    } else if (visitor instanceof FieldVisitor) {
                        av = ((FieldVisitor)visitor).visitAnnotation(at.getType(), runTimeVisible);
                    } else if (visitor instanceof MethodVisitor) {
                        av = ((MethodVisitor)visitor).visitAnnotation(at.getType(), runTimeVisible);
                    }
                    this.generateAnnotationElems(av, at.getElems(), true);
                }
                continue;
            }
            if (!(t instanceof AnnotationDefaultTag) || !(host instanceof SootMethod)) continue;
            AnnotationDefaultTag adt = (AnnotationDefaultTag)t;
            AnnotationVisitor av = ((MethodVisitor)visitor).visitAnnotationDefault();
            this.generateAnnotationElems(av, Collections.singleton(adt.getDefaultVal()), true);
        }
    }

    protected void generateAnnotationElems(AnnotationVisitor av, Collection<AnnotationElem> elements, boolean addName) {
        if (av != null) {
            for (AnnotationElem elem : elements) {
                assert (elem != null);
                if (elem instanceof AnnotationEnumElem) {
                    AnnotationEnumElem enumElem = (AnnotationEnumElem)elem;
                    av.visitEnum(enumElem.getName(), enumElem.getTypeName(), enumElem.getConstantName());
                    continue;
                }
                if (elem instanceof AnnotationArrayElem) {
                    AnnotationArrayElem arrayElem = (AnnotationArrayElem)elem;
                    AnnotationVisitor arrayVisitor = av.visitArray(arrayElem.getName());
                    this.generateAnnotationElems(arrayVisitor, arrayElem.getValues(), false);
                    continue;
                }
                if (elem instanceof AnnotationAnnotationElem) {
                    AnnotationAnnotationElem aElem = (AnnotationAnnotationElem)elem;
                    AnnotationVisitor aVisitor = av.visitAnnotation(aElem.getName(), aElem.getValue().getType());
                    this.generateAnnotationElems(aVisitor, aElem.getValue().getElems(), true);
                    continue;
                }
                Object val = null;
                if (elem instanceof AnnotationIntElem) {
                    AnnotationIntElem intElem = (AnnotationIntElem)elem;
                    int value = intElem.getValue();
                    switch (intElem.getKind()) {
                        case 'B': {
                            val = (byte)value;
                            break;
                        }
                        case 'Z': {
                            val = value == 1;
                            break;
                        }
                        case 'I': {
                            val = value;
                            break;
                        }
                        case 'S': {
                            val = (short)value;
                            break;
                        }
                        case 'C': {
                            val = Character.valueOf((char)value);
                            break;
                        }
                        default: {
                            assert (false) : "Unexpected kind: " + intElem.getKind() + " (in " + intElem + ")";
                            {
                                break;
                            }
                        }
                    }
                } else if (elem instanceof AnnotationBooleanElem) {
                    AnnotationBooleanElem booleanElem = (AnnotationBooleanElem)elem;
                    val = booleanElem.getValue();
                } else if (elem instanceof AnnotationFloatElem) {
                    AnnotationFloatElem floatElem = (AnnotationFloatElem)elem;
                    val = Float.valueOf(floatElem.getValue());
                } else if (elem instanceof AnnotationLongElem) {
                    AnnotationLongElem longElem = (AnnotationLongElem)elem;
                    val = longElem.getValue();
                } else if (elem instanceof AnnotationDoubleElem) {
                    AnnotationDoubleElem doubleElem = (AnnotationDoubleElem)elem;
                    val = doubleElem.getValue();
                } else if (elem instanceof AnnotationStringElem) {
                    AnnotationStringElem stringElem = (AnnotationStringElem)elem;
                    val = stringElem.getValue();
                } else if (elem instanceof AnnotationClassElem) {
                    AnnotationClassElem classElem = (AnnotationClassElem)elem;
                    val = org.objectweb.asm.Type.getType(classElem.getDesc());
                }
                if (addName) {
                    av.visit(elem.getName(), val);
                    continue;
                }
                av.visit(null, val);
            }
            av.visitEnd();
        }
    }

    protected void generateOuterClassReference() {
        OuterClassTag oct;
        String outerClassName = ASMBackendUtils.slashify(this.sc.getOuterClass().getName());
        String enclosingMethod = null;
        String enclosingMethodSig = null;
        EnclosingMethodTag emTag = (EnclosingMethodTag)this.sc.getTag("EnclosingMethodTag");
        if (emTag != null) {
            if (!this.sc.hasOuterClass()) {
                outerClassName = ASMBackendUtils.slashify(emTag.getEnclosingClass());
            }
            enclosingMethod = emTag.getEnclosingMethod();
            enclosingMethodSig = emTag.getEnclosingMethodSig();
        }
        if (!this.sc.hasOuterClass() && (oct = (OuterClassTag)this.sc.getTag("OuterClassTag")) != null) {
            outerClassName = ASMBackendUtils.slashify(oct.getName());
        }
        this.cv.visitOuterClass(outerClassName, enclosingMethod, enclosingMethodSig);
    }

    protected void generateClassHeader() {
        int modifier = AbstractASMBackend.getModifiers(this.sc.getModifiers(), this.sc);
        String className = ASMBackendUtils.slashify(this.sc.getName());
        SignatureTag sigTag = (SignatureTag)this.sc.getTag("SignatureTag");
        String sig = sigTag == null ? null : sigTag.getSignature();
        String superClass = "java/lang/Object".equals(className) ? null : "java/lang/Object";
        SootClass csuperClass = this.sc.getSuperclassUnsafe();
        if (csuperClass != null) {
            superClass = ASMBackendUtils.slashify(csuperClass.getName());
        }
        String[] interfaces = new String[this.sc.getInterfaceCount()];
        int i = 0;
        for (SootClass interf : this.sc.getInterfaces()) {
            interfaces[i] = ASMBackendUtils.slashify(interf.getName());
            ++i;
        }
        this.cv.visit(this.javaVersion, modifier, className, sig, superClass, interfaces);
    }

    protected static int getModifiers(int modVal, Host host) {
        int modifier = 0;
        if (Modifier.isPublic(modVal)) {
            modifier |= 1;
        } else if (Modifier.isPrivate(modVal)) {
            modifier |= 2;
        } else if (Modifier.isProtected(modVal)) {
            modifier |= 4;
        }
        if (Modifier.isStatic(modVal) && (host instanceof SootField || host instanceof SootMethod)) {
            modifier |= 8;
        }
        if (Modifier.isFinal(modVal)) {
            modifier |= 0x10;
        }
        if (Modifier.isSynchronized(modVal) && host instanceof SootMethod) {
            modifier |= 0x20;
        }
        if (Modifier.isVolatile(modVal) && !(host instanceof SootClass)) {
            modifier |= 0x40;
        }
        if (Modifier.isTransient(modVal) && !(host instanceof SootClass)) {
            modifier |= 0x80;
        }
        if (Modifier.isNative(modVal) && host instanceof SootMethod) {
            modifier |= 0x100;
        }
        if (Modifier.isInterface(modVal) && host instanceof SootClass) {
            modifier |= 0x200;
        } else if (host instanceof SootClass) {
            modifier |= 0x20;
        }
        if (Modifier.isAbstract(modVal) && !(host instanceof SootField)) {
            modifier |= 0x400;
        }
        if (Modifier.isStrictFP(modVal) && host instanceof SootMethod) {
            modifier |= 0x800;
        }
        if (Modifier.isSynthetic(modVal) || host.hasTag("SyntheticTag")) {
            modifier |= 0x1000;
        }
        if (Modifier.isAnnotation(modVal) && host instanceof SootClass) {
            modifier |= 0x2000;
        }
        if (Modifier.isEnum(modVal) && !(host instanceof SootMethod)) {
            modifier |= 0x4000;
        }
        return modifier;
    }

    protected abstract void generateMethodBody(MethodVisitor var1, SootMethod var2);

    private class SootInnerClassComparator
    implements Comparator<InnerClassTag> {
        private SootInnerClassComparator() {
        }

        @Override
        public int compare(InnerClassTag o1, InnerClassTag o2) {
            return o1.getInnerClass() == null ? 0 : o1.getInnerClass().compareTo(o2.getInnerClass());
        }
    }

    private static class SootMethodComparator
    implements Comparator<SootMethod> {
        private SootMethodComparator() {
        }

        @Override
        public int compare(SootMethod o1, SootMethod o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

