/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.Printer;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ThisRef;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.CodeAttribute;
import soot.tagkit.Tag;
import soot.util.Chain;
import soot.util.EscapedWriter;
import soot.util.HashChain;
import soot.validation.BodyValidator;
import soot.validation.CheckEscapingValidator;
import soot.validation.CheckInitValidator;
import soot.validation.CheckTypesValidator;
import soot.validation.CheckVoidLocalesValidator;
import soot.validation.LocalsValidator;
import soot.validation.TrapsValidator;
import soot.validation.UnitBoxesValidator;
import soot.validation.UsesValidator;
import soot.validation.ValidationException;
import soot.validation.ValueBoxesValidator;

public abstract class Body
extends AbstractHost
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(Body.class);
    protected transient SootMethod method = null;
    protected Chain<Local> localChain = new HashChain<Local>();
    protected Chain<Trap> trapChain = new HashChain<Trap>();
    protected UnitPatchingChain unitChain = new UnitPatchingChain((Chain<Unit>)new HashChain<Unit>());

    public Object clone() {
        return this.clone(true);
    }

    public abstract Object clone(boolean var1);

    protected Body(SootMethod m3) {
        this.method = m3;
    }

    protected Body() {
    }

    public SootMethod getMethod() {
        if (this.method == null) {
            throw new RuntimeException("no method associated w/ body");
        }
        return this.method;
    }

    public SootMethod getMethodUnsafe() {
        return this.method;
    }

    public void setMethod(SootMethod method) {
        this.method = method;
    }

    public int getLocalCount() {
        return this.localChain.size();
    }

    public Map<Object, Object> importBodyContentsFrom(Body b) {
        return this.importBodyContentsFrom(b, false);
    }

    public Map<Object, Object> importBodyContentsFrom(Body b, boolean noLocalsClone) {
        Object copy;
        HashMap<Object, Object> bindings = new HashMap<Object, Object>();
        for (Unit unit : b.getUnits()) {
            copy = (Unit)unit.clone();
            copy.addAllTagsOf(unit);
            this.unitChain.addLast(copy);
            bindings.put(unit, copy);
        }
        for (Trap trap : b.getTraps()) {
            copy = (Trap)trap.clone();
            this.trapChain.addLast((Trap)copy);
            bindings.put(trap, copy);
        }
        if (!noLocalsClone) {
            for (Local local : b.getLocals()) {
                copy = (Local)local.clone();
                this.localChain.addLast((Local)copy);
                bindings.put(local, copy);
            }
        } else {
            this.localChain.addAll(b.getLocals());
        }
        for (UnitBox unitBox : this.getAllUnitBoxes()) {
            Unit newObject = (Unit)bindings.get(unitBox.getUnit());
            if (newObject == null) continue;
            unitBox.setUnit(newObject);
        }
        if (!noLocalsClone) {
            Value val;
            for (ValueBox valueBox : this.getUseBoxes()) {
                val = valueBox.getValue();
                if (!(val instanceof Local)) continue;
                valueBox.setValue((Value)bindings.get(val));
            }
            for (ValueBox valueBox : this.getDefBoxes()) {
                val = valueBox.getValue();
                if (!(val instanceof Local)) continue;
                valueBox.setValue((Value)bindings.get(val));
            }
        }
        return bindings;
    }

    protected void runValidation(BodyValidator validator) {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        validator.validate(this, (List<ValidationException>)exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validate() {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        this.validate(exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    public void validate(List<ValidationException> exceptionList) {
        boolean runAllValidators = Options.v().debug() || Options.v().validate();
        for (BodyValidator validator : LazyValidatorsSingleton.V) {
            if (!validator.isBasicValidator() && !runAllValidators) continue;
            validator.validate(this, exceptionList);
        }
    }

    public void validateValueBoxes() {
        this.runValidation(ValueBoxesValidator.v());
    }

    public void validateLocals() {
        this.runValidation(LocalsValidator.v());
    }

    public void validateTraps() {
        this.runValidation(TrapsValidator.v());
    }

    public void validateUnitBoxes() {
        this.runValidation(UnitBoxesValidator.v());
    }

    public void validateUses() {
        this.runValidation(UsesValidator.v());
    }

    public void checkInit() {
        this.runValidation(CheckInitValidator.v());
    }

    public Chain<Local> getLocals() {
        return this.localChain;
    }

    public Chain<Trap> getTraps() {
        return this.trapChain;
    }

    public Unit getThisUnit() {
        for (Unit u : this.getUnits()) {
            if (!(u instanceof IdentityStmt) || !(((IdentityStmt)u).getRightOp() instanceof ThisRef)) continue;
            return u;
        }
        throw new RuntimeException("couldn't find this-assignment! in " + this.getMethod());
    }

    public Local getThisLocal() {
        return (Local)((IdentityStmt)this.getThisUnit()).getLeftOp();
    }

    public Local getParameterLocal(int i) {
        for (Unit s2 : this.getUnits()) {
            ParameterRef pr;
            IdentityStmt is;
            Value rightOp;
            if (!(s2 instanceof IdentityStmt) || !((rightOp = (is = (IdentityStmt)s2).getRightOp()) instanceof ParameterRef) || (pr = (ParameterRef)rightOp).getIndex() != i) continue;
            return (Local)is.getLeftOp();
        }
        throw new RuntimeException("couldn't find parameterref" + i + " in " + this.getMethod());
    }

    public List<Local> getParameterLocals() {
        int numParams = this.getMethod().getParameterCount();
        Local[] res = new Local[numParams];
        int numFound = 0;
        for (Unit u : this.getUnits()) {
            IdentityStmt is;
            Value rightOp;
            if (!(u instanceof IdentityStmt) || !((rightOp = (is = (IdentityStmt)u).getRightOp()) instanceof ParameterRef)) continue;
            int idx = ((ParameterRef)rightOp).getIndex();
            if (res[idx] != null) {
                throw new RuntimeException("duplicate parameterref" + idx + " in " + this.getMethod());
            }
            res[idx] = (Local)is.getLeftOp();
            if (++numFound < numParams) continue;
            break;
        }
        if (numFound != numParams) {
            for (int i = 0; i < numParams; ++i) {
                if (res[i] != null) continue;
                throw new RuntimeException("couldn't find parameterref" + i + " in " + this.getMethod());
            }
            throw new RuntimeException("couldn't find parameterref? in " + this.getMethod());
        }
        return Arrays.asList(res);
    }

    public List<Value> getParameterRefs() {
        int numParams = this.getMethod().getParameterCount();
        Value[] res = new Value[numParams];
        int numFound = 0;
        for (Unit u : this.getUnits()) {
            Value rightOp;
            if (!(u instanceof IdentityStmt) || !((rightOp = ((IdentityStmt)u).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef pr = (ParameterRef)rightOp;
            int idx = pr.getIndex();
            if (res[idx] != null) {
                throw new RuntimeException("duplicate parameterref" + idx + " in " + this.getMethod());
            }
            res[idx] = pr;
            if (++numFound < numParams) continue;
            break;
        }
        return Arrays.asList(res);
    }

    public UnitPatchingChain getUnits() {
        return this.unitChain;
    }

    public List<UnitBox> getAllUnitBoxes() {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<UnitBox> getUnitBoxes(boolean branchTarget) {
        ArrayList<UnitBox> unitBoxList = new ArrayList<UnitBox>();
        for (Unit unit : this.unitChain) {
            if (unit.branches() != branchTarget) continue;
            unitBoxList.addAll(unit.getUnitBoxes());
        }
        for (Trap trap : this.trapChain) {
            unitBoxList.addAll(trap.getUnitBoxes());
        }
        for (Tag tag : this.getTags()) {
            if (!(tag instanceof CodeAttribute)) continue;
            unitBoxList.addAll(((CodeAttribute)tag).getUnitBoxes());
        }
        return unitBoxList;
    }

    public List<ValueBox> getUseBoxes() {
        ArrayList<ValueBox> useBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useBoxList.addAll(item.getUseBoxes());
        }
        return useBoxList;
    }

    public List<ValueBox> getDefBoxes() {
        ArrayList<ValueBox> defBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            defBoxList.addAll(item.getDefBoxes());
        }
        return defBoxList;
    }

    public List<ValueBox> getUseAndDefBoxes() {
        ArrayList<ValueBox> useAndDefBoxList = new ArrayList<ValueBox>();
        for (Unit item : this.unitChain) {
            useAndDefBoxList.addAll(item.getUseBoxes());
            useAndDefBoxList.addAll(item.getDefBoxes());
        }
        return useAndDefBoxList;
    }

    public String toString() {
        ByteArrayOutputStream streamOut = new ByteArrayOutputStream();
        try (PrintWriter writerOut = new PrintWriter(new EscapedWriter(new OutputStreamWriter(streamOut)));){
            Printer.v().printTo(this, writerOut);
            writerOut.flush();
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), e);
        }
        return streamOut.toString();
    }

    public long getModificationCount() {
        return this.localChain.getModificationCount() + this.unitChain.getModificationCount() + this.trapChain.getModificationCount();
    }

    private static class LazyValidatorsSingleton {
        static final BodyValidator[] V = new BodyValidator[]{LocalsValidator.v(), TrapsValidator.v(), UnitBoxesValidator.v(), UsesValidator.v(), ValueBoxesValidator.v(), CheckTypesValidator.v(), CheckVoidLocalesValidator.v(), CheckEscapingValidator.v()};

        private LazyValidatorsSingleton() {
        }
    }
}

