/*
 * Decompiled with CFR 0.152.
 */
package soot;

import soot.Body;
import soot.LabeledUnitPrinter;
import soot.SootFieldRef;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityRef;
import soot.jimple.ParameterRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;

public class BriefUnitPrinter
extends LabeledUnitPrinter {
    private boolean baf;
    private boolean eatSpace = false;

    public BriefUnitPrinter(Body body) {
        super(body);
    }

    @Override
    public void startUnit(Unit u) {
        super.startUnit(u);
        this.baf = !(u instanceof Stmt);
    }

    @Override
    public void methodRef(SootMethodRef m3) {
        this.handleIndent();
        if (!this.baf && m3.resolve().isStatic()) {
            this.output.append(m3.getDeclaringClass().getName());
            this.literal(".");
        }
        this.output.append(m3.name());
    }

    @Override
    public void fieldRef(SootFieldRef f) {
        this.handleIndent();
        if (this.baf || f.resolve().isStatic()) {
            this.output.append(f.declaringClass().getName());
            this.literal(".");
        }
        this.output.append(f.name());
    }

    @Override
    public void identityRef(IdentityRef r) {
        this.handleIndent();
        if (r instanceof ThisRef) {
            this.literal("@this");
        } else if (r instanceof ParameterRef) {
            ParameterRef pr = (ParameterRef)r;
            this.literal("@parameter" + pr.getIndex());
        } else if (r instanceof CaughtExceptionRef) {
            this.literal("@caughtexception");
        } else {
            throw new RuntimeException();
        }
    }

    @Override
    public void literal(String s2) {
        this.handleIndent();
        if (this.eatSpace && " ".equals(s2)) {
            this.eatSpace = false;
            return;
        }
        this.eatSpace = false;
        if (!this.baf) {
            switch (s2) {
                case "staticinvoke": 
                case "virtualinvoke": 
                case "interfaceinvoke": {
                    this.eatSpace = true;
                    return;
                }
            }
        }
        this.output.append(s2);
    }

    @Override
    public void type(Type t) {
        this.handleIndent();
        this.output.append(t.toString());
    }
}

