/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import soot.G;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.options.Options;
import soot.util.NumberedString;
import soot.util.StringNumberer;

public class EntryPoints {
    final NumberedString sigMain;
    final NumberedString sigFinalize;
    final NumberedString sigExit;
    final NumberedString sigClinit;
    final NumberedString sigInit;
    final NumberedString sigStart;
    final NumberedString sigRun;
    final NumberedString sigObjRun;
    final NumberedString sigForName;

    public EntryPoints(Singletons.Global g2) {
        StringNumberer subSigNumberer = Scene.v().getSubSigNumberer();
        if (Options.v().src_prec() == 7) {
            this.sigMain = subSigNumberer.findOrAdd("void Main(System.String[])");
            this.sigFinalize = subSigNumberer.findOrAdd("void Finalize()");
        } else {
            this.sigMain = subSigNumberer.findOrAdd("void main(java.lang.String[])");
            this.sigFinalize = subSigNumberer.findOrAdd("void finalize()");
        }
        this.sigExit = subSigNumberer.findOrAdd("void exit()");
        this.sigClinit = subSigNumberer.findOrAdd("void <clinit>()");
        this.sigInit = subSigNumberer.findOrAdd("void <init>()");
        this.sigStart = subSigNumberer.findOrAdd("void start()");
        this.sigRun = subSigNumberer.findOrAdd("void run()");
        this.sigObjRun = subSigNumberer.findOrAdd("java.lang.Object run()");
        this.sigForName = subSigNumberer.findOrAdd("java.lang.Class forName(java.lang.String)");
    }

    public static EntryPoints v() {
        return G.v().soot_EntryPoints();
    }

    protected void addMethod(List<SootMethod> set, SootClass cls, NumberedString methodSubSig) {
        SootMethod sm = cls.getMethodUnsafe(methodSubSig);
        if (sm != null) {
            set.add(sm);
        }
    }

    protected void addMethod(List<SootMethod> set, String methodSig) {
        Scene sc = Scene.v();
        if (sc.containsMethod(methodSig)) {
            set.add(sc.getMethod(methodSig));
        }
    }

    public List<SootMethod> application() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        Scene sc = Scene.v();
        if (sc.hasMainClass()) {
            SootClass mainClass = sc.getMainClass();
            this.addMethod(ret, mainClass, this.sigMain);
            for (SootMethod clinit : this.clinitsOf(mainClass)) {
                ret.add(clinit);
            }
        }
        return ret;
    }

    public List<SootMethod> implicit() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        if (Options.v().src_prec() == 7) {
            return ret;
        }
        this.addMethod(ret, "<java.lang.System: void initializeSystemClass()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void <init>()>");
        this.addMethod(ret, "<java.lang.Thread: void exit()>");
        this.addMethod(ret, "<java.lang.ThreadGroup: void uncaughtException(java.lang.Thread,java.lang.Throwable)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void <init>()>");
        this.addMethod(ret, "<java.lang.ClassLoader: java.lang.Class loadClassInternal(java.lang.String)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void checkPackageAccess(java.lang.Class,java.security.ProtectionDomain)>");
        this.addMethod(ret, "<java.lang.ClassLoader: void addClass(java.lang.Class)>");
        this.addMethod(ret, "<java.lang.ClassLoader: long findNative(java.lang.ClassLoader,java.lang.String)>");
        this.addMethod(ret, "<java.security.PrivilegedActionException: void <init>(java.lang.Exception)>");
        this.addMethod(ret, "<java.lang.ref.Finalizer: void runFinalizer()>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.Runnable)>");
        this.addMethod(ret, "<java.lang.Thread: void <init>(java.lang.ThreadGroup,java.lang.String)>");
        return ret;
    }

    public List<SootMethod> all() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        ret.addAll(this.application());
        ret.addAll(this.implicit());
        return ret;
    }

    public List<SootMethod> clinits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigClinit);
        }
        return ret;
    }

    public List<SootMethod> inits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            this.addMethod(ret, cl, this.sigInit);
        }
        return ret;
    }

    public List<SootMethod> allInits() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getClasses()) {
            for (SootMethod m3 : cl.getMethods()) {
                if (!"<init>".equals(m3.getName())) continue;
                ret.add(m3);
            }
        }
        return ret;
    }

    public List<SootMethod> methodsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            for (SootMethod m3 : cl.getMethods()) {
                if (!m3.isConcrete()) continue;
                ret.add(m3);
            }
        }
        return ret;
    }

    public List<SootMethod> mainsOfApplicationClasses() {
        ArrayList<SootMethod> ret = new ArrayList<SootMethod>();
        for (SootClass cl : Scene.v().getApplicationClasses()) {
            SootMethod m3 = Options.v().src_prec() == 7 ? cl.getMethodUnsafe("void Main(System.String[])") : cl.getMethodUnsafe("void main(java.lang.String[])");
            if (m3 == null || !m3.isConcrete()) continue;
            ret.add(m3);
        }
        return ret;
    }

    public Iterable<SootMethod> clinitsOf(SootClass cl) {
        SootMethod init = cl.getMethodUnsafe(this.sigClinit);
        for (SootClass superClass = cl.getSuperclassUnsafe(); init == null && superClass != null; superClass = superClass.getSuperclassUnsafe()) {
            init = superClass.getMethodUnsafe(this.sigClinit);
        }
        if (init == null) {
            return Collections.emptyList();
        }
        final SootMethod initStart = init;
        return new Iterable<SootMethod>(){

            @Override
            public Iterator<SootMethod> iterator() {
                return new Iterator<SootMethod>(){
                    SootMethod current;
                    {
                        this.current = initStart;
                    }

                    @Override
                    public SootMethod next() {
                        SootClass superClass;
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        SootMethod n = this.current;
                        this.current = null;
                        SootClass currentClass = n.getDeclaringClass();
                        while ((superClass = currentClass.getSuperclassUnsafe()) != null) {
                            SootMethod m3 = superClass.getMethodUnsafe(EntryPoints.this.sigClinit);
                            if (m3 != null) {
                                this.current = m3;
                                break;
                            }
                            currentClass = superClass;
                        }
                        return n;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current != null;
                    }
                };
            }
        };
    }
}

