/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import beaver.Symbol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Body;
import soot.JastAddJ.FinallyHost;
import soot.JastAddJ.LabeledStmt;
import soot.JastAddJ.Stmt;
import soot.JastAddJ.SynchronizedStmt;
import soot.JastAddJ.Variable;

public class BreakStmt
extends Stmt
implements Cloneable {
    protected String tokenString_Label;
    public int Labelstart;
    public int Labelend;
    protected boolean targetStmt_computed = false;
    protected Stmt targetStmt_value;
    protected boolean finallyList_computed = false;
    protected ArrayList finallyList_value;
    protected Map isDAafter_Variable_values;
    protected Map isDUafterReachedFinallyBlocks_Variable_values;
    protected Map isDAafterReachedFinallyBlocks_Variable_values;
    protected Map isDUafter_Variable_values;
    protected boolean canCompleteNormally_computed = false;
    protected boolean canCompleteNormally_value;
    protected boolean inSynchronizedBlock_computed = false;
    protected boolean inSynchronizedBlock_value;
    protected Map lookupLabel_String_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.targetStmt_computed = false;
        this.targetStmt_value = null;
        this.finallyList_computed = false;
        this.finallyList_value = null;
        this.isDAafter_Variable_values = null;
        this.isDUafterReachedFinallyBlocks_Variable_values = null;
        this.isDAafterReachedFinallyBlocks_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.canCompleteNormally_computed = false;
        this.inSynchronizedBlock_computed = false;
        this.lookupLabel_String_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public BreakStmt clone() throws CloneNotSupportedException {
        BreakStmt node = (BreakStmt)super.clone();
        node.targetStmt_computed = false;
        node.targetStmt_value = null;
        node.finallyList_computed = false;
        node.finallyList_value = null;
        node.isDAafter_Variable_values = null;
        node.isDUafterReachedFinallyBlocks_Variable_values = null;
        node.isDAafterReachedFinallyBlocks_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.canCompleteNormally_computed = false;
        node.inSynchronizedBlock_computed = false;
        node.lookupLabel_String_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public BreakStmt copy() {
        try {
            BreakStmt node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public BreakStmt fullCopy() {
        BreakStmt tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void collectBranches(Collection c) {
        c.add(this);
    }

    @Override
    public void nameCheck() {
        LabeledStmt label;
        if (!(this.hasLabel() || this.insideLoop() || this.insideSwitch())) {
            this.error("break outside switch or loop");
        } else if (this.hasLabel() && (label = this.lookupLabel(this.getLabel())) == null) {
            this.error("labeled break must have visible matching label");
        }
    }

    @Override
    public void toString(StringBuffer s2) {
        s2.append(this.indent());
        s2.append("break ");
        if (this.hasLabel()) {
            s2.append(this.getLabel());
        }
        s2.append(";");
    }

    @Override
    public void jimplify2(Body b) {
        ArrayList list = this.exceptionRanges();
        if (!this.inSynchronizedBlock()) {
            this.endExceptionRange(b, list);
        }
        for (FinallyHost stmt : this.finallyList()) {
            stmt.emitFinallyCode(b);
        }
        if (this.inSynchronizedBlock()) {
            this.endExceptionRange(b, list);
        }
        b.setLine(this);
        b.add(b.newGotoStmt(this.targetStmt().break_label(), this));
        this.beginExceptionRange(b, list);
    }

    public BreakStmt() {
    }

    @Override
    public void init$Children() {
    }

    public BreakStmt(String p0) {
        this.setLabel(p0);
    }

    public BreakStmt(Symbol p0) {
        this.setLabel(p0);
    }

    @Override
    protected int numChildren() {
        return 0;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setLabel(String value) {
        this.tokenString_Label = value;
    }

    public void setLabel(Symbol symbol) {
        if (symbol.value != null && !(symbol.value instanceof String)) {
            throw new UnsupportedOperationException("setLabel is only valid for String lexemes");
        }
        this.tokenString_Label = (String)symbol.value;
        this.Labelstart = symbol.getStart();
        this.Labelend = symbol.getEnd();
    }

    public String getLabel() {
        return this.tokenString_Label != null ? this.tokenString_Label : "";
    }

    public boolean hasLabel() {
        ASTNode$State state = this.state();
        return !this.getLabel().equals("");
    }

    public Stmt targetStmt() {
        if (this.targetStmt_computed) {
            return this.targetStmt_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.targetStmt_value = this.targetStmt_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.targetStmt_computed = true;
        }
        return this.targetStmt_value;
    }

    private Stmt targetStmt_compute() {
        return this.branchTarget(this);
    }

    public ArrayList finallyList() {
        if (this.finallyList_computed) {
            return this.finallyList_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.finallyList_value = this.finallyList_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.finallyList_computed = true;
        }
        return this.finallyList_value;
    }

    private ArrayList finallyList_compute() {
        ArrayList list = new ArrayList();
        this.collectFinally(this, list);
        return list;
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return true;
    }

    public boolean isDUafterReachedFinallyBlocks(Variable v) {
        Variable _parameters = v;
        if (this.isDUafterReachedFinallyBlocks_Variable_values == null) {
            this.isDUafterReachedFinallyBlocks_Variable_values = new HashMap(4);
        }
        if (this.isDUafterReachedFinallyBlocks_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafterReachedFinallyBlocks_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafterReachedFinallyBlocks_Variable_value = this.isDUafterReachedFinallyBlocks_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafterReachedFinallyBlocks_Variable_values.put(_parameters, isDUafterReachedFinallyBlocks_Variable_value);
        }
        return isDUafterReachedFinallyBlocks_Variable_value;
    }

    private boolean isDUafterReachedFinallyBlocks_compute(Variable v) {
        if (!this.isDUbefore(v) && this.finallyList().isEmpty()) {
            return false;
        }
        for (FinallyHost f : this.finallyList()) {
            if (f.isDUafterFinally(v)) continue;
            return false;
        }
        return true;
    }

    public boolean isDAafterReachedFinallyBlocks(Variable v) {
        Variable _parameters = v;
        if (this.isDAafterReachedFinallyBlocks_Variable_values == null) {
            this.isDAafterReachedFinallyBlocks_Variable_values = new HashMap(4);
        }
        if (this.isDAafterReachedFinallyBlocks_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafterReachedFinallyBlocks_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafterReachedFinallyBlocks_Variable_value = this.isDAafterReachedFinallyBlocks_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafterReachedFinallyBlocks_Variable_values.put(_parameters, isDAafterReachedFinallyBlocks_Variable_value);
        }
        return isDAafterReachedFinallyBlocks_Variable_value;
    }

    private boolean isDAafterReachedFinallyBlocks_compute(Variable v) {
        if (this.isDAbefore(v)) {
            return true;
        }
        if (this.finallyList().isEmpty()) {
            return false;
        }
        for (FinallyHost f : this.finallyList()) {
            if (f.isDAafterFinally(v)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.canCompleteNormally_computed) {
            return this.canCompleteNormally_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.canCompleteNormally_value = this.canCompleteNormally_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.canCompleteNormally_computed = true;
        }
        return this.canCompleteNormally_value;
    }

    private boolean canCompleteNormally_compute() {
        return false;
    }

    public boolean inSynchronizedBlock() {
        if (this.inSynchronizedBlock_computed) {
            return this.inSynchronizedBlock_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.inSynchronizedBlock_value = this.inSynchronizedBlock_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.inSynchronizedBlock_computed = true;
        }
        return this.inSynchronizedBlock_value;
    }

    private boolean inSynchronizedBlock_compute() {
        return !this.finallyList().isEmpty() && this.finallyList().iterator().next() instanceof SynchronizedStmt;
    }

    @Override
    public boolean modifiedInScope(Variable var) {
        ASTNode$State state = this.state();
        return false;
    }

    public LabeledStmt lookupLabel(String name) {
        String _parameters = name;
        if (this.lookupLabel_String_values == null) {
            this.lookupLabel_String_values = new HashMap(4);
        }
        if (this.lookupLabel_String_values.containsKey(_parameters)) {
            return (LabeledStmt)this.lookupLabel_String_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        LabeledStmt lookupLabel_String_value = this.getParent().Define_LabeledStmt_lookupLabel(this, null, name);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.lookupLabel_String_values.put(_parameters, lookupLabel_String_value);
        }
        return lookupLabel_String_value;
    }

    public boolean insideLoop() {
        ASTNode$State state = this.state();
        boolean insideLoop_value = this.getParent().Define_boolean_insideLoop(this, null);
        return insideLoop_value;
    }

    public boolean insideSwitch() {
        ASTNode$State state = this.state();
        boolean insideSwitch_value = this.getParent().Define_boolean_insideSwitch(this, null);
        return insideSwitch_value;
    }

    public ArrayList exceptionRanges() {
        ASTNode$State state = this.state();
        ArrayList exceptionRanges_value = this.getParent().Define_ArrayList_exceptionRanges(this, null);
        return exceptionRanges_value;
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

