/*
 * Decompiled with CFR 0.152.
 */
package soot.JastAddJ;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import soot.JastAddJ.ASTNode;
import soot.JastAddJ.ASTNode$State;
import soot.JastAddJ.Block;
import soot.JastAddJ.BodyDecl;
import soot.JastAddJ.ConstructorDecl;
import soot.JastAddJ.TypeDecl;
import soot.JastAddJ.Variable;

public class InstanceInitializer
extends BodyDecl
implements Cloneable {
    protected boolean exceptions_computed = false;
    protected Collection exceptions_value;
    protected Map isDAafter_Variable_values;
    protected Map isDUafter_Variable_values;
    protected Map handlesException_TypeDecl_values;

    @Override
    public void flushCache() {
        super.flushCache();
        this.exceptions_computed = false;
        this.exceptions_value = null;
        this.isDAafter_Variable_values = null;
        this.isDUafter_Variable_values = null;
        this.handlesException_TypeDecl_values = null;
    }

    @Override
    public void flushCollectionCache() {
        super.flushCollectionCache();
    }

    @Override
    public InstanceInitializer clone() throws CloneNotSupportedException {
        InstanceInitializer node = (InstanceInitializer)super.clone();
        node.exceptions_computed = false;
        node.exceptions_value = null;
        node.isDAafter_Variable_values = null;
        node.isDUafter_Variable_values = null;
        node.handlesException_TypeDecl_values = null;
        node.in$Circle(false);
        node.is$Final(false);
        return node;
    }

    public InstanceInitializer copy() {
        try {
            InstanceInitializer node = this.clone();
            node.parent = null;
            if (this.children != null) {
                node.children = (ASTNode[])this.children.clone();
            }
            return node;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Error: clone not supported for " + this.getClass().getName());
        }
    }

    public InstanceInitializer fullCopy() {
        InstanceInitializer tree = this.copy();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                ASTNode child = this.children[i];
                if (child == null) continue;
                child = child.fullCopy();
                tree.setChild(child, i);
            }
        }
        return tree;
    }

    @Override
    public void toString(StringBuffer s2) {
        if (this.getBlock().getNumStmt() == 0) {
            return;
        }
        s2.append(this.indent());
        this.getBlock().toString(s2);
    }

    @Override
    void checkUnreachableStmt() {
        if (!this.getBlock().canCompleteNormally()) {
            this.error("instance initializer in " + this.hostType().fullName() + " can not complete normally");
        }
    }

    public InstanceInitializer() {
    }

    @Override
    public void init$Children() {
        this.children = new ASTNode[1];
    }

    public InstanceInitializer(Block p0) {
        this.setChild(p0, 0);
    }

    @Override
    protected int numChildren() {
        return 1;
    }

    @Override
    public boolean mayHaveRewrite() {
        return false;
    }

    public void setBlock(Block node) {
        this.setChild(node, 0);
    }

    public Block getBlock() {
        return (Block)this.getChild(0);
    }

    public Block getBlockNoTransform() {
        return (Block)this.getChildNoTransform(0);
    }

    public Collection exceptions() {
        if (this.exceptions_computed) {
            return this.exceptions_value;
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        this.exceptions_value = this.exceptions_compute();
        if (isFinal && num == this.state().boundariesCrossed) {
            this.exceptions_computed = true;
        }
        return this.exceptions_value;
    }

    private Collection exceptions_compute() {
        HashSet set = new HashSet();
        this.collectExceptions(set, this);
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            TypeDecl typeDecl = (TypeDecl)iter.next();
            if (this.getBlock().reachedException(typeDecl)) continue;
            iter.remove();
        }
        return set;
    }

    @Override
    public boolean isDAafter(Variable v) {
        Variable _parameters = v;
        if (this.isDAafter_Variable_values == null) {
            this.isDAafter_Variable_values = new HashMap(4);
        }
        if (this.isDAafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDAafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDAafter_Variable_value = this.isDAafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDAafter_Variable_values.put(_parameters, isDAafter_Variable_value);
        }
        return isDAafter_Variable_value;
    }

    private boolean isDAafter_compute(Variable v) {
        return this.getBlock().isDAafter(v);
    }

    @Override
    public boolean isDUafter(Variable v) {
        Variable _parameters = v;
        if (this.isDUafter_Variable_values == null) {
            this.isDUafter_Variable_values = new HashMap(4);
        }
        if (this.isDUafter_Variable_values.containsKey(_parameters)) {
            return (Boolean)this.isDUafter_Variable_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean isDUafter_Variable_value = this.isDUafter_compute(v);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.isDUafter_Variable_values.put(_parameters, isDUafter_Variable_value);
        }
        return isDUafter_Variable_value;
    }

    private boolean isDUafter_compute(Variable v) {
        return this.getBlock().isDUafter(v);
    }

    public boolean handlesException(TypeDecl exceptionType) {
        TypeDecl _parameters = exceptionType;
        if (this.handlesException_TypeDecl_values == null) {
            this.handlesException_TypeDecl_values = new HashMap(4);
        }
        if (this.handlesException_TypeDecl_values.containsKey(_parameters)) {
            return (Boolean)this.handlesException_TypeDecl_values.get(_parameters);
        }
        ASTNode$State state = this.state();
        int num = state.boundariesCrossed;
        boolean isFinal = this.is$Final();
        boolean handlesException_TypeDecl_value = this.getParent().Define_boolean_handlesException(this, null, exceptionType);
        if (isFinal && num == this.state().boundariesCrossed) {
            this.handlesException_TypeDecl_values.put(_parameters, handlesException_TypeDecl_value);
        }
        return handlesException_TypeDecl_value;
    }

    @Override
    public boolean Define_boolean_isDAbefore(ASTNode caller, ASTNode child, Variable v) {
        if (caller == this.getBlockNoTransform()) {
            return this.isDAbefore(v);
        }
        return this.getParent().Define_boolean_isDAbefore(this, caller, v);
    }

    @Override
    public boolean Define_boolean_handlesException(ASTNode caller, ASTNode child, TypeDecl exceptionType) {
        if (caller == this.getBlockNoTransform()) {
            if (this.hostType().isAnonymous()) {
                return true;
            }
            if (!exceptionType.isUncheckedException()) {
                return true;
            }
            for (ConstructorDecl decl : this.hostType().constructors()) {
                if (decl.throwsException(exceptionType)) continue;
                return false;
            }
            return true;
        }
        return this.getParent().Define_boolean_handlesException(this, caller, exceptionType);
    }

    @Override
    public ASTNode Define_ASTNode_enclosingBlock(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return this;
        }
        return this.getParent().Define_ASTNode_enclosingBlock(this, caller);
    }

    @Override
    public boolean Define_boolean_inStaticContext(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return false;
        }
        return this.getParent().Define_boolean_inStaticContext(this, caller);
    }

    @Override
    public boolean Define_boolean_reachable(ASTNode caller, ASTNode child) {
        if (caller == this.getBlockNoTransform()) {
            return true;
        }
        return this.getParent().Define_boolean_reachable(this, caller);
    }

    @Override
    public ASTNode rewriteTo() {
        return super.rewriteTo();
    }
}

