/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.CompilationDeathException;
import soot.FoundFile;
import soot.G;
import soot.IFoundFile;
import soot.JavaClassProvider;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleInfo;
import soot.SootModuleResolver;
import soot.SourceLocator;
import soot.asm.AsmModuleClassProvider;

public class ModulePathSourceLocator
extends SourceLocator {
    private static final Logger logger = LoggerFactory.getLogger(ModulePathSourceLocator.class);
    public static final String DUMMY_CLASSPATH_JDK9_FS = "VIRTUAL_FS_FOR_JDK";
    private final HashMap<String, Path> moduleNameToPath = new HashMap();
    private Set<String> classesToLoad;
    private List<String> modulePath;
    private int nextPathEntry = 0;

    public ModulePathSourceLocator(Singletons.Global g2) {
        super(g2);
    }

    public static ModulePathSourceLocator v() {
        return G.v().soot_ModulePathSourceLocator();
    }

    @Override
    public ClassSource getClassSource(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getClassSource(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public ClassSource getClassSource(String className, Optional<String> moduleName) {
        Set<String> classesToLoad = this.classesToLoad;
        if (classesToLoad == null) {
            classesToLoad = new HashSet<String>(ModuleScene.v().getBasicClasses());
            for (SootClass c : ModuleScene.v().getApplicationClasses()) {
                classesToLoad.add(c.getName());
            }
            this.classesToLoad = classesToLoad;
        }
        if (this.modulePath == null) {
            this.modulePath = ModulePathSourceLocator.explodeModulePath(ModuleScene.v().getSootModulePath());
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        JavaClassProvider.JarException ex = null;
        String searchFor = moduleName.isPresent() ? moduleName.get() + ':' + className : className;
        for (ClassProvider cp : this.classProviders) {
            try {
                ClassSource ret = cp.find(searchFor);
                if (ret == null) continue;
                return ret;
            }
            catch (JavaClassProvider.JarException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public static List<String> explodeModulePath(String classPath) {
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            String originalDir = tokenizer.nextToken();
            try {
                String canonicalDir = new File(originalDir).getCanonicalPath();
                if (DUMMY_CLASSPATH_JDK9_FS.equals(originalDir)) {
                    canonicalDir = "jrt:/";
                }
                ret.add(canonicalDir);
            }
            catch (IOException e) {
                throw new CompilationDeathException("Couldn't resolve classpath entry " + originalDir + ": " + e);
            }
        }
        return ret;
    }

    @Override
    public void additionalClassLoader(ClassLoader c) {
        this.additionalClassLoaders.add(c);
    }

    @Override
    public List<String> classPath() {
        return this.modulePath;
    }

    @Override
    public void invalidateClassPath() {
        this.modulePath = null;
        super.invalidateClassPath();
    }

    @Override
    public List<String> sourcePath() {
        ArrayList<String> sourcePath = this.sourcePath;
        if (sourcePath == null) {
            sourcePath = new ArrayList<String>();
            for (String dir : this.modulePath) {
                SourceLocator.ClassSourceType cst = this.getClassSourceType(dir);
                if (cst == SourceLocator.ClassSourceType.apk || cst == SourceLocator.ClassSourceType.jar || cst == SourceLocator.ClassSourceType.zip) continue;
                sourcePath.add(dir);
            }
            this.sourcePath = sourcePath;
        }
        return sourcePath;
    }

    @Override
    public List<String> getClassesUnder(String aPath) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : this.getClassUnderModulePath(aPath).entrySet()) {
            for (String className : entry.getValue()) {
                classes.add(entry.getKey() + ':' + className);
            }
        }
        return classes;
    }

    public Map<String, List<String>> getClassUnderModulePath(String aPath) {
        Path path;
        switch (this.getClassSourceType(aPath)) {
            case jrt: {
                path = ModulePathSourceLocator.getRootModulesPathOfJDK();
                break;
            }
            case unknown: {
                path = null;
                break;
            }
            default: {
                path = Paths.get(aPath, new String[0]);
            }
        }
        if (this.classProviders == null) {
            this.setupClassProviders();
        }
        if (path == null) {
            throw new RuntimeException("[Error] The path " + aPath + "is not a valid path.");
        }
        BasicFileAttributes attrs = null;
        try {
            attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        assert (attrs != null);
        HashMap<String, List<String>> mapModuleClasses = new HashMap<String, List<String>>();
        if (attrs.isDirectory()) {
            if (!Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
                mapModuleClasses.putAll(this.discoverModulesIn(path));
            } else {
                mapModuleClasses.putAll(this.buildModuleForExplodedModule(path));
            }
        } else if (attrs.isRegularFile() && path.getFileName().toString().endsWith(".jar")) {
            mapModuleClasses.putAll(this.buildModuleForJar(path));
        }
        return mapModuleClasses;
    }

    public static Path getRootModulesPathOfJDK() {
        Path p = Paths.get(URI.create("jrt:/"));
        if (p.endsWith("modules")) {
            return p;
        }
        return p.resolve("modules");
    }

    private Map<String, List<String>> discoverModulesIn(Path path) {
        HashMap<String, List<String>> mapModuleClasses = new HashMap<String, List<String>>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                BasicFileAttributes attrs;
                try {
                    attrs = Files.readAttributes(entry, BasicFileAttributes.class, new LinkOption[0]);
                }
                catch (NoSuchFileException ignore) {
                    continue;
                }
                if (attrs.isDirectory()) {
                    if (!Files.exists(entry.resolve("module-info.class"), new LinkOption[0])) continue;
                    mapModuleClasses.putAll(this.buildModuleForExplodedModule(entry));
                    continue;
                }
                if (!attrs.isRegularFile() || !entry.getFileName().toString().endsWith(".jar")) continue;
                mapModuleClasses.putAll(this.buildModuleForJar(entry));
            }
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        return mapModuleClasses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<String>> buildModuleForJar(Path jar) {
        HashMap<String, List<String>> moduleClassMap = new HashMap<String, List<String>>();
        try {
            Path mi;
            block16: {
                FileSystem zipFileSystem = FileSystems.newFileSystem(jar, this.getClass().getClassLoader());
                mi = zipFileSystem.getPath("module-info.class", new String[0]);
                if (!Files.exists(mi, new LinkOption[0])) {
                    SootModuleInfo moduleInfo;
                    String moduleName = this.createModuleNameForAutomaticModule(jar.getFileName().toString());
                    if (!ModuleScene.v().containsClass("module-info", Optional.of(moduleName))) {
                        moduleInfo = new SootModuleInfo("module-info", moduleName, true);
                        Scene.v().addClass(moduleInfo);
                        moduleInfo.setApplicationClass();
                    } else {
                        moduleInfo = (SootModuleInfo)ModuleScene.v().getSootClass("module-info", Optional.of(moduleName));
                        if (moduleInfo.resolvingLevel() != 0) {
                            HashMap<String, List<String>> cp22 = moduleClassMap;
                            return cp22;
                        }
                    }
                    List<String> classesInJar = super.getClassesUnder(jar.toAbsolutePath().toString());
                    for (String foundClass : classesInJar) {
                        int index = foundClass.lastIndexOf(46);
                        if (index <= 0) continue;
                        moduleInfo.addModulePackage(foundClass.substring(0, index));
                    }
                    moduleInfo.setResolvingLevel(3);
                    moduleInfo.setAutomaticModule(true);
                    this.moduleNameToPath.put(moduleName, jar);
                    moduleClassMap.put(moduleName, classesInJar);
                    return moduleClassMap;
                }
                break block16;
                finally {
                    if (zipFileSystem != null) {
                        zipFileSystem.close();
                    }
                }
            }
            FoundFile foundFile = new FoundFile(mi);
            Iterator iterator = this.classProviders.iterator();
            while (iterator.hasNext()) {
                ClassProvider cp22 = (ClassProvider)iterator.next();
                if (!(cp22 instanceof AsmModuleClassProvider)) continue;
                String moduleName2 = ((AsmModuleClassProvider)cp22).getModuleName(foundFile);
                SootModuleInfo moduleInfo2 = (SootModuleInfo)SootModuleResolver.v().makeClassRef("module-info", Optional.of(moduleName2));
                this.moduleNameToPath.put(moduleName2, jar);
                List<String> classesInJar = super.getClassesUnder(jar.toAbsolutePath().toString());
                for (String foundClass : classesInJar) {
                    int index = foundClass.lastIndexOf(46);
                    if (index <= 0) continue;
                    moduleInfo2.addModulePackage(foundClass.substring(0, index));
                }
                moduleClassMap.put(moduleName2, classesInJar);
            }
            return moduleClassMap;
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        return moduleClassMap;
    }

    private String createModuleNameForAutomaticModule(String filename) {
        String moduleName;
        Matcher matcher;
        int i = filename.lastIndexOf(File.separatorChar);
        if (i != -1) {
            filename = filename.substring(i + 1);
        }
        if ((matcher = Patterns.VERSION.matcher(moduleName = filename.substring(0, filename.length() - 4))).find()) {
            moduleName = moduleName.substring(0, matcher.start());
        }
        moduleName = Patterns.ALPHA_NUM.matcher(moduleName).replaceAll(".");
        int len = (moduleName = Patterns.REPEATING_DOTS.matcher(moduleName).replaceAll(".")).length();
        if (len > 0 && moduleName.charAt(0) == '.') {
            moduleName = Patterns.LEADING_DOTS.matcher(moduleName).replaceAll("");
        }
        if ((len = moduleName.length()) > 0 && moduleName.charAt(len - 1) == '.') {
            moduleName = Patterns.TRAILING_DOTS.matcher(moduleName).replaceAll("");
        }
        return moduleName;
    }

    private Map<String, List<String>> buildModuleForExplodedModule(Path dir) {
        HashMap<String, List<String>> moduleClassesMap = new HashMap<String, List<String>>();
        Path mi = dir.resolve("module-info.class");
        for (ClassProvider cp : this.classProviders) {
            if (!(cp instanceof AsmModuleClassProvider)) continue;
            String moduleName = ((AsmModuleClassProvider)cp).getModuleName(new FoundFile(mi));
            SootModuleInfo moduleInfo = (SootModuleInfo)SootModuleResolver.v().makeClassRef("module-info", Optional.of(moduleName));
            this.moduleNameToPath.put(moduleName, dir);
            List<String> classes = this.getClassesUnderDirectory(dir);
            for (String foundClass : classes) {
                int index = foundClass.lastIndexOf(46);
                if (index <= 0) continue;
                moduleInfo.addModulePackage(foundClass.substring(0, index));
            }
            moduleClassesMap.put(moduleName, classes);
        }
        return moduleClassesMap;
    }

    @Override
    public Set<String> classesInDynamicPackage(String str) {
        HashSet<String> set = new HashSet<String>(0);
        StringTokenizer strtok = new StringTokenizer(ModuleScene.v().getSootModulePath(), File.pathSeparator);
        while (strtok.hasMoreTokens()) {
            String path = strtok.nextToken();
            for (String filename : super.getClassesUnder(path)) {
                if (!filename.startsWith(str)) continue;
                set.add(filename);
            }
            StringBuilder sb = new StringBuilder(path);
            sb.append(File.pathSeparatorChar);
            StringTokenizer tok = new StringTokenizer(str, ".");
            while (tok.hasMoreTokens()) {
                sb.append(tok.nextToken());
                if (!tok.hasMoreTokens()) continue;
                sb.append(File.pathSeparatorChar);
            }
            for (String string : super.getClassesUnder(sb.toString())) {
                set.add(str + '.' + string);
            }
        }
        return set;
    }

    @Override
    public IFoundFile lookupInClassPath(String fileName) {
        return this.lookUpInModulePath(fileName);
    }

    private SourceLocator.ClassSourceType getClassSourceType(Path path) {
        if (path.toUri().toString().startsWith("jrt:/")) {
            return SourceLocator.ClassSourceType.jrt;
        }
        return super.getClassSourceType(path.toAbsolutePath().toString());
    }

    @Override
    protected SourceLocator.ClassSourceType getClassSourceType(String path) {
        if (path.startsWith("jrt:/")) {
            return SourceLocator.ClassSourceType.jrt;
        }
        return super.getClassSourceType(path);
    }

    public IFoundFile lookUpInModulePath(String fileName) {
        String[] moduleAndClassName = fileName.split(":");
        String className = moduleAndClassName[moduleAndClassName.length - 1];
        String moduleName = moduleAndClassName[0];
        if (className.isEmpty() || moduleName.isEmpty()) {
            throw new RuntimeException("No module given!");
        }
        Path foundModulePath = this.discoverModule(moduleName);
        if (foundModulePath == null) {
            return null;
        }
        String uriString = foundModulePath.toUri().toString();
        String dir = uriString.startsWith("jrt:/") ? uriString : foundModulePath.toAbsolutePath().toString();
        SourceLocator.ClassSourceType cst = this.getClassSourceType(foundModulePath);
        if (null != cst) {
            switch (cst) {
                case jar: 
                case zip: {
                    return this.lookupInArchive(dir, className);
                }
                case directory: {
                    return this.lookupInDir(dir, className);
                }
                case jrt: {
                    return this.lookUpInVirtualFileSystem(dir, className);
                }
            }
        }
        return null;
    }

    private Path discoverModule(String moduleName) {
        Path pathToModule = this.moduleNameToPath.get(moduleName);
        if (pathToModule != null) {
            return pathToModule;
        }
        while (this.nextPathEntry < this.modulePath.size()) {
            this.getClassUnderModulePath(this.modulePath.get(this.nextPathEntry));
            ++this.nextPathEntry;
            pathToModule = this.moduleNameToPath.get(moduleName);
            if (pathToModule == null) continue;
            return pathToModule;
        }
        return null;
    }

    @Override
    protected IFoundFile lookupInDir(String dir, String fileName) {
        Path dirPath = Paths.get(dir, new String[0]);
        Path foundFile = dirPath.resolve(fileName);
        if (foundFile != null && Files.isRegularFile(foundFile, new LinkOption[0])) {
            return new FoundFile(foundFile);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IFoundFile lookupInArchive(String archivePath, String fileName) {
        Path archive = Paths.get(archivePath, new String[0]);
        try (FileSystem zipFileSystem = FileSystems.newFileSystem(archive, this.getClass().getClassLoader());){
            Path entry = zipFileSystem.getPath(fileName, new String[0]);
            if (entry == null || !Files.isRegularFile(entry, new LinkOption[0])) {
                IFoundFile iFoundFile = null;
                return iFoundFile;
            }
            FoundFile foundFile = new FoundFile(archive.toAbsolutePath().toString(), fileName);
            return foundFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Caught IOException " + e + " looking in archive file " + archivePath + " for file " + fileName);
        }
    }

    public IFoundFile lookUpInVirtualFileSystem(String archivePath, String fileName) {
        Path foundFile = Paths.get(URI.create(archivePath)).resolve(fileName);
        if (foundFile != null && Files.isRegularFile(foundFile, new LinkOption[0])) {
            return new FoundFile(foundFile);
        }
        return null;
    }

    @Override
    protected void setupClassProviders() {
        LinkedList<AsmModuleClassProvider> classProviders = new LinkedList<AsmModuleClassProvider>();
        classProviders.add(new AsmModuleClassProvider());
        this.classProviders = classProviders;
    }

    private List<String> getClassesUnderDirectory(final Path aPath) {
        SourceLocator.ClassSourceType cst = this.getClassSourceType(aPath);
        if (cst != SourceLocator.ClassSourceType.directory && cst != SourceLocator.ClassSourceType.jrt) {
            throw new RuntimeException("Invalid class source type");
        }
        final ArrayList<String> classes = new ArrayList<String>();
        FileVisitor<Path> fileVisitor = new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String fileName = aPath.relativize(file).toString().replace(file.getFileSystem().getSeparator(), ".");
                if (fileName.endsWith(".class")) {
                    classes.add(fileName.substring(0, fileName.lastIndexOf(".class")));
                } else if (fileName.endsWith(".jimple")) {
                    classes.add(fileName.substring(0, fileName.lastIndexOf(".jimple")));
                } else if (fileName.endsWith(".java")) {
                    classes.add(fileName.substring(0, fileName.lastIndexOf(".java")));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        };
        try {
            Files.walkFileTree(aPath, (FileVisitor<? super Path>)fileVisitor);
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), e);
        }
        return classes;
    }

    private static class Patterns {
        static final Pattern VERSION = Pattern.compile("-(\\d+(\\.|$))");
        static final Pattern ALPHA_NUM = Pattern.compile("[^A-Za-z0-9]");
        static final Pattern REPEATING_DOTS = Pattern.compile("(\\.)(\\1)+");
        static final Pattern LEADING_DOTS = Pattern.compile("^\\.");
        static final Pattern TRAILING_DOTS = Pattern.compile("\\.$");

        private Patterns() {
        }
    }
}

