/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ModuleScene;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootModuleResolver;
import soot.Type;
import soot.UnknownType;
import soot.options.Options;

public class ModuleRefType
extends RefType {
    private static final Logger logger = LoggerFactory.getLogger(ModuleRefType.class);
    private String moduleName;

    public ModuleRefType(Singletons.Global g2) {
        super(g2);
    }

    protected ModuleRefType(String className, String moduleName) {
        super(className);
        this.moduleName = moduleName;
    }

    public static RefType v(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return ModuleRefType.v(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public static RefType v(String className, Optional<String> moduleName) {
        RefType rt;
        String module;
        boolean isPresent = moduleName.isPresent();
        String string = module = isPresent ? ModuleUtil.v().declaringModule(className, moduleName.get()) : null;
        if (!isPresent && Options.v().verbose()) {
            logger.warn("ModuleRefType called with empty module for: " + className);
        }
        if ((rt = ModuleScene.v().getRefTypeUnsafe(className, Optional.fromNullable(module))) == null) {
            rt = new ModuleRefType(className, isPresent ? module : null);
            ModuleScene.v().addRefType(rt);
        }
        return rt;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public SootClass getSootClass() {
        if (this.sootClass == null) {
            super.setSootClass(SootModuleResolver.v().makeClassRef(this.getClassName(), Optional.fromNullable(this.moduleName)));
        }
        return super.getSootClass();
    }

    @Override
    public Type merge(Type other, Scene cm) {
        if (UnknownType.v().equals(other) || this.equals(other)) {
            return this;
        }
        if (!(other instanceof RefType)) {
            throw new RuntimeException("illegal type merge: " + this + " and " + other);
        }
        ModuleScene cmMod = (ModuleScene)cm;
        SootClass javalangObject = cm.getObjectType().getSootClass();
        LinkedList<SootClass> thisHierarchy = new LinkedList<SootClass>();
        LinkedList<SootClass> otherHierarchy = new LinkedList<SootClass>();
        SootClass sc = cmMod.getSootClass(this.getClassName(), Optional.fromNullable(this.moduleName));
        while (true) {
            thisHierarchy.addFirst(sc);
            if (sc == javalangObject) break;
            sc = sc.hasSuperclass() ? sc.getSuperclass() : javalangObject;
        }
        sc = cmMod.getSootClass(((RefType)other).getClassName(), Optional.fromNullable(this.moduleName));
        while (true) {
            otherHierarchy.addFirst(sc);
            if (sc == javalangObject) break;
            sc = sc.hasSuperclass() ? sc.getSuperclass() : javalangObject;
        }
        SootClass commonClass = null;
        while (!otherHierarchy.isEmpty() && !thisHierarchy.isEmpty() && otherHierarchy.getFirst() == thisHierarchy.getFirst()) {
            commonClass = (SootClass)otherHierarchy.removeFirst();
            thisHierarchy.removeFirst();
        }
        if (commonClass == null) {
            throw new RuntimeException("Could not find a common superclass for " + this + " and " + other);
        }
        return commonClass.getType();
    }

    @Override
    public Type getArrayElementType() {
        if (this.getClassName().equals(Scene.v().getObjectType().toString())) {
            return ModuleRefType.v(Scene.v().getObjectType().toString());
        }
        switch (this.getClassName()) {
            case "java.lang.Object": 
            case "java.io.Serializable": 
            case "java.lang.Cloneable": {
                return ModuleRefType.v("java.lang.Object", Optional.of("java.base"));
            }
            case "System.Array": {
                return ModuleRefType.v("System.Object");
            }
        }
        throw new RuntimeException("Attempt to get array base type of a non-array");
    }
}

