/*
 * Decompiled with CFR 0.152.
 */
package soot;

import com.google.common.base.Optional;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.ClassSource;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.ModulePathSourceLocator;
import soot.ModuleRefType;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.SootModuleResolver;
import soot.SourceLocator;
import soot.Type;
import soot.VoidType;
import soot.options.Options;
import soot.util.HashChain;

public class ModuleScene
extends Scene {
    private static final Logger logger = LoggerFactory.getLogger(Scene.class);
    private final Map<String, Map<String, RefType>> nameToClass = new HashMap<String, Map<String, RefType>>();
    private String modulePath = null;

    public ModuleScene(Singletons.Global g2) {
        super(g2);
        String smp = System.getProperty("soot.module.path");
        if (smp != null) {
            this.setSootModulePath(smp);
        }
        this.addBasicClass("java.lang.invoke.StringConcatFactory");
    }

    public static ModuleScene v() {
        return G.v().soot_ModuleScene();
    }

    @Override
    public SootMethod getMainMethod() {
        if (!this.hasMainClass()) {
            throw new RuntimeException("There is no main class set!");
        }
        SootMethod mainMethod = this.mainClass.getMethodUnsafe("main", Collections.singletonList(ArrayType.v(ModuleRefType.v("java.lang.String", Optional.of("java.base")), 1)), VoidType.v());
        if (mainMethod == null) {
            throw new RuntimeException("Main class declares no main method!");
        }
        return mainMethod;
    }

    @Override
    public void extendSootClassPath(String newPathElement) {
        this.extendSootModulePath(newPathElement);
    }

    public void extendSootModulePath(String newPathElement) {
        this.modulePath = this.modulePath + File.pathSeparatorChar + newPathElement;
        ModulePathSourceLocator.v().extendClassPath(newPathElement);
    }

    @Override
    public String getSootClassPath() {
        return this.getSootModulePath();
    }

    @Override
    public void setSootClassPath(String p) {
        this.setSootModulePath(p);
    }

    public String getSootModulePath() {
        if (this.modulePath == null) {
            String cp = Options.v().soot_modulepath();
            if (cp == null || cp.isEmpty()) {
                cp = this.defaultJavaModulePath();
            } else if (Options.v().prepend_classpath()) {
                cp = cp + File.pathSeparatorChar + this.defaultJavaModulePath();
            }
            List<String> dirs = Options.v().process_dir();
            if (!dirs.isEmpty()) {
                StringBuilder pds = new StringBuilder();
                for (String path : dirs) {
                    if (cp.contains(path)) continue;
                    pds.append(path).append(File.pathSeparatorChar);
                }
                cp = pds.append(cp).toString();
            }
            this.modulePath = cp;
        }
        return this.modulePath;
    }

    public void setSootModulePath(String p) {
        ModulePathSourceLocator.v().invalidateClassPath();
        this.modulePath = p;
    }

    private String defaultJavaModulePath() {
        StringBuilder sb = new StringBuilder();
        File rtJar = Paths.get(System.getProperty("java.home"), "lib", "jrt-fs.jar").toFile();
        if (!(rtJar.exists() && rtJar.isFile() || !Options.v().soot_modulepath().isEmpty())) {
            throw new RuntimeException("Error: cannot find jrt-fs.jar.");
        }
        sb.append("VIRTUAL_FS_FOR_JDK");
        return sb.toString();
    }

    @Override
    protected void addClassSilent(SootClass c) {
        if (c.isInScene()) {
            throw new RuntimeException("already managed: " + c.getName());
        }
        String className = c.getName();
        if (this.containsClass(className, Optional.fromNullable(c.moduleName))) {
            throw new RuntimeException("duplicate class: " + className);
        }
        this.classes.add(c);
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map == null) {
            map = new HashMap<String, RefType>();
            this.nameToClass.put(className, map);
        }
        map.put(c.moduleName, c.getType());
        c.getType().setSootClass(c);
        c.setInScene(true);
        if (!c.isPhantom) {
            this.modifyHierarchy();
        }
    }

    @Override
    public boolean containsClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.containsClass(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public boolean containsClass(String className, Optional<String> moduleName) {
        RefType type = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                type = map.get(ModuleUtil.v().declaringModule(className, moduleName.get()));
            } else {
                type = map.values().iterator().next();
                if (Options.v().verbose() && ModuleUtil.module_mode()) {
                    logger.warn("containsClass called with empty module for: " + className);
                }
            }
        }
        return type != null && type.hasSootClass() && type.getSootClass().isInScene();
    }

    @Override
    public boolean containsType(String className) {
        return this.nameToClass.containsKey(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass tryLoadClass(String className, int desiredLevel, Optional<String> moduleName) {
        this.setPhantomRefs(true);
        try (ClassSource source = ModulePathSourceLocator.v().getClassSource(className, moduleName);){
            if (!this.getPhantomRefs() && source == null) {
                this.setPhantomRefs(false);
                SootClass sootClass = null;
                return sootClass;
            }
        }
        SootClass toReturn = SootModuleResolver.v().resolveClass(className, desiredLevel, moduleName);
        this.setPhantomRefs(false);
        return toReturn;
    }

    @Override
    public SootClass loadClassAndSupport(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.loadClassAndSupport(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass loadClassAndSupport(String className, Optional<String> moduleName) {
        SootClass ret = this.loadClass(className, 2, moduleName);
        if (!ret.isPhantom()) {
            ret = this.loadClass(className, 3, moduleName);
        }
        return ret;
    }

    @Override
    public SootClass loadClass(String className, int desiredLevel) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.loadClass(wrapper.getClassName(), desiredLevel, wrapper.getModuleNameOptional());
    }

    public SootClass loadClass(String className, int desiredLevel, Optional<String> moduleName) {
        this.setPhantomRefs(true);
        SootClass toReturn = SootModuleResolver.v().resolveClass(className, desiredLevel, moduleName);
        this.setPhantomRefs(false);
        return toReturn;
    }

    public Type getType(String arg, Optional<String> moduleName) {
        String type = arg.replaceAll("([^\\[\\]]*)(.*)", "$1");
        Type result = this.getRefTypeUnsafe(type, moduleName);
        if (result == null) {
            switch (type) {
                case "long": {
                    result = LongType.v();
                    break;
                }
                case "short": {
                    result = ShortType.v();
                    break;
                }
                case "double": {
                    result = DoubleType.v();
                    break;
                }
                case "int": {
                    result = IntType.v();
                    break;
                }
                case "float": {
                    result = FloatType.v();
                    break;
                }
                case "byte": {
                    result = ByteType.v();
                    break;
                }
                case "char": {
                    result = CharType.v();
                    break;
                }
                case "void": {
                    result = VoidType.v();
                    break;
                }
                case "boolean": {
                    result = BooleanType.v();
                    break;
                }
                default: {
                    throw new RuntimeException("unknown type: '" + type + "'");
                }
            }
        }
        int arrayCount = arg.contains("[") ? arg.replaceAll("([^\\[\\]]*)(.*)", "$2").length() / 2 : 0;
        return arrayCount == 0 ? result : ArrayType.v(result, arrayCount);
    }

    public RefType getRefType(String className, Optional<String> moduleName) {
        RefType refType = this.getRefTypeUnsafe(className, moduleName);
        if (refType == null) {
            throw new IllegalStateException("RefType " + className + " not loaded. If you tried to get the RefType of a library class, did you call loadNecessaryClasses()? Otherwise please check Soot's classpath.");
        }
        return refType;
    }

    @Override
    public RefType getRefType(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getRefType(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    @Override
    public RefType getObjectType() {
        if (Options.v().src_prec() == 7) {
            return this.getRefType("System.Object");
        }
        return this.getRefType("java.lang.Object", Optional.of("java.base"));
    }

    public RefType getRefTypeUnsafe(String className, Optional<String> moduleName) {
        RefType refType = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                refType = map.get(moduleName.get());
            } else {
                refType = map.values().iterator().next();
                if (Options.v().verbose() && ModuleUtil.module_mode()) {
                    logger.warn("getRefTypeUnsafe called with empty module for: " + className);
                }
            }
        }
        return refType;
    }

    @Override
    public RefType getRefTypeUnsafe(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getRefTypeUnsafe(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public void addRefType(RefType type) {
        String className = type.getClassName();
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map == null) {
            map = new HashMap<String, RefType>();
            this.nameToClass.put(className, map);
        }
        map.put(((ModuleRefType)type).getModuleName(), type);
    }

    @Override
    public SootClass getSootClassUnsafe(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getSootClassUnsafe(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass getSootClassUnsafe(String className, Optional<String> moduleName) {
        SootClass tsc;
        RefType type = null;
        Map<String, RefType> map = this.nameToClass.get(className);
        if (map != null && !map.isEmpty()) {
            if (moduleName.isPresent()) {
                type = map.get(ModuleUtil.v().declaringModule(className, moduleName.get()));
            } else {
                type = map.values().iterator().next();
                if (Options.v().verbose() && ModuleUtil.module_mode()) {
                    logger.warn("getSootClassUnsafe called with empty for: " + className);
                }
            }
        }
        if (type != null && (tsc = type.getSootClass()) != null) {
            return tsc;
        }
        if (this.allowsPhantomRefs() || "soot.dummy.InvokeDynamic".equals(className)) {
            SootClass c = new SootClass(className);
            this.addClassSilent(c);
            c.setPhantomClass();
            return c;
        }
        return null;
    }

    @Override
    public SootClass getSootClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.getSootClass(wrapper.getClassName(), wrapper.getModuleNameOptional());
    }

    public SootClass getSootClass(String className, Optional<String> moduleName) {
        SootClass sc = this.getSootClassUnsafe(className, moduleName);
        if (sc != null) {
            return sc;
        }
        throw new RuntimeException(System.lineSeparator() + "Aborting: can't find classfile " + className);
    }

    @Override
    public void loadBasicClasses() {
        this.addReflectionTraceClasses();
        ModuleUtil modU = ModuleUtil.v();
        int loadedClasses = 0;
        for (int i = 3; i >= 1; --i) {
            for (String name : this.basicclasses[i]) {
                ModuleUtil.ModuleClassNameWrapper wrapper = modU.makeWrapper(name);
                SootClass sootClass = this.tryLoadClass(wrapper.getClassName(), i, wrapper.getModuleNameOptional());
                if (sootClass == null || sootClass.isPhantom()) continue;
                ++loadedClasses;
            }
        }
        if (loadedClasses == 0) {
            throw new RuntimeException("None of the basic classes could be loaded! Check your Soot class path!");
        }
    }

    @Override
    public void loadNecessaryClasses() {
        this.loadBasicClasses();
        Options opts = Options.v();
        for (String name : opts.classes()) {
            this.loadNecessaryClass(name);
        }
        this.loadDynamicClasses();
        if (opts.oaat()) {
            if (opts.process_dir().isEmpty()) {
                throw new IllegalArgumentException("If switch -oaat is used, then also -process-dir must be given.");
            }
        } else {
            for (String path : opts.process_dir()) {
                for (Map.Entry<String, List<String>> entry : ModulePathSourceLocator.v().getClassUnderModulePath(path).entrySet()) {
                    for (String cl : entry.getValue()) {
                        SootClass theClass = this.loadClassAndSupport(cl, Optional.fromNullable(entry.getKey()));
                        theClass.setApplicationClass();
                    }
                }
            }
        }
        this.prepareClasses();
        this.setDoneResolving();
    }

    @Override
    public void loadDynamicClasses() {
        ArrayList<SootClass> dynamicClasses = new ArrayList<SootClass>();
        Options opts = Options.v();
        HashMap<String, List<String>> temp = new HashMap<String, List<String>>();
        temp.put(null, opts.dynamic_class());
        ModulePathSourceLocator msloc = ModulePathSourceLocator.v();
        for (String string : opts.dynamic_dir()) {
            temp.putAll(msloc.getClassUnderModulePath(string));
        }
        SourceLocator sloc = SourceLocator.v();
        for (String pkg : opts.dynamic_package()) {
            ((List)temp.get(null)).addAll(sloc.classesInDynamicPackage(pkg));
        }
        for (Map.Entry entry : temp.entrySet()) {
            for (String className : (List)entry.getValue()) {
                dynamicClasses.add(this.loadClassAndSupport(className, Optional.fromNullable((String)entry.getKey())));
            }
        }
        Iterator iterator = dynamicClasses.iterator();
        while (iterator.hasNext()) {
            SootClass c = (SootClass)iterator.next();
            if (c.isConcrete()) continue;
            if (opts.verbose()) {
                logger.warn("dynamic class " + c.getName() + " is abstract or an interface, and it will not be considered.");
            }
            iterator.remove();
        }
        this.dynamicClasses = dynamicClasses;
    }

    @Override
    protected void prepareClasses() {
        LinkedList optionsClasses = Options.v().classes();
        HashChain<SootClass> processedClasses = new HashChain<SootClass>();
        block0: while (true) {
            HashChain<SootClass> unprocessedClasses = new HashChain<SootClass>(this.getClasses());
            unprocessedClasses.removeAll(processedClasses);
            if (unprocessedClasses.isEmpty()) break;
            processedClasses.addAll(unprocessedClasses);
            Iterator iterator = unprocessedClasses.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                SootClass s2 = (SootClass)iterator.next();
                if (s2.isPhantom()) continue;
                if (Options.v().app()) {
                    s2.setApplicationClass();
                }
                if (optionsClasses.contains(s2.getName())) {
                    s2.setApplicationClass();
                    continue;
                }
                if (s2.isApplicationClass() && this.isExcluded(s2)) {
                    s2.setLibraryClass();
                }
                if (this.isIncluded(s2)) {
                    s2.setApplicationClass();
                }
                if (!s2.isApplicationClass()) continue;
                this.loadClassAndSupport(s2.getName(), Optional.fromNullable(s2.moduleName));
            }
            break;
        }
    }

    @Override
    public void setMainClassFromOptions() {
        if (this.mainClass == null) {
            String optsMain = Options.v().main_class();
            if (optsMain != null && !optsMain.isEmpty()) {
                this.setMainClass(this.getSootClass(optsMain, null));
            } else {
                List<Type> mainArgs = Collections.singletonList(ArrayType.v(ModuleRefType.v("java.lang.String", Optional.of("java.base")), 1));
                for (String s2 : Options.v().classes()) {
                    SootClass c = this.getSootClass(s2, null);
                    if (!c.declaresMethod("main", mainArgs, VoidType.v())) continue;
                    logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                    this.setMainClass(c);
                    return;
                }
                for (SootClass c : this.getApplicationClasses()) {
                    if (!c.declaresMethod("main", mainArgs, VoidType.v())) continue;
                    logger.debug("No main class given. Inferred '" + c.getName() + "' as main class.");
                    this.setMainClass(c);
                    return;
                }
            }
        }
    }

    @Override
    public SootClass forceResolve(String className, int level) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.forceResolve(wrapper.getClassName(), level, wrapper.getModuleNameOptional());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SootClass forceResolve(String className, int level, Optional<String> moduleName) {
        SootClass c;
        boolean tmp = this.doneResolving;
        this.doneResolving = false;
        try {
            c = SootModuleResolver.v().resolveClass(className, level, moduleName);
        }
        finally {
            this.doneResolving = tmp;
        }
        return c;
    }

    @Override
    public SootClass makeSootClass(String className) {
        ModuleUtil.ModuleClassNameWrapper wrapper = ModuleUtil.v().makeWrapper(className);
        return this.makeSootClass(wrapper.getClassName(), wrapper.getModuleName());
    }

    public SootClass makeSootClass(String name, String moduleName) {
        return new SootClass(name, moduleName);
    }

    public RefType getOrAddRefType(RefType tp) {
        RefType existing = this.getRefType(tp.getClassName(), Optional.fromNullable(((ModuleRefType)tp).getModuleName()));
        if (existing != null) {
            return existing;
        }
        this.addRefType(tp);
        return tp;
    }

    public RefType getOrAddRefType(String className, Optional<String> moduleName) {
        RefType existing = this.getRefType(className, moduleName);
        if (existing != null) {
            return existing;
        }
        RefType tp = ModuleRefType.v(className, moduleName);
        this.addRefType(tp);
        return tp;
    }
}

