/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Function;
import soot.AttributesUnitPrinter;
import soot.Body;
import soot.BriefUnitPrinter;
import soot.G;
import soot.LabeledUnitPrinter;
import soot.Local;
import soot.Modifier;
import soot.NormalUnitPrinter;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.UnitPrinter;
import soot.options.Options;
import soot.tagkit.Host;
import soot.tagkit.JimpleLineNumberTag;
import soot.tagkit.Tag;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.util.DeterministicHashMap;

public class Printer {
    public static final int USE_ABBREVIATIONS = 1;
    public static final int ADD_JIMPLE_LN = 16;
    private int options = 0;
    private int jimpleLnNum = 0;
    private Function<Body, LabeledUnitPrinter> customUnitPrinter;
    private Function<SootClass, String> customClassSignaturePrinter;
    private Function<SootMethod, String> customMethodSignaturePrinter;

    public Printer(Singletons.Global g2) {
    }

    public static Printer v() {
        return G.v().soot_Printer();
    }

    public boolean useAbbreviations() {
        return (this.options & 1) != 0;
    }

    public boolean addJimpleLn() {
        return (this.options & 0x10) != 0;
    }

    public void setOption(int opt) {
        this.options |= opt;
    }

    public void clearOption(int opt) {
        this.options &= ~opt;
    }

    public int getJimpleLnNum() {
        return this.jimpleLnNum;
    }

    public void setJimpleLnNum(int newVal) {
        this.jimpleLnNum = newVal;
    }

    public void incJimpleLnNum() {
        ++this.jimpleLnNum;
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator<SootClass> interfaceIt;
        this.setJimpleLnNum(1);
        StringBuilder sb = new StringBuilder();
        Iterator<SootField> st = new StringTokenizer(Modifier.toString(cl.getModifiers()));
        while (((StringTokenizer)((Object)st)).hasMoreTokens()) {
            String tok = ((StringTokenizer)((Object)st)).nextToken();
            if (cl.isInterface() && "abstract".equals(tok)) continue;
            sb.append(tok).append(' ');
        }
        sb.append(cl.isInterface() ? " " : "class ").append(this.printSignature(cl));
        out.print(sb.toString());
        if (cl.hasSuperclass()) {
            out.print(" extends " + this.printSignature(cl.getSuperclass()));
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            out.print(" implements " + this.printSignature(interfaceIt.next()));
            while (interfaceIt.hasNext()) {
                out.print(", " + this.printSignature(interfaceIt.next()));
            }
        }
        out.println();
        this.incJimpleLnNum();
        out.println('{');
        this.incJimpleLnNum();
        boolean printTagsInOutput = Options.v().print_tags_in_output();
        if (printTagsInOutput) {
            for (Tag t : cl.getTags()) {
                out.println("/*" + t.toString() + "*/");
            }
        }
        for (SootField f : cl.getFields()) {
            if (f.isPhantom()) continue;
            if (printTagsInOutput) {
                for (Tag tag : f.getTags()) {
                    out.println("/*" + tag.toString() + "*/");
                }
            }
            out.println("    " + f.getDeclaration() + ";");
            if (!this.addJimpleLn()) continue;
            this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), f));
        }
        Iterator<SootMethod> methodIt = cl.methodIterator();
        if (methodIt.hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
                this.incJimpleLnNum();
            }
            do {
                SootMethod method;
                if ((method = methodIt.next()).isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    Body body = method.retrieveActiveBody();
                    if (body == null) {
                        throw new RuntimeException("method " + method.getName() + " has no active body!");
                    }
                    if (printTagsInOutput) {
                        for (Tag t : method.getTags()) {
                            out.println("/*" + t.toString() + "*/");
                        }
                    }
                    this.printTo(body, out);
                } else {
                    if (printTagsInOutput) {
                        for (Tag tag : method.getTags()) {
                            out.println("/*" + tag.toString() + "*/");
                        }
                    }
                    out.println("    " + method.getDeclaration() + ";");
                    this.incJimpleLnNum();
                }
                if (!methodIt.hasNext()) continue;
                out.println();
                this.incJimpleLnNum();
            } while (methodIt.hasNext());
        }
        out.println("}");
        this.incJimpleLnNum();
    }

    public void printTo(Body b, PrintWriter out) {
        out.println("    " + this.printSignature(b.getMethod()));
        if (this.addJimpleLn()) {
            this.setJimpleLnNum(this.addJimpleLnTags(this.getJimpleLnNum(), b.getMethod()));
        }
        out.println("    {");
        this.incJimpleLnNum();
        LabeledUnitPrinter up = this.getUnitPrinter(b);
        if (this.addJimpleLn()) {
            up.setPositionTagger(new AttributesUnitPrinter(this.getJimpleLnNum()));
        }
        this.printLocalsInBody(b, up);
        this.printStatementsInBody(b, out, up, new BriefUnitGraph(b));
        out.println("    }");
        this.incJimpleLnNum();
    }

    public void setCustomUnitPrinter(Function<Body, LabeledUnitPrinter> customUnitPrinter) {
        this.customUnitPrinter = customUnitPrinter;
    }

    public void setCustomClassSignaturePrinter(Function<SootClass, String> customPrinter) {
        this.customClassSignaturePrinter = customPrinter;
    }

    public void setCustomMethodSignaturePrinter(Function<SootMethod, String> customPrinter) {
        this.customMethodSignaturePrinter = customPrinter;
    }

    private LabeledUnitPrinter getUnitPrinter(Body b) {
        if (this.customUnitPrinter != null) {
            return this.customUnitPrinter.apply(b);
        }
        if (this.useAbbreviations()) {
            return new BriefUnitPrinter(b);
        }
        return new NormalUnitPrinter(b);
    }

    private String printSignature(SootClass sootClass) {
        if (this.customClassSignaturePrinter != null) {
            return this.customClassSignaturePrinter.apply(sootClass);
        }
        return Scene.v().quotedNameOf(sootClass.getName());
    }

    private String printSignature(SootMethod sootMethod) {
        if (this.customMethodSignaturePrinter != null) {
            return this.customMethodSignaturePrinter.apply(sootMethod);
        }
        return sootMethod.getDeclaration();
    }

    private void printStatementsInBody(Body body, PrintWriter out, LabeledUnitPrinter up, UnitGraph unitGraph) {
        Iterator<Trap> trapIt;
        UnitPatchingChain units = body.getUnits();
        Unit firstUnit = (Unit)units.getFirst();
        for (Unit currentStmt : units) {
            Object succs;
            if (currentStmt != firstUnit && ((succs = unitGraph.getSuccsOf(currentStmt)).size() != 1 || succs.get(0) != currentStmt || unitGraph.getPredsOf(currentStmt).size() != 1 || up.labels().containsKey(currentStmt))) {
                up.newline();
            }
            if (up.labels().containsKey(currentStmt)) {
                up.unitRef(currentStmt, true);
                up.literal(":");
                up.newline();
            }
            if (up.references().containsKey(currentStmt)) {
                up.unitRef(currentStmt, false);
            }
            up.startUnit(currentStmt);
            currentStmt.toString(up);
            up.endUnit(currentStmt);
            up.literal(";");
            up.newline();
            if (!Options.v().print_tags_in_output()) continue;
            succs = currentStmt.getTags().iterator();
            while (succs.hasNext()) {
                Tag t = (Tag)succs.next();
                up.noIndent();
                up.literal("/*");
                up.literal(t.toString());
                up.literal("*/");
                up.newline();
            }
        }
        out.print(up.toString());
        if (this.addJimpleLn()) {
            this.setJimpleLnNum(up.getPositionTagger().getEndLn());
        }
        if ((trapIt = body.getTraps().iterator()).hasNext()) {
            out.println();
            this.incJimpleLnNum();
            do {
                Trap trap = trapIt.next();
                Map<Unit, String> lbls = up.labels();
                out.println("        catch " + this.printSignature(trap.getException()) + " from " + lbls.get(trap.getBeginUnit()) + " to " + lbls.get(trap.getEndUnit()) + " with " + lbls.get(trap.getHandlerUnit()) + ";");
                this.incJimpleLnNum();
            } while (trapIt.hasNext());
        }
    }

    private int addJimpleLnTags(int lnNum, Host h2) {
        h2.addTag(new JimpleLineNumberTag(lnNum));
        return lnNum + 1;
    }

    private void printLocalsInBody(Body body, UnitPrinter up) {
        DeterministicHashMap<Type, ArrayList<Local>> typeToLocals = new DeterministicHashMap<Type, ArrayList<Local>>(body.getLocalCount() * 2 + 1, 0.7f);
        for (Local local : body.getLocals()) {
            Type t = local.getType();
            ArrayList<Local> localList = (ArrayList<Local>)typeToLocals.get(t);
            if (localList == null) {
                localList = new ArrayList<Local>();
                typeToLocals.put(t, localList);
            }
            localList.add(local);
        }
        for (Map.Entry entry : typeToLocals.entrySet()) {
            up.type((Type)entry.getKey());
            up.literal(" ");
            Iterator it = ((List)entry.getValue()).iterator();
            while (it.hasNext()) {
                Local l = (Local)it.next();
                up.local(l);
                if (!it.hasNext()) continue;
                up.literal(", ");
            }
            up.literal(";");
            up.newline();
        }
        if (!typeToLocals.isEmpty()) {
            up.newline();
        }
    }
}

