/*
 * Decompiled with CFR 0.152.
 */
package soot;

import beaver.Parser;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.ClassSource;
import soot.G;
import soot.JastAddJ.BytecodeParser;
import soot.JastAddJ.CompilationUnit;
import soot.JastAddJ.JastAddJavaParser;
import soot.JastAddJ.JavaParser;
import soot.JastAddJ.Options;
import soot.JastAddJ.Program;
import soot.ModulePathSourceLocator;
import soot.ModuleUtil;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootModuleInfo;
import soot.SourceLocator;
import soot.Type;
import soot.javaToJimple.IInitialResolver;
import soot.util.ConcurrentHashMultiMap;
import soot.util.MultiMap;

public class SootResolver {
    private static final Logger logger = LoggerFactory.getLogger(SootResolver.class);
    protected MultiMap<SootClass, Type> classToTypesSignature = new ConcurrentHashMultiMap<SootClass, Type>();
    protected MultiMap<SootClass, Type> classToTypesHierarchy = new ConcurrentHashMultiMap<SootClass, Type>();
    private final Deque<SootClass>[] worklist = new Deque[4];
    private Program program = null;

    public SootResolver(Singletons.Global g2) {
        this.worklist[1] = new ArrayDeque<SootClass>();
        this.worklist[2] = new ArrayDeque<SootClass>();
        this.worklist[3] = new ArrayDeque<SootClass>();
    }

    protected void initializeProgram() {
        if (soot.options.Options.v().src_prec() != 6) {
            this.program = new Program();
            this.program.state().reset();
            this.program.initBytecodeReader(new BytecodeParser());
            this.program.initJavaParser(new JavaParser(){

                @Override
                public CompilationUnit parse(InputStream is, String fileName) throws IOException, Parser.Exception {
                    return new JastAddJavaParser().parse(is, fileName);
                }
            });
            Options options = this.program.options();
            options.initOptions();
            options.addKeyValueOption("-classpath");
            options.setValueForOption(Scene.v().getSootClassPath(), "-classpath");
            switch (soot.options.Options.v().src_prec()) {
                case 4: {
                    this.program.setSrcPrec(1);
                    break;
                }
                case 1: {
                    this.program.setSrcPrec(2);
                    break;
                }
                case 2: {
                    this.program.setSrcPrec(2);
                    break;
                }
            }
            this.program.initPaths();
        }
    }

    public static SootResolver v() {
        if (ModuleUtil.module_mode()) {
            return G.v().soot_SootModuleResolver();
        }
        return G.v().soot_SootResolver();
    }

    protected boolean resolveEverything() {
        soot.options.Options opts = soot.options.Options.v();
        if (opts.on_the_fly()) {
            return false;
        }
        return opts.whole_program() || opts.whole_shimple() || opts.full_resolver() || opts.output_format() == 15;
    }

    public SootClass makeClassRef(String className) {
        if (className.length() == 0) {
            throw new RuntimeException("Classname must not be empty!");
        }
        Scene scene = Scene.v();
        if (scene.containsClass(className)) {
            return scene.getSootClass(className);
        }
        SootClass newClass = className.endsWith("module-info") ? new SootModuleInfo(className, null) : new SootClass(className);
        newClass.setResolvingLevel(0);
        scene.addClass(newClass);
        return newClass;
    }

    public SootClass resolveClass(String className, int desiredLevel) {
        SootClass resolvedClass = null;
        try {
            resolvedClass = this.makeClassRef(className);
            this.addToResolveWorklist(resolvedClass, desiredLevel);
            this.processResolveWorklist();
            return resolvedClass;
        }
        catch (SootClassNotFoundException e) {
            if (resolvedClass != null) {
                assert (resolvedClass.resolvingLevel() == 0);
                Scene.v().removeClass(resolvedClass);
            }
            throw e;
        }
    }

    protected void processResolveWorklist() {
        Scene scene = Scene.v();
        boolean resolveEverything = this.resolveEverything();
        boolean no_bodies_for_excluded = soot.options.Options.v().no_bodies_for_excluded();
        for (int i = 3; i >= 1; --i) {
            Deque<SootClass> currWorklist = this.worklist[i];
            while (!currWorklist.isEmpty()) {
                SootClass sc = currWorklist.pop();
                if (resolveEverything) {
                    boolean onlySignatures;
                    boolean bl = onlySignatures = sc.isPhantom() || no_bodies_for_excluded && scene.isExcluded(sc) && !scene.isBasicClass(sc.getName());
                    if (onlySignatures) {
                        this.bringToSignatures(sc);
                        sc.setPhantomClass();
                        for (SootMethod m3 : sc.getMethods()) {
                            m3.setPhantom(true);
                        }
                        for (SootField f : sc.getFields()) {
                            f.setPhantom(true);
                        }
                        continue;
                    }
                    this.bringToBodies(sc);
                    continue;
                }
                switch (i) {
                    case 3: {
                        this.bringToBodies(sc);
                        break;
                    }
                    case 2: {
                        this.bringToSignatures(sc);
                        break;
                    }
                    case 1: {
                        this.bringToHierarchy(sc);
                    }
                }
            }
            this.worklist[i] = new ArrayDeque<SootClass>(0);
        }
    }

    protected void addToResolveWorklist(Type type, int level) {
        if (type instanceof RefType) {
            this.addToResolveWorklist(((RefType)type).getSootClass(), level);
        } else if (type instanceof ArrayType) {
            this.addToResolveWorklist(((ArrayType)type).baseType, level);
        }
    }

    protected void addToResolveWorklist(SootClass sc, int desiredLevel) {
        if (sc.resolvingLevel() >= desiredLevel) {
            return;
        }
        this.worklist[desiredLevel].add(sc);
    }

    protected void bringToHierarchy(SootClass sc) {
        if (sc.resolvingLevel() >= 1) {
            return;
        }
        if (soot.options.Options.v().debug_resolver()) {
            logger.debug("bringing to HIERARCHY: " + sc);
        }
        sc.setResolvingLevel(1);
        this.bringToHierarchyUnchecked(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bringToHierarchyUnchecked(SootClass sc) {
        String className = sc.getName();
        try (ClassSource is = ModuleUtil.module_mode() ? ModulePathSourceLocator.v().getClassSource(className, Optional.fromNullable(sc.moduleName)) : SourceLocator.v().getClassSource(className);){
            boolean modelAsPhantomRef;
            boolean bl = modelAsPhantomRef = is == null;
            if (modelAsPhantomRef) {
                if (!Scene.v().allowsPhantomRefs()) {
                    String suffix = "";
                    if ("java.lang.Object".equals(className)) {
                        suffix = " Try adding rt.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.Main -cp .:/path/to/jdk/jre/lib/rt.jar <other options>";
                    } else if ("javax.crypto.Cipher".equals(className)) {
                        suffix = " Try adding jce.jar to Soot's classpath, e.g.:\njava -cp sootclasses.jar soot.Main -cp .:/path/to/jdk/jre/lib/rt.jar:/path/to/jdk/jre/lib/jce.jar <other options>";
                    }
                    throw new SootClassNotFoundException("couldn't find class: " + className + " (is your soot-class-path set properly?)" + suffix);
                }
                sc.setPhantomClass();
            } else {
                IInitialResolver.Dependencies dependencies = is.resolve(sc);
                if (!dependencies.typesToSignature.isEmpty()) {
                    this.classToTypesSignature.putAll(sc, dependencies.typesToSignature);
                }
                if (!dependencies.typesToHierarchy.isEmpty()) {
                    this.classToTypesHierarchy.putAll(sc, dependencies.typesToHierarchy);
                }
            }
        }
        this.reResolveHierarchy(sc, 1);
    }

    public void reResolveHierarchy(SootClass sc, int level) {
        SootClass outerClass;
        SootClass superClass = sc.getSuperclassUnsafe();
        if (superClass != null) {
            this.addToResolveWorklist(superClass, level);
        }
        if ((outerClass = sc.getOuterClassUnsafe()) != null) {
            this.addToResolveWorklist(outerClass, level);
        }
        for (SootClass iface : sc.getInterfaces()) {
            this.addToResolveWorklist(iface, level);
        }
    }

    protected void bringToSignatures(SootClass sc) {
        if (sc.resolvingLevel() >= 2) {
            return;
        }
        this.bringToHierarchy(sc);
        if (soot.options.Options.v().debug_resolver()) {
            logger.debug("bringing to SIGNATURES: " + sc);
        }
        sc.setResolvingLevel(2);
        this.bringToSignaturesUnchecked(sc);
    }

    protected void bringToSignaturesUnchecked(SootClass sc) {
        for (SootField f : sc.getFields()) {
            this.addToResolveWorklist(f.getType(), 1);
        }
        for (SootMethod m3 : sc.getMethods()) {
            this.addToResolveWorklist(m3.getReturnType(), 1);
            for (Type ptype : m3.getParameterTypes()) {
                this.addToResolveWorklist(ptype, 1);
            }
            List<SootClass> exceptions = m3.getExceptionsUnsafe();
            if (exceptions == null) continue;
            for (SootClass exception : exceptions) {
                this.addToResolveWorklist(exception, 1);
            }
        }
        this.reResolveHierarchy(sc, 2);
    }

    protected void bringToBodies(SootClass sc) {
        if (sc.resolvingLevel() >= 3) {
            return;
        }
        this.bringToSignatures(sc);
        if (soot.options.Options.v().debug_resolver()) {
            logger.debug("bringing to BODIES: " + sc);
        }
        sc.setResolvingLevel(3);
        this.bringToBodiesUnchecked(sc);
    }

    protected void bringToBodiesUnchecked(SootClass sc) {
        Set<Type> references = this.classToTypesHierarchy.get(sc);
        if (references != null) {
            for (Type t : references) {
                this.addToResolveWorklist(t, 1);
            }
        }
        if ((references = this.classToTypesSignature.get(sc)) != null) {
            for (Type t : references) {
                this.addToResolveWorklist(t, 2);
            }
        }
    }

    public void reResolve(SootClass cl, int newResolvingLevel) {
        int resolvingLevel = cl.resolvingLevel();
        if (resolvingLevel >= newResolvingLevel) {
            return;
        }
        this.reResolveHierarchy(cl, 1);
        cl.setResolvingLevel(newResolvingLevel);
        this.addToResolveWorklist(cl, resolvingLevel);
        this.processResolveWorklist();
    }

    public void reResolve(SootClass cl) {
        this.reResolve(cl, 1);
    }

    public Program getProgram() {
        if (this.program == null) {
            this.initializeProgram();
        }
        return this.program;
    }

    public class SootClassNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1563461446590293827L;

        public SootClassNotFoundException(String s2) {
            super(s2);
        }
    }
}

