/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.util.List;
import soot.G;
import soot.options.Options;

public class Timer {
    private long duration;
    private long startTime;
    private boolean hasStarted;
    private String name;

    public Timer(String name) {
        this.name = name;
        this.duration = 0L;
    }

    public Timer() {
        this("unnamed");
    }

    static void doGarbageCollecting() {
        G g2 = G.v();
        if (g2.Timer_isGarbageCollecting || !Options.v().subtract_gc() || g2.Timer_count++ % 4 != 0) {
            return;
        }
        g2.Timer_isGarbageCollecting = true;
        g2.Timer_forcedGarbageCollectionTimer.start();
        for (Timer t : g2.Timer_outstandingTimers) {
            t.end();
        }
        System.gc();
        for (Timer t : g2.Timer_outstandingTimers) {
            t.start();
        }
        g2.Timer_forcedGarbageCollectionTimer.end();
        g2.Timer_isGarbageCollecting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Timer.doGarbageCollecting();
        this.startTime = System.nanoTime();
        if (this.hasStarted) {
            throw new RuntimeException("timer " + this.name + " has already been started!");
        }
        this.hasStarted = true;
        if (!G.v().Timer_isGarbageCollecting) {
            List<Timer> list = G.v().Timer_outstandingTimers;
            synchronized (list) {
                G.v().Timer_outstandingTimers.add(this);
            }
        }
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        if (!this.hasStarted) {
            throw new RuntimeException("timer " + this.name + " has not been started!");
        }
        this.hasStarted = false;
        this.duration += System.nanoTime() - this.startTime;
        if (!G.v().Timer_isGarbageCollecting) {
            List<Timer> list = G.v().Timer_outstandingTimers;
            synchronized (list) {
                G.v().Timer_outstandingTimers.remove(this);
            }
        }
    }

    public long getTime() {
        return this.duration / 1000000L;
    }
}

