/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import soot.ArrayType;
import soot.MethodSource;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.asm.AnnotationElemBuilder;
import soot.asm.AsmMethodSource;
import soot.asm.AsmUtil;
import soot.asm.SootClassBuilder;
import soot.asm.TagBuilder;
import soot.tagkit.AnnotationDefaultTag;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationTag;
import soot.tagkit.ParamNamesTag;
import soot.tagkit.VisibilityAnnotationTag;
import soot.tagkit.VisibilityLocalVariableAnnotationTag;
import soot.tagkit.VisibilityParameterAnnotationTag;

public class MethodBuilder
extends JSRInlinerAdapter {
    private TagBuilder tb;
    private VisibilityAnnotationTag[] visibleParamAnnotations;
    private VisibilityAnnotationTag[] invisibleParamAnnotations;
    private List<VisibilityAnnotationTag> visibleLocalVarAnnotations;
    private List<VisibilityAnnotationTag> invisibleLocalVarAnnotations;
    private final SootMethod method;
    private final SootClassBuilder scb;
    private final String[] parameterNames;
    private final Map<Integer, Integer> slotToParameter;

    public MethodBuilder(SootMethod method, SootClassBuilder scb, String desc, String[] ex) {
        super(393216, null, method.getModifiers(), method.getName(), desc, null, ex);
        this.method = method;
        this.scb = scb;
        this.parameterNames = new String[method.getParameterCount()];
        this.slotToParameter = this.createSlotToParameterMap();
    }

    private Map<Integer, Integer> createSlotToParameterMap() {
        int paramCount = this.method.getParameterCount();
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>(paramCount);
        int curSlot = this.method.isStatic() ? 0 : 1;
        for (int i = 0; i < paramCount; ++i) {
            slotMap.put(curSlot, i);
            ++curSlot;
            if (!AsmUtil.isDWord(this.method.getParameterType(i))) continue;
            ++curSlot;
        }
        return slotMap;
    }

    private TagBuilder getTagBuilder() {
        TagBuilder t = this.tb;
        if (t == null) {
            t = this.tb = new TagBuilder(this.method, this.scb);
        }
        return t;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.getTagBuilder().visitAnnotation(desc, visible);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        return new AnnotationElemBuilder(1){

            @Override
            public void visitEnd() {
                MethodBuilder.this.method.addTag(new AnnotationDefaultTag((AnnotationElem)this.elems.get(0)));
            }
        };
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.getTagBuilder().visitAttribute(attr);
    }

    @Override
    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
        Integer paramIdx;
        super.visitLocalVariable(name, descriptor, signature, start, end, index);
        if (name != null && !name.isEmpty() && index > 0 && (paramIdx = this.slotToParameter.get(index)) != null) {
            this.parameterNames[paramIdx.intValue()] = name;
        }
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String descriptor, boolean visible) {
        final VisibilityAnnotationTag vat = new VisibilityAnnotationTag(visible ? 0 : 1);
        if (visible) {
            if (this.visibleLocalVarAnnotations == null) {
                this.visibleLocalVarAnnotations = new ArrayList<VisibilityAnnotationTag>(2);
            }
            this.visibleLocalVarAnnotations.add(vat);
        } else {
            if (this.invisibleLocalVarAnnotations == null) {
                this.invisibleLocalVarAnnotations = new ArrayList<VisibilityAnnotationTag>(2);
            }
            this.invisibleLocalVarAnnotations.add(vat);
        }
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag annotTag = new AnnotationTag(MethodBuilder.this.desc, this.elems);
                vat.addAnnotation(annotTag);
            }
        };
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, final String desc, boolean visible) {
        VisibilityAnnotationTag vat;
        if (visible) {
            VisibilityAnnotationTag[] vats = this.visibleParamAnnotations;
            if (vats == null) {
                this.visibleParamAnnotations = vats = new VisibilityAnnotationTag[this.method.getParameterCount()];
            }
            if ((vat = vats[parameter]) == null) {
                vats[parameter] = vat = new VisibilityAnnotationTag(0);
            }
        } else {
            VisibilityAnnotationTag[] vats = this.invisibleParamAnnotations;
            if (vats == null) {
                this.invisibleParamAnnotations = vats = new VisibilityAnnotationTag[this.method.getParameterCount()];
            }
            if ((vat = vats[parameter]) == null) {
                vats[parameter] = vat = new VisibilityAnnotationTag(1);
            }
        }
        final VisibilityAnnotationTag _vat = vat;
        return new AnnotationElemBuilder(){

            @Override
            public void visitEnd() {
                AnnotationTag annotTag = new AnnotationTag(desc, this.elems);
                _vat.addAnnotation(annotTag);
            }
        };
    }

    @Override
    public void visitTypeInsn(int op, String t) {
        super.visitTypeInsn(op, t);
        Type rt = AsmUtil.toJimpleRefType(t, Optional.fromNullable(this.scb.getKlass().moduleName));
        if (rt instanceof ArrayType) {
            this.scb.addDep(((ArrayType)rt).baseType);
        } else {
            this.scb.addDep(rt);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        super.visitFieldInsn(opcode, owner, name, desc);
        for (Type t : AsmUtil.toJimpleDesc(desc, Optional.fromNullable(this.scb.getKlass().moduleName))) {
            if (!(t instanceof RefType)) continue;
            this.scb.addDep(t);
        }
        this.scb.addDep(AsmUtil.toQualifiedName(owner));
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean isInterf) {
        super.visitMethodInsn(opcode, owner, name, desc, isInterf);
        for (Type t : AsmUtil.toJimpleDesc(desc, Optional.fromNullable(this.scb.getKlass().moduleName))) {
            this.addDeps(t);
        }
        this.scb.addDep(AsmUtil.toJimpleRefType(owner, Optional.fromNullable(this.scb.getKlass().moduleName)));
    }

    @Override
    public void visitLdcInsn(Object cst) {
        super.visitLdcInsn(cst);
        if (cst instanceof Handle) {
            Handle methodHandle = (Handle)cst;
            this.scb.addDep(AsmUtil.toBaseType(methodHandle.getOwner(), Optional.fromNullable(this.scb.getKlass().moduleName)));
        }
    }

    private void addDeps(Type t) {
        if (t instanceof RefType) {
            this.scb.addDep(t);
        } else if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            this.addDeps(at.getElementType());
        }
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        super.visitTryCatchBlock(start, end, handler, type);
        if (type != null) {
            this.scb.addDep(AsmUtil.toQualifiedName(type));
        }
    }

    @Override
    public void visitEnd() {
        VisibilityParameterAnnotationTag tag;
        super.visitEnd();
        if (this.visibleParamAnnotations != null) {
            tag = new VisibilityParameterAnnotationTag(this.visibleParamAnnotations.length, 0);
            for (VisibilityAnnotationTag visibilityAnnotationTag : this.visibleParamAnnotations) {
                tag.addVisibilityAnnotation(visibilityAnnotationTag);
            }
            this.method.addTag(tag);
        }
        if (this.invisibleParamAnnotations != null) {
            tag = new VisibilityParameterAnnotationTag(this.invisibleParamAnnotations.length, 1);
            for (VisibilityAnnotationTag visibilityAnnotationTag : this.invisibleParamAnnotations) {
                tag.addVisibilityAnnotation(visibilityAnnotationTag);
            }
            this.method.addTag(tag);
        }
        if (this.visibleLocalVarAnnotations != null) {
            tag = new VisibilityLocalVariableAnnotationTag(this.visibleLocalVarAnnotations.size(), 0);
            for (VisibilityAnnotationTag vat : this.visibleLocalVarAnnotations) {
                tag.addVisibilityAnnotation(vat);
            }
            this.method.addTag(tag);
        }
        if (this.invisibleLocalVarAnnotations != null) {
            tag = new VisibilityLocalVariableAnnotationTag(this.invisibleLocalVarAnnotations.size(), 1);
            for (VisibilityAnnotationTag vat : this.invisibleLocalVarAnnotations) {
                tag.addVisibilityAnnotation(vat);
            }
            this.method.addTag(tag);
        }
        if (!this.isFullyEmpty(this.parameterNames)) {
            this.method.addTag(new ParamNamesTag(this.parameterNames));
        }
        if (this.method.isConcrete()) {
            this.method.setSource(this.createAsmMethodSource(this.maxLocals, this.instructions, this.localVariables, this.tryCatchBlocks, this.scb.getKlass().moduleName));
        }
    }

    protected MethodSource createAsmMethodSource(int maxLocals, InsnList instructions, List<LocalVariableNode> localVariables, List<TryCatchBlockNode> tryCatchBlocks, String moduleName) {
        return new AsmMethodSource(maxLocals, instructions, localVariables, tryCatchBlocks, moduleName);
    }

    private boolean isFullyEmpty(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null || array[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.method.toString();
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        String bsmClsName = AsmUtil.toQualifiedName(bootstrapMethodHandle.getOwner());
        this.scb.addDep(RefType.v(bsmClsName));
        for (Object arg : bootstrapMethodArguments) {
            if (!(arg instanceof Handle)) continue;
            Handle argHandle = (Handle)arg;
            String handleClsName = AsmUtil.toQualifiedName(argHandle.getOwner());
            this.scb.addDep(RefType.v(handleClsName));
        }
    }
}

