/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import java.util.Iterator;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.UnitPrinter;
import soot.Value;
import soot.VoidType;
import soot.baf.DynamicInvokeInst;
import soot.baf.InstSwitch;
import soot.baf.internal.AbstractInvokeInst;
import soot.util.Switch;

public class BDynamicInvokeInst
extends AbstractInvokeInst
implements DynamicInvokeInst {
    protected final SootMethodRef bsmRef;
    private final List<Value> bsmArgs;
    protected int tag;

    public BDynamicInvokeInst(SootMethodRef bsmMethodRef, List<Value> bsmArgs, SootMethodRef methodRef, int tag) {
        this.methodRef = methodRef;
        this.bsmRef = bsmMethodRef;
        this.bsmArgs = bsmArgs;
        this.tag = tag;
    }

    @Override
    public Object clone() {
        return new BDynamicInvokeInst(this.bsmRef, this.bsmArgs, this.methodRef, this.tag);
    }

    @Override
    public int getInCount() {
        return this.methodRef.getParameterTypes().size();
    }

    @Override
    public int getOutCount() {
        return this.methodRef.getReturnType() instanceof VoidType ? 0 : 1;
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        return this.bsmArgs;
    }

    @Override
    public String getName() {
        return "dynamicinvoke";
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseDynamicInvokeInst(this);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("dynamicinvoke \"");
        buffer.append(this.methodRef.getName());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.getParameterTypes(), this.methodRef.getReturnType()));
        buffer.append('>');
        buffer.append(this.bsmRef.getSignature());
        buffer.append('(');
        Iterator<Value> it = this.bsmArgs.iterator();
        while (it.hasNext()) {
            Value v = it.next();
            buffer.append(v.toString());
            if (!it.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.literal("dynamicinvoke \"");
        up.literal(this.methodRef.getName());
        up.literal("\" <");
        up.literal(SootMethod.getSubSignature("", this.methodRef.getParameterTypes(), this.methodRef.getReturnType()));
        up.literal("> ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        Iterator<Value> it = this.bsmArgs.iterator();
        while (it.hasNext()) {
            Value v = it.next();
            v.toString(up);
            if (!it.hasNext()) continue;
            up.literal(", ");
        }
        up.literal(")");
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

