/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.CompilationDeathException;
import soot.G;
import soot.Local;
import soot.Singletons;
import soot.SootMethod;
import soot.Type;
import soot.dava.DavaBody;
import soot.jimple.Jimple;
import soot.util.IterableSet;

public class Dava {
    private static final Logger logger = LoggerFactory.getLogger(Dava.class);
    private static final String LOG_TO_FILE = null;
    private static final PrintStream LOG_TO_SCREEN = null;
    private Writer iOut = null;
    private IterableSet currentPackageContext = null;
    private String currentPackage;

    public Dava(Singletons.Global g2) {
    }

    public static Dava v() {
        return G.v().soot_dava_Dava();
    }

    public void set_CurrentPackage(String cp) {
        this.currentPackage = cp;
    }

    public String get_CurrentPackage() {
        return this.currentPackage;
    }

    public void set_CurrentPackageContext(IterableSet cpc) {
        this.currentPackageContext = cpc;
    }

    public IterableSet get_CurrentPackageContext() {
        return this.currentPackageContext;
    }

    public DavaBody newBody(SootMethod m3) {
        return new DavaBody(m3);
    }

    public DavaBody newBody(Body b) {
        return new DavaBody(b);
    }

    public Local newLocal(String name, Type t) {
        return Jimple.v().newLocal(name, t);
    }

    public void log(String s2) {
        if (LOG_TO_SCREEN != null) {
            LOG_TO_SCREEN.println(s2);
            LOG_TO_SCREEN.flush();
        }
        if (LOG_TO_FILE != null) {
            if (this.iOut == null) {
                try {
                    this.iOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(LOG_TO_FILE), "US-ASCII"));
                }
                catch (FileNotFoundException fnfe) {
                    logger.debug("Unable to open " + LOG_TO_FILE);
                    logger.error(fnfe.getMessage(), fnfe);
                    throw new CompilationDeathException(0);
                }
                catch (UnsupportedEncodingException uee) {
                    logger.debug("This system doesn't support US-ASCII encoding!!");
                    logger.error(uee.getMessage(), uee);
                    throw new CompilationDeathException(0);
                }
            }
            try {
                this.iOut.write(s2);
                this.iOut.write("\n");
                this.iOut.flush();
            }
            catch (IOException ioe) {
                logger.debug("Unable to write to " + LOG_TO_FILE);
                logger.error(ioe.getMessage(), ioe);
                throw new CompilationDeathException(0);
            }
        }
    }
}

