/*
 * Decompiled with CFR 0.152.
 */
package soot.dava;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.LongType;
import soot.Modifier;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.UnitPatchingChain;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DavaUnitPrinter;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.renamer.RemoveFullyQualifiedName;
import soot.options.Options;
import soot.tagkit.AbstractHost;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.tagkit.Tag;
import soot.util.IterableSet;

public class DavaPrinter {
    public DavaPrinter(Singletons.Global g2) {
    }

    public static DavaPrinter v() {
        return G.v().soot_dava_DavaPrinter();
    }

    private void printStatementsInBody(Body body, PrintWriter out) {
        UnitPatchingChain units;
        if (Options.v().verbose()) {
            System.out.println("Printing " + body.getMethod().getName());
        }
        if ((units = body.getUnits()).size() != 1) {
            throw new RuntimeException("DavaBody AST doesn't have single root.");
        }
        DavaUnitPrinter up = new DavaUnitPrinter((DavaBody)body);
        ((ASTNode)units.getFirst()).toString(up);
        out.print(((Object)up).toString());
    }

    public void printTo(SootClass cl, PrintWriter out) {
        Iterator<AbstractHost> interfaceIt;
        String superClassName;
        IterableSet<Object> importList = new IterableSet<String>();
        String curPackage = cl.getJavaPackageName();
        if (!curPackage.isEmpty()) {
            out.println("package " + curPackage + ';');
            out.println();
        }
        if (cl.hasSuperclass()) {
            SootClass superClass = cl.getSuperclass();
            importList.add(superClass.toString());
        }
        for (SootClass sootClass : cl.getInterfaces()) {
            String string = sootClass.toString();
            if (importList.contains(string)) continue;
            importList.add(string);
        }
        Iterator<AbstractHost> methodIt = cl.methodIterator();
        while (methodIt.hasNext()) {
            String returnPackage;
            SootMethod sootMethod = methodIt.next();
            if (sootMethod.hasActiveBody()) {
                importList = importList.union(((DavaBody)sootMethod.getActiveBody()).getImportList());
            }
            for (SootClass sc : sootMethod.getExceptions()) {
                String thrownPackage = sc.toString();
                if (importList.contains(thrownPackage)) continue;
                importList.add(thrownPackage);
            }
            for (Type t2 : sootMethod.getParameterTypes()) {
                String paramPackage;
                if (!(t2 instanceof RefType) || importList.contains(paramPackage = ((RefType)t2).getSootClass().toString())) continue;
                importList.add(paramPackage);
            }
            Type type = sootMethod.getReturnType();
            if (!(type instanceof RefType) || importList.contains(returnPackage = ((RefType)type).getSootClass().toString())) continue;
            importList.add(returnPackage);
        }
        for (SootField sootField : cl.getFields()) {
            String fieldPackage;
            Type type;
            if (sootField.isPhantom() || !((type = sootField.getType()) instanceof RefType) || importList.contains(fieldPackage = ((RefType)type).getSootClass().toString())) continue;
            importList.add(fieldPackage);
        }
        ArrayList<String> toImport = new ArrayList<String>();
        for (String string : importList) {
            if (string.contains("java.lang")) {
                String tempClassName = RemoveFullyQualifiedName.getClassName(string);
                if (string.equals("java.lang." + tempClassName)) continue;
            }
            if (!curPackage.isEmpty() && string.contains(curPackage) || cl.toString().equals(string)) continue;
            toImport.add(string);
        }
        for (String string : toImport) {
            if (RemoveFullyQualifiedName.containsMultiple(toImport.iterator(), string, null)) {
                if (string.lastIndexOf(46) > -1) {
                    String string2 = string.substring(0, string.lastIndexOf(46));
                    out.println("import " + string2 + ".*;");
                    continue;
                }
                throw new DecompilationException("Cant find the DOT . for fullyqualified name");
            }
            if (string.lastIndexOf(46) == -1) continue;
            out.println("import " + string + ';');
        }
        out.println();
        Dava.v().set_CurrentPackageContext(importList);
        Dava.v().set_CurrentPackage(curPackage);
        String classPrefix = Modifier.toString(cl.getModifiers()).trim();
        if (!cl.isInterface()) {
            classPrefix = (classPrefix + " class").trim();
        }
        out.print(classPrefix + " " + cl.getShortJavaStyleName());
        if (cl.hasSuperclass() && !"java.lang.Object".equals(superClassName = cl.getSuperclass().getName())) {
            out.print(" extends " + RemoveFullyQualifiedName.getReducedName(importList, superClassName, cl.getType()));
        }
        if ((interfaceIt = cl.getInterfaces().iterator()).hasNext()) {
            if (cl.isInterface()) {
                out.print(" extends ");
            } else {
                out.print(" implements ");
            }
            out.print(interfaceIt.next().getName());
            while (interfaceIt.hasNext()) {
                out.print(", " + ((SootClass)interfaceIt.next()).getName());
            }
        }
        out.println();
        out.println("{");
        for (SootField f : cl.getFields()) {
            if (f.isPhantom()) continue;
            Type type = f.getType();
            String string = (Modifier.toString(f.getModifiers()) + " " + RemoveFullyQualifiedName.getReducedName(importList, type.toString(), type)).trim();
            String declaration = string.isEmpty() ? Scene.v().quotedNameOf(f.getName()) : string + " " + Scene.v().quotedNameOf(f.getName());
            if (f.isFinal() && f.isStatic()) {
                this.printTags(f, declaration, out);
                continue;
            }
            out.println("    " + declaration + ';');
        }
        Iterator<SootMethod> methodIt2 = cl.methodIterator();
        if (methodIt2.hasNext()) {
            if (cl.getMethodCount() != 0) {
                out.println();
            }
            do {
                SootMethod method;
                if ((method = methodIt2.next()).isPhantom()) continue;
                if (!Modifier.isAbstract(method.getModifiers()) && !Modifier.isNative(method.getModifiers())) {
                    if (!method.hasActiveBody()) {
                        throw new RuntimeException("method " + method.getName() + " has no active body!");
                    }
                    this.printTo(method.getActiveBody(), out);
                    if (!methodIt2.hasNext()) continue;
                    out.println();
                    continue;
                }
                out.print("    ");
                out.print(method.getDavaDeclaration());
                out.println(";");
                if (!methodIt2.hasNext()) continue;
                out.println();
            } while (methodIt2.hasNext());
        }
        if (G.v().SootClassNeedsDavaSuperHandlerClass.contains(cl)) {
            out.println("\n    private static class DavaSuperHandler{");
            out.println("         java.util.Vector myVector = new java.util.Vector();");
            out.println("\n         public Object get(int pos){");
            out.println("            return myVector.elementAt(pos);");
            out.println("         }");
            out.println("\n         public void store(Object obj){");
            out.println("            myVector.add(obj);");
            out.println("         }");
            out.println("    }");
        }
        out.println("}");
    }

    private void printTags(SootField f, String declaration, PrintWriter out) {
        Type fieldType = f.getType();
        if (fieldType instanceof DoubleType) {
            DoubleConstantValueTag t = (DoubleConstantValueTag)f.getTag("DoubleConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = " + t.getDoubleValue() + ';');
                return;
            }
        } else if (fieldType instanceof FloatType) {
            FloatConstantValueTag t = (FloatConstantValueTag)f.getTag("FloatConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = " + t.getFloatValue() + "f;");
                return;
            }
        } else if (fieldType instanceof LongType) {
            LongConstantValueTag t = (LongConstantValueTag)f.getTag("LongConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = " + t.getLongValue() + "l;");
                return;
            }
        } else if (fieldType instanceof CharType) {
            IntegerConstantValueTag t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = '" + (char)t.getIntValue() + "';");
                return;
            }
        } else if (fieldType instanceof BooleanType) {
            IntegerConstantValueTag t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + (t.getIntValue() == 0 ? " = false;" : " = true;"));
                return;
            }
        } else if (fieldType instanceof IntType || fieldType instanceof ByteType || fieldType instanceof ShortType) {
            IntegerConstantValueTag t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = " + t.getIntValue() + ';');
                return;
            }
        } else {
            StringConstantValueTag t = (StringConstantValueTag)f.getTag("StringConstantValueTag");
            if (t != null) {
                out.println("    " + declaration + " = \"" + t.getStringValue() + "\";");
                return;
            }
        }
        out.println("    " + declaration + ';');
    }

    private void printTo(Body b, PrintWriter out) {
        b.validate();
        out.println("    " + b.getMethod().getDavaDeclaration());
        if (Options.v().print_tags_in_output()) {
            for (Tag t : b.getMethod().getTags()) {
                out.println(t);
            }
        }
        out.println("    {");
        this.printStatementsInBody(b, out);
        out.println("    }");
    }
}

