/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.interProcedural;

import java.util.HashMap;
import java.util.Iterator;
import soot.PhaseOptions;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.dava.DavaBody;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.toolkits.base.AST.interProcedural.ConstantFieldValueFinder;
import soot.dava.toolkits.base.AST.transformations.CPApplication;
import soot.dava.toolkits.base.AST.transformations.EliminateConditions;
import soot.dava.toolkits.base.AST.transformations.LocalVariableCleaner;
import soot.dava.toolkits.base.AST.transformations.SimplifyConditions;
import soot.dava.toolkits.base.AST.transformations.SimplifyExpressions;
import soot.dava.toolkits.base.AST.transformations.UnreachableCodeEliminator;
import soot.dava.toolkits.base.AST.transformations.UselessLabelFinder;
import soot.dava.toolkits.base.AST.transformations.VoidReturnRemover;
import soot.dava.toolkits.base.renamer.Renamer;
import soot.dava.toolkits.base.renamer.infoGatheringAnalysis;
import soot.util.Chain;

public class InterProceduralAnalyses {
    public static boolean DEBUG = false;

    public static void applyInterProceduralAnalyses() {
        Chain<SootClass> classes = Scene.v().getApplicationClasses();
        if (DEBUG) {
            System.out.println("\n\nInvoking redundantFielduseEliminator");
        }
        ConstantFieldValueFinder finder = new ConstantFieldValueFinder(classes);
        HashMap<String, Object> constantValueFields = finder.getFieldsWithConstantValues();
        if (DEBUG) {
            finder.printConstantValueFields();
        }
        for (SootClass s2 : classes) {
            Iterator<SootMethod> methodIt = s2.methodIterator();
            while (methodIt.hasNext()) {
                DavaBody body;
                ASTNode AST;
                SootMethod m3 = methodIt.next();
                if (!m3.hasActiveBody() || !((AST = (ASTNode)(body = (DavaBody)m3.getActiveBody()).getUnits().getFirst()) instanceof ASTMethodNode)) continue;
                boolean deobfuscate = PhaseOptions.getBoolean(PhaseOptions.v().getPhaseOptions("db.deobfuscate"), "enabled");
                if (deobfuscate) {
                    if (DEBUG) {
                        System.out.println("\nSTART CP Class:" + s2.getName() + " Method: " + m3.getName());
                    }
                    AST.apply(new CPApplication((ASTMethodNode)AST, constantValueFields, finder.getClassNameFieldNameToSootFieldMapping()));
                    if (DEBUG) {
                        System.out.println("DONE CP for " + m3.getName());
                    }
                }
                AST.apply(new SimplifyExpressions());
                AST.apply(new SimplifyConditions());
                AST.apply(new EliminateConditions((ASTMethodNode)AST));
                AST.apply(new UnreachableCodeEliminator(AST));
                AST.apply(new LocalVariableCleaner(AST));
                if (deobfuscate) {
                    if (DEBUG) {
                        System.out.println("reinvoking analyzeAST");
                    }
                    UselessLabelFinder.DEBUG = false;
                    body.analyzeAST();
                }
                if (PhaseOptions.getBoolean(PhaseOptions.v().getPhaseOptions("db.renamer"), "enabled")) {
                    InterProceduralAnalyses.applyRenamerAnalyses(AST, body);
                }
                VoidReturnRemover.cleanClass(s2);
            }
        }
    }

    private static void applyRenamerAnalyses(ASTNode AST, DavaBody body) {
        infoGatheringAnalysis info = new infoGatheringAnalysis(body);
        AST.apply(info);
        Renamer renamer = new Renamer(info.getHeuristicSet(), (ASTMethodNode)AST);
        renamer.rename();
    }

    private InterProceduralAnalyses() {
    }
}

