/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import soot.BooleanType;
import soot.Type;
import soot.Value;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.internal.javaRep.DNotExpr;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.jimple.ConditionExpr;
import soot.jimple.EqExpr;
import soot.jimple.NeExpr;

public class BooleanConditionSimplification
extends DepthFirstAdapter {
    public BooleanConditionSimplification(boolean verbose) {
        super(verbose);
    }

    @Override
    public void caseASTStatementSequenceNode(ASTStatementSequenceNode node) {
    }

    public BooleanConditionSimplification() {
    }

    @Override
    public void outASTIfNode(ASTIfNode node) {
        ConditionExpr condExpr;
        Value unary;
        ASTCondition condition = node.get_Condition();
        if (condition instanceof ASTBinaryCondition && (unary = this.checkBooleanUse(condExpr = ((ASTBinaryCondition)condition).getConditionExpr())) != null) {
            node.set_Condition(new ASTUnaryCondition(unary));
        }
    }

    @Override
    public void outASTIfElseNode(ASTIfElseNode node) {
        ConditionExpr condExpr;
        Value unary;
        ASTCondition condition = node.get_Condition();
        if (condition instanceof ASTBinaryCondition && (unary = this.checkBooleanUse(condExpr = ((ASTBinaryCondition)condition).getConditionExpr())) != null) {
            node.set_Condition(new ASTUnaryCondition(unary));
        }
    }

    @Override
    public void outASTWhileNode(ASTWhileNode node) {
        ConditionExpr condExpr;
        Value unary;
        ASTCondition condition = node.get_Condition();
        if (condition instanceof ASTBinaryCondition && (unary = this.checkBooleanUse(condExpr = ((ASTBinaryCondition)condition).getConditionExpr())) != null) {
            node.set_Condition(new ASTUnaryCondition(unary));
        }
    }

    @Override
    public void outASTDoWhileNode(ASTDoWhileNode node) {
        ConditionExpr condExpr;
        Value unary;
        ASTCondition condition = node.get_Condition();
        if (condition instanceof ASTBinaryCondition && (unary = this.checkBooleanUse(condExpr = ((ASTBinaryCondition)condition).getConditionExpr())) != null) {
            node.set_Condition(new ASTUnaryCondition(unary));
        }
    }

    private Value checkBooleanUse(ConditionExpr condition) {
        if (condition instanceof NeExpr || condition instanceof EqExpr) {
            Value op1 = condition.getOp1();
            Value op2 = condition.getOp2();
            if (op1 instanceof DIntConstant) {
                Type op1Type = ((DIntConstant)op1).type;
                if (op1Type instanceof BooleanType) {
                    return this.decideCondition(op2, ((DIntConstant)op1).toString(), condition);
                }
            } else if (op2 instanceof DIntConstant) {
                Type op2Type = ((DIntConstant)op2).type;
                if (op2Type instanceof BooleanType) {
                    return this.decideCondition(op1, ((DIntConstant)op2).toString(), condition);
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private Value decideCondition(Value A2, String truthString, ConditionExpr condition) {
        boolean truthValue = false;
        boolean notEqual = false;
        if (truthString.compareTo("false") == 0) {
            truthValue = false;
        } else if (truthString.compareTo("true") == 0) {
            truthValue = true;
        } else {
            throw new RuntimeException();
        }
        if (condition instanceof NeExpr) {
            notEqual = true;
        } else if (condition instanceof EqExpr) {
            notEqual = false;
        } else {
            throw new RuntimeException();
        }
        if (notEqual && !truthValue) {
            return A2;
        }
        if (notEqual && truthValue) {
            if (A2 instanceof DNotExpr) {
                return ((DNotExpr)A2).getOp();
            }
            return new DNotExpr(A2);
        }
        if (!notEqual && !truthValue) {
            if (A2 instanceof DNotExpr) {
                return ((DNotExpr)A2).getOp();
            }
            return new DNotExpr(A2);
        }
        if (!notEqual && truthValue) {
            return A2;
        }
        throw new RuntimeException();
    }
}

