/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.dotnet.members.DotnetEvent;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoDotnetNativeHost;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.options.Options;
import soot.toolkits.scalar.Pair;

public class AssemblyFile
extends File {
    private static final Logger logger = LoggerFactory.getLogger(AssemblyFile.class);
    private final String fullyQualifiedAssemblyPathFilename;
    private ProtoAssemblyAllTypes.AssemblyAllTypes protoAllTypes;
    private final String pathNativeHost;
    private boolean gotAllReferencesModuleTypes = false;

    public AssemblyFile(String fullyQualifiedAssemblyPathFilename) {
        super(fullyQualifiedAssemblyPathFilename);
        this.fullyQualifiedAssemblyPathFilename = fullyQualifiedAssemblyPathFilename;
        this.pathNativeHost = Options.v().dotnet_nativehost_path();
        System.load(this.pathNativeHost);
    }

    public ProtoAssemblyAllTypes.AssemblyAllTypes getAllTypes() {
        if (this.protoAllTypes != null) {
            return this.protoAllTypes;
        }
        try {
            ProtoAssemblyAllTypes.AssemblyAllTypes a;
            ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder("", ProtoDotnetNativeHost.AnalyzerMethodCall.GET_ALL_TYPES);
            ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
            byte[] protobufMessageBytes = this.nativeGetAllTypesMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            this.protoAllTypes = a = ProtoAssemblyAllTypes.AssemblyAllTypes.parseFrom(protobufMessageBytes);
            return a;
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn(this.getAssemblyFileName() + " has no types. Error of protobuf message: " + e.getMessage());
            }
            return null;
        }
    }

    public ProtoIlInstructions.IlFunctionMsg getMethodBody(String className, String method, int peToken) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY);
        Pair<String, String> methodNameSuffixPair = this.helperExtractMethodNameSuffix(method);
        analyzerParamsBuilder.setMethodName(methodNameSuffixPair.getO1());
        analyzerParamsBuilder.setMethodNameSuffix(methodNameSuffixPair.getO2());
        analyzerParamsBuilder.setMethodPeToken(peToken);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes = this.nativeGetMethodBodyMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of method " + className + "." + method + ": " + e.getMessage());
            }
            return null;
        }
    }

    private Pair<String, String> helperExtractMethodNameSuffix(String sootMethodName) {
        if (!sootMethodName.contains("[[") || !sootMethodName.contains("]]")) {
            return new Pair<String, String>(sootMethodName, "");
        }
        int startSuffix = sootMethodName.indexOf("[[");
        String suffix = sootMethodName.substring(startSuffix);
        String cilMethodName = sootMethodName.substring(0, startSuffix);
        return new Pair<String, String>(cilMethodName, suffix);
    }

    public ProtoIlInstructions.IlFunctionMsg getMethodBodyOfProperty(String className, String propertyName, boolean isSetter) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY_OF_PROPERTY);
        analyzerParamsBuilder.setPropertyName(propertyName);
        analyzerParamsBuilder.setPropertyIsSetter(isSetter);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes = this.nativeGetMethodBodyOfPropertyMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of property " + className + "." + propertyName + ": " + e.getMessage());
                logger.warn("Return null");
            }
            return null;
        }
    }

    public ProtoIlInstructions.IlFunctionMsg getMethodBodyOfEvent(String className, String eventName, DotnetEvent.EventDirective eventDirective) {
        ProtoDotnetNativeHost.EventAccessorType accessorType;
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = this.createAnalyzerParamsBuilder(className, ProtoDotnetNativeHost.AnalyzerMethodCall.GET_METHOD_BODY_OF_EVENT);
        analyzerParamsBuilder.setEventName(eventName);
        switch (eventDirective) {
            case ADD: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.ADD_ACCESSOR;
                break;
            }
            case REMOVE: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.REMOVE_ACCESSOR;
                break;
            }
            case INVOKE: {
                accessorType = ProtoDotnetNativeHost.EventAccessorType.INVOKE_ACCESSOR;
                break;
            }
            default: {
                throw new RuntimeException("Wrong Event Accessor Type!");
            }
        }
        analyzerParamsBuilder.setEventAccessorType(accessorType);
        ProtoDotnetNativeHost.AnalyzerParamsMsg analyzerParamsMsg = analyzerParamsBuilder.build();
        try {
            byte[] protoMsgBytes = this.nativeGetMethodBodyOfEventMsg(this.pathNativeHost, analyzerParamsMsg.toByteArray());
            return ProtoIlInstructions.IlFunctionMsg.parseFrom(protoMsgBytes);
        }
        catch (Exception e) {
            if (Options.v().verbose()) {
                logger.warn("Exception while getting method body of event " + className + "." + eventName + ": " + e.getMessage());
            }
            return null;
        }
    }

    public boolean isAssembly() {
        return this.nativeIsAssembly(this.pathNativeHost, this.fullyQualifiedAssemblyPathFilename);
    }

    public ProtoAssemblyAllTypes.TypeDefinition getTypeDefinition(String className) {
        if (Strings.isNullOrEmpty(className)) {
            return null;
        }
        ProtoAssemblyAllTypes.AssemblyAllTypes allTypes = this.getAllTypes();
        if (allTypes == null) {
            return null;
        }
        List<ProtoAssemblyAllTypes.TypeDefinition> allTypesList = allTypes.getListOfTypesList();
        Optional<ProtoAssemblyAllTypes.TypeDefinition> c = allTypesList.stream().filter(x -> x.getFullname().equals(className)).findFirst();
        return c.orElse(null);
    }

    public List<String> getAllTypeNames() {
        ProtoAssemblyAllTypes.AssemblyAllTypes allTypes = this.getAllTypes();
        if (allTypes == null) {
            return null;
        }
        List<ProtoAssemblyAllTypes.TypeDefinition> listOfTypesList = allTypes.getListOfTypesList();
        return listOfTypesList.stream().map(ProtoAssemblyAllTypes.TypeDefinition::getFullname).collect(Collectors.toList());
    }

    public List<String> getAllReferencedModuleTypes() {
        ProtoAssemblyAllTypes.AssemblyAllTypes allTypes = this.getAllTypes();
        if (allTypes == null || this.gotAllReferencesModuleTypes) {
            return new ArrayList<String>();
        }
        this.gotAllReferencesModuleTypes = true;
        return allTypes.getAllReferencedModuleTypesList();
    }

    private ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder createAnalyzerParamsBuilder(String className, ProtoDotnetNativeHost.AnalyzerMethodCall methodCall) {
        ProtoDotnetNativeHost.AnalyzerParamsMsg.Builder analyzerParamsBuilder = ProtoDotnetNativeHost.AnalyzerParamsMsg.newBuilder();
        analyzerParamsBuilder.setAnalyzerMethodCall(methodCall);
        analyzerParamsBuilder.setAssemblyFileAbsolutePath(this.fullyQualifiedAssemblyPathFilename);
        analyzerParamsBuilder.setTypeReflectionName(className);
        if (Options.v().verbose() || Options.v().debug()) {
            analyzerParamsBuilder.setDebugMode(true);
        }
        return analyzerParamsBuilder;
    }

    public String getFullPath() {
        return FilenameUtils.getFullPath(this.fullyQualifiedAssemblyPathFilename);
    }

    public String getAssemblyFileName() {
        return FilenameUtils.getName(this.fullyQualifiedAssemblyPathFilename);
    }

    private native byte[] nativeGetAllTypesMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyOfPropertyMsg(String var1, byte[] var2);

    private native byte[] nativeGetMethodBodyOfEventMsg(String var1, byte[] var2);

    private native byte[] nativeGetAssemblyContentMsg(String var1, byte[] var2);

    private native boolean nativeIsAssembly(String var1, String var2);
}

