/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ClassProvider;
import soot.ClassSource;
import soot.SourceLocator;
import soot.dotnet.AssemblyFile;
import soot.dotnet.DotnetClassSource;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.options.Options;

public class DotnetClassProvider
implements ClassProvider {
    private static final Logger logger = LoggerFactory.getLogger(DotnetClassProvider.class);

    @Override
    public ClassSource find(String className) {
        this.ensureAssemblyIndex();
        if (className.equals("Fake.LdFtn")) {
            return new DotnetClassSource(className, null);
        }
        File assemblyFile = SourceLocator.v().dexClassIndex().get(className);
        return assemblyFile == null ? null : new DotnetClassSource(className, assemblyFile);
    }

    private void ensureAssemblyIndex() {
        Map<String, File> index = SourceLocator.v().dexClassIndex();
        if (index == null) {
            if (Options.v().verbose()) {
                logger.info("Creating assembly index");
            }
            index = new HashMap<String, File>();
            this.buildAssemblyIndex(index, SourceLocator.v().classPath());
            SourceLocator.v().setDexClassIndex(index);
            if (Options.v().verbose()) {
                logger.info("Created assembly index");
            }
        }
        if (SourceLocator.v().getDexClassPathExtensions() != null) {
            if (Options.v().verbose()) {
                logger.info("Process classpath extensions");
            }
            this.buildAssemblyIndex(index, new ArrayList<String>(SourceLocator.v().getDexClassPathExtensions()));
            SourceLocator.v().clearDexClassPathExtensions();
        }
    }

    private void buildAssemblyIndex(Map<String, File> index, List<String> classPath) {
        if (Strings.isNullOrEmpty(Options.v().dotnet_nativehost_path())) {
            throw new RuntimeException("Dotnet NativeHost Path is not set! Use -dotnet-nativehost-path Soot parameter!");
        }
        for (String path : classPath) {
            try {
                File[] fileArray;
                File file = new File(path);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    fileArray = file.listFiles(File::isFile);
                } else {
                    File[] fileArray2 = new File[1];
                    fileArray = fileArray2;
                    fileArray2[0] = file;
                }
                File[] listFiles = fileArray;
                for (File f : Objects.requireNonNull(listFiles)) {
                    ProtoAssemblyAllTypes.AssemblyAllTypes assemblyDefinition;
                    AssemblyFile assemblyFile;
                    if (Options.v().verbose()) {
                        logger.info("Process " + f.getCanonicalPath() + " file");
                    }
                    if (!f.getCanonicalPath().endsWith(".exe") && !f.getCanonicalPath().endsWith(".dll") || !(assemblyFile = new AssemblyFile(f.getCanonicalPath())).isAssembly() || (assemblyDefinition = assemblyFile.getAllTypes()) == null) continue;
                    if (!index.containsKey(f.getCanonicalPath())) {
                        index.put(f.getCanonicalPath(), assemblyFile);
                    }
                    List<ProtoAssemblyAllTypes.TypeDefinition> allTypesOfMainModule = assemblyDefinition.getListOfTypesList();
                    for (ProtoAssemblyAllTypes.TypeDefinition type : allTypesOfMainModule) {
                        String typeName = type.getFullname();
                        if (Options.v().verbose()) {
                            logger.info("Add class " + typeName + " to index");
                        }
                        if (!index.containsKey(typeName)) {
                            index.put(typeName, assemblyFile);
                            continue;
                        }
                        if (!Options.v().verbose()) continue;
                        logger.debug("" + String.format("Warning: Duplicate of class '%s' found in assembly file '%s' from source '%s'. Omitting class.", type, assemblyFile.getAssemblyFileName(), assemblyFile.getFullPath()));
                    }
                }
            }
            catch (Exception e) {
                logger.warn("exception while processing assembly file '" + path + "'");
                logger.warn("Exception: " + e);
            }
        }
    }
}

