/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.instructions;

import soot.Body;
import soot.Value;
import soot.dotnet.exceptions.NoStatementInstructionException;
import soot.dotnet.instructions.AbstractCilnstruction;
import soot.dotnet.instructions.CilBlock;
import soot.dotnet.instructions.CilInstructionFactory;
import soot.dotnet.members.method.DotnetBody;
import soot.dotnet.proto.ProtoIlInstructions;
import soot.jimple.Jimple;

public class CilBinaryNumericInstruction
extends AbstractCilnstruction {
    public CilBinaryNumericInstruction(ProtoIlInstructions.IlInstructionMsg instruction, DotnetBody dotnetBody, CilBlock cilBlock) {
        super(instruction, dotnetBody, cilBlock);
    }

    @Override
    public void jimplify(Body jb) {
        throw new NoStatementInstructionException(this.instruction);
    }

    @Override
    public Value jimplifyExpr(Body jb) {
        Value left = CilInstructionFactory.fromInstructionMsg(this.instruction.getLeft(), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        left = DotnetBody.inlineCastExpr(left);
        Value right = CilInstructionFactory.fromInstructionMsg(this.instruction.getRight(), this.dotnetBody, this.cilBlock).jimplifyExpr(jb);
        right = DotnetBody.inlineCastExpr(right);
        switch (this.instruction.getOperator()) {
            case Add: {
                return Jimple.v().newAddExpr(left, right);
            }
            case Sub: {
                return Jimple.v().newSubExpr(left, right);
            }
            case Mul: {
                return Jimple.v().newMulExpr(left, right);
            }
            case Div: {
                return Jimple.v().newDivExpr(left, right);
            }
            case Rem: {
                return Jimple.v().newRemExpr(left, right);
            }
            case BitAnd: {
                return Jimple.v().newAndExpr(left, right);
            }
            case BitOr: {
                return Jimple.v().newOrExpr(left, right);
            }
            case BitXor: {
                return Jimple.v().newXorExpr(left, right);
            }
            case ShiftLeft: {
                return Jimple.v().newShlExpr(left, right);
            }
            case ShiftRight: {
                if (this.instruction.getSign().equals(ProtoIlInstructions.IlInstructionMsg.IlSign.Signed)) {
                    return Jimple.v().newShrExpr(left, right);
                }
                return Jimple.v().newUshrExpr(left, right);
            }
        }
        return null;
    }
}

