/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.members;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.MethodSource;
import soot.SootClass;
import soot.SootMethod;
import soot.SourceLocator;
import soot.dotnet.AssemblyFile;
import soot.dotnet.members.AbstractDotnetMember;
import soot.dotnet.members.DotnetMethod;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.proto.ProtoIlInstructions;

public class DotnetEvent
extends AbstractDotnetMember {
    private static final Logger logger = LoggerFactory.getLogger(DotnetEvent.class);
    private final SootClass declaringClass;
    private final ProtoAssemblyAllTypes.EventDefinition protoEvent;
    private DotnetMethod addAccessorMethod;
    private DotnetMethod invokeAccessorMethod;
    private DotnetMethod removeAccessorMethod;

    public DotnetEvent(ProtoAssemblyAllTypes.EventDefinition protoEvent, SootClass declaringClass) {
        this.protoEvent = protoEvent;
        this.declaringClass = declaringClass;
        this.initDotnetMethods();
    }

    private void initDotnetMethods() {
        if (this.getCanAdd() && this.protoEvent.hasAddAccessorMethod()) {
            this.addAccessorMethod = new DotnetMethod(this.protoEvent.getAddAccessorMethod(), this.declaringClass, DotnetMethod.DotnetMethodType.EVENT);
        }
        if (this.getCanInvoke() && this.protoEvent.hasInvokeAccessorMethod()) {
            this.invokeAccessorMethod = new DotnetMethod(this.protoEvent.getInvokeAccessorMethod(), this.declaringClass, DotnetMethod.DotnetMethodType.EVENT);
        }
        if (this.getCanRemove() && this.protoEvent.hasRemoveAccessorMethod()) {
            this.removeAccessorMethod = new DotnetMethod(this.protoEvent.getRemoveAccessorMethod(), this.declaringClass, DotnetMethod.DotnetMethodType.EVENT);
        }
    }

    public boolean getCanAdd() {
        return this.protoEvent.getCanAdd();
    }

    public boolean getCanInvoke() {
        return this.protoEvent.getCanInvoke();
    }

    public boolean getCanRemove() {
        return this.protoEvent.getCanRemove();
    }

    public SootMethod makeSootMethodAdd() {
        if (!this.getCanAdd() || !this.protoEvent.hasAddAccessorMethod()) {
            return null;
        }
        return this.addAccessorMethod.toSootMethod(this.createMethodSource(EventDirective.ADD));
    }

    public SootMethod makeSootMethodInvoke() {
        if (!this.getCanInvoke() || !this.protoEvent.hasInvokeAccessorMethod()) {
            return null;
        }
        return this.invokeAccessorMethod.toSootMethod(this.createMethodSource(EventDirective.INVOKE));
    }

    public SootMethod makeSootMethodRemove() {
        if (!this.getCanRemove() || !this.protoEvent.hasRemoveAccessorMethod()) {
            return null;
        }
        return this.removeAccessorMethod.toSootMethod(this.createMethodSource(EventDirective.REMOVE));
    }

    private MethodSource createMethodSource(EventDirective eventMethodType) {
        return (m3, phaseName) -> {
            DotnetMethod dotnetMethod;
            AssemblyFile assemblyFile = (AssemblyFile)SourceLocator.v().dexClassIndex().get(this.declaringClass.getName());
            ProtoIlInstructions.IlFunctionMsg ilFunctionMsg = assemblyFile.getMethodBodyOfEvent(this.declaringClass.getName(), this.protoEvent.getName(), eventMethodType);
            switch (eventMethodType) {
                case ADD: {
                    dotnetMethod = this.addAccessorMethod;
                    break;
                }
                case REMOVE: {
                    dotnetMethod = this.removeAccessorMethod;
                    break;
                }
                case INVOKE: {
                    dotnetMethod = this.invokeAccessorMethod;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected selection of event method type!");
                }
            }
            Body b = dotnetMethod.jimplifyMethodBody(ilFunctionMsg);
            m3.setActiveBody(b);
            return m3.getActiveBody();
        };
    }

    public static enum EventDirective {
        ADD,
        REMOVE,
        INVOKE;

    }
}

