/*
 * Decompiled with CFR 0.152.
 */
package soot.dotnet.specifications;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.dotnet.proto.ProtoAssemblyAllTypes;
import soot.dotnet.types.DotnetType;
import soot.tagkit.AnnotationArrayElem;
import soot.tagkit.AnnotationBooleanElem;
import soot.tagkit.AnnotationClassElem;
import soot.tagkit.AnnotationDoubleElem;
import soot.tagkit.AnnotationElem;
import soot.tagkit.AnnotationEnumElem;
import soot.tagkit.AnnotationFloatElem;
import soot.tagkit.AnnotationIntElem;
import soot.tagkit.AnnotationLongElem;
import soot.tagkit.AnnotationStringElem;

public class DotnetAttributeArgument {
    private static final Logger logger = LoggerFactory.getLogger(DotnetType.class);

    public static AnnotationElem toAnnotationElem(ProtoAssemblyAllTypes.AttributeArgumentDefinition arg) {
        if (arg.getType().getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.ENUM)) {
            return new AnnotationEnumElem(arg.getType().getFullname(), arg.getValueString(0), arg.getName());
        }
        if (arg.getType().getTypeKind().equals(ProtoAssemblyAllTypes.TypeKindDef.ARRAY)) {
            ArrayList<AnnotationElem> arrElements = new ArrayList<AnnotationElem>();
            switch (arg.getType().getFullname()) {
                case "System.String": {
                    for (String v : arg.getValueStringList()) {
                        arrElements.add(new AnnotationStringElem(v, arg.getName()));
                    }
                    break;
                }
                case "System.Int32": 
                case "System.UInt32": {
                    for (int v : arg.getValueInt32List()) {
                        arrElements.add(new AnnotationIntElem(v, arg.getName()));
                    }
                    break;
                }
                case "System.Single": {
                    for (float v : arg.getValueFloatList()) {
                        arrElements.add(new AnnotationFloatElem(v, arg.getName()));
                    }
                    break;
                }
                case "System.Double": 
                case "System.Decimal": {
                    for (double v : arg.getValueDoubleList()) {
                        arrElements.add(new AnnotationDoubleElem(v, arg.getName()));
                    }
                    break;
                }
                case "System.Boolean": {
                    for (int v : arg.getValueInt32List()) {
                        arrElements.add(new AnnotationBooleanElem(v == 1, arg.getName()));
                    }
                    break;
                }
                case "System.Int64": 
                case "System.UInt64": {
                    for (long v : arg.getValueInt64List()) {
                        arrElements.add(new AnnotationLongElem(v, arg.getName()));
                    }
                    break;
                }
                case "System.Byte": 
                case "System.SByte": {
                    for (int v : arg.getValueInt32List()) {
                        arrElements.add(new AnnotationIntElem((Byte)Integer.valueOf(v).byteValue(), arg.getName()));
                    }
                    break;
                }
                case "System.Char": {
                    for (int v : arg.getValueInt32List()) {
                        arrElements.add(new AnnotationIntElem(Character.valueOf((char)v), arg.getName()));
                    }
                    break;
                }
                case "System.Int16": 
                case "System.UInt16": {
                    for (int v : arg.getValueInt32List()) {
                        arrElements.add(new AnnotationIntElem((Short)((short)v), arg.getName()));
                    }
                    break;
                }
                default: {
                    logger.warn("No implemented type for array annotation element, type: " + arg.getType().getFullname());
                }
            }
            return new AnnotationArrayElem(arrElements, arg.getName());
        }
        switch (arg.getType().getFullname()) {
            case "System.String": {
                return new AnnotationStringElem(arg.getValueString(0), arg.getName());
            }
            case "System.Int32": {
                return new AnnotationIntElem(arg.getValueInt32(0), arg.getName());
            }
            case "System.Single": {
                return new AnnotationFloatElem(arg.getValueFloat(0), arg.getName());
            }
            case "System.Double": {
                return new AnnotationDoubleElem(arg.getValueDouble(0), arg.getName());
            }
            case "System.Boolean": {
                return new AnnotationBooleanElem(arg.getValueInt32(0) == 1, arg.getName());
            }
            case "System.Int64": {
                return new AnnotationLongElem(arg.getValueInt64(0), arg.getName());
            }
            case "System.Type": {
                return new AnnotationClassElem(arg.getType().getFullname(), arg.getName());
            }
            case "System.Byte": {
                return new AnnotationIntElem((Byte)Integer.valueOf(arg.getValueInt32(0)).byteValue(), arg.getName());
            }
            case "System.Char": {
                return new AnnotationIntElem(Character.valueOf((char)arg.getValueInt32(0)), arg.getName());
            }
            case "System.Int16": {
                return new AnnotationIntElem((Short)((short)arg.getValueInt32(0)), arg.getName());
            }
        }
        return new AnnotationClassElem(arg.getType().getFullname(), arg.getName());
    }
}

