/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import soot.Body;
import soot.BodyTransformer;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.baf.Baf;
import soot.baf.DupInst;
import soot.baf.FieldArgInst;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.IncInst;
import soot.baf.InstanceCastInst;
import soot.baf.InstanceOfInst;
import soot.baf.LoadInst;
import soot.baf.MethodArgInst;
import soot.baf.NewArrayInst;
import soot.baf.NewInst;
import soot.baf.NewMultiArrayInst;
import soot.baf.NoArgInst;
import soot.baf.OpTypeArgInst;
import soot.baf.PopInst;
import soot.baf.PrimitiveCastInst;
import soot.baf.PushInst;
import soot.baf.ReturnInst;
import soot.baf.SpecialInvokeInst;
import soot.baf.StoreInst;
import soot.baf.SwapInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.Rand;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.toolkits.graph.BriefUnitGraph;
import soot.util.Chain;

public class FindDuplicateSequences
extends BodyTransformer
implements IJbcoTransform {
    int[] totalcounts = new int[512];
    public static String[] dependancies = new String[]{"bb.jbco_j2bl", "bb.jbco_rds", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_rds";

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Duplicate Sequences:");
        for (int count = this.totalcounts.length - 1; count >= 0; --count) {
            if (this.totalcounts[count] <= 0) continue;
            out.println("\t" + count + " total: " + this.totalcounts[count]);
        }
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        if (output) {
            out.println("Checking " + b.getMethod().getName() + " for duplicate sequences..");
        }
        ArrayList<Unit> illegalUnits = new ArrayList<Unit>();
        ArrayList<Unit> seenUnits = new ArrayList<Unit>();
        ArrayList<Unit> workList = new ArrayList<Unit>();
        UnitPatchingChain units = b.getUnits();
        BriefUnitGraph bug = new BriefUnitGraph(b);
        workList.addAll(bug.getHeads());
        while (workList.size() > 0) {
            Unit u = (Unit)workList.remove(0);
            if (seenUnits.contains(u)) continue;
            if (u instanceof NewInst) {
                RefType t = ((NewInst)u).getBaseType();
                ArrayList<Unit> tmpWorkList = new ArrayList<Unit>();
                tmpWorkList.add(u);
                while (tmpWorkList.size() > 0) {
                    Unit v = (Unit)tmpWorkList.remove(0);
                    if (v instanceof SpecialInvokeInst) {
                        SpecialInvokeInst si = (SpecialInvokeInst)v;
                        if (si.getMethodRef().getSignature().indexOf("void <init>") < 0 || si.getMethodRef().declaringClass() != t.getSootClass()) {
                            tmpWorkList.addAll(bug.getSuccsOf(v));
                        }
                    } else {
                        tmpWorkList.addAll(bug.getSuccsOf(v));
                    }
                    illegalUnits.add(v);
                }
            }
            seenUnits.add(u);
            workList.addAll(bug.getSuccsOf(u));
        }
        seenUnits = null;
        int controlLocalIndex = 0;
        int longestSeq = units.size() / 2 - 1;
        if (longestSeq > 20) {
            longestSeq = 20;
        }
        Local controlLocal = null;
        Chain<Local> bLocals = b.getLocals();
        int[] counts = new int[longestSeq + 1];
        Map<Local, Local> bafToJLocals = Main.methods2Baf2JLocals.get(b.getMethod());
        boolean changed = true;
        Map<Unit, Stack<Type>> stackHeightsBefore = null;
        for (int count = longestSeq; count > 2; --count) {
            int found;
            Object[] uArry = units.toArray(new Unit[units.size()]);
            if (uArry.length <= 0) {
                return;
            }
            ArrayList candidates = new ArrayList();
            ArrayList<Unit> unitIDs = new ArrayList<Unit>();
            if (changed) {
                stackHeightsBefore = StackTypeHeightCalculator.calculateStackHeights(b, bafToJLocals);
                bug = StackTypeHeightCalculator.bug;
                changed = false;
            }
            block3: for (int i = 0; i < uArry.length; ++i) {
                Unit u;
                unitIDs.add(uArry[i]);
                if (i + count > uArry.length) continue;
                ArrayList<Unit> seq = new ArrayList<Unit>();
                for (int j = 0; !(j >= count || (u = uArry[i + j]) instanceof IdentityInst || u instanceof ReturnInst || illegalUnits.contains(u)); ++j) {
                    List<Unit> preds;
                    if (j > 0 && (preds = bug.getPredsOf(u)).size() > 0) {
                        found = 0;
                        block5: for (Unit p : preds) {
                            for (int jj = 0; jj < count; ++jj) {
                                if (p != uArry[i + jj]) continue;
                                ++found;
                                continue block5;
                            }
                        }
                        if (found < preds.size()) continue block3;
                    }
                    seq.add(u);
                }
                if (seq.size() != count || !((Unit)seq.get(seq.size() - 1)).fallsThrough()) continue;
                candidates.add(seq);
            }
            HashMap<List, List<List<Unit>>> selected = new HashMap<List, List<List<Unit>>>();
            for (int i = 0; i < candidates.size(); ++i) {
                List seq = (List)candidates.get(i);
                List<List<Unit>> matches = new ArrayList<List<Unit>>();
                for (int j = 0; j < uArry.length - count; ++j) {
                    if (this.overlap(uArry, seq, j, count)) continue;
                    found = 0;
                    for (int k = 0; k < count; ++k) {
                        List<Unit> preds;
                        Unit u = (Unit)seq.get(k);
                        found = 0;
                        Object v = uArry[j + k];
                        if (!this.equalUnits(u, v, b) || illegalUnits.contains(v)) break;
                        if (k > 0 && (preds = bug.getPredsOf((Unit)v)).size() > 0) {
                            int fcount = 0;
                            block10: for (Unit p : preds) {
                                for (int jj = 0; jj < count; ++jj) {
                                    if (p != uArry[j + jj]) continue;
                                    ++fcount;
                                    continue block10;
                                }
                            }
                            if (fcount < preds.size()) break;
                        }
                        if (!stackHeightsBefore.get(u).equals(stackHeightsBefore.get(v))) break;
                        found = 1;
                    }
                    if (found == 0) continue;
                    ArrayList<Object> foundSeq = new ArrayList<Object>();
                    for (int m3 = 0; m3 < count; ++m3) {
                        foundSeq.add(uArry[j + m3]);
                    }
                    matches.add(foundSeq);
                }
                if (matches.size() <= 0) continue;
                boolean done = false;
                for (int x = 0; x < seq.size(); ++x) {
                    if (!unitIDs.contains(seq.get(x))) {
                        done = true;
                        continue;
                    }
                    unitIDs.remove(seq.get(x));
                }
                if (done || (matches = FindDuplicateSequences.cullOverlaps(b, unitIDs, matches)).size() <= 0) continue;
                selected.put(seq, matches);
            }
            if (selected.size() <= 0) continue;
            for (List key : selected.keySet()) {
                List avalues = (List)selected.get(key);
                if (avalues.size() < 1 || Rand.getInt(10) <= weight) continue;
                changed = true;
                controlLocal = Baf.v().newLocal("controlLocalfordups" + controlLocalIndex, IntType.v());
                bLocals.add(controlLocal);
                bafToJLocals.put(controlLocal, Jimple.v().newLocal("controlLocalfordups" + controlLocalIndex++, IntType.v()));
                int n = key.size();
                counts[n] = counts[n] + avalues.size();
                ArrayList<Unit> jumps = new ArrayList<Unit>();
                Unit first = (Unit)key.get(0);
                StoreInst store = Baf.v().newStoreInst(IntType.v(), controlLocal);
                units.insertBefore(store, first);
                PushInst pushUnit = Baf.v().newPushInst(IntConstant.v(0));
                units.insertBefore(pushUnit, store);
                int index = 1;
                for (List next : avalues) {
                    Unit jump = units.getSuccOf((Unit)next.get(next.size() - 1));
                    Unit firstt = (Unit)next.get(0);
                    Unit storet = (Unit)store.clone();
                    units.insertBefore(storet, firstt);
                    pushUnit = Baf.v().newPushInst(IntConstant.v(index++));
                    units.insertBefore(pushUnit, storet);
                    GotoInst goUnit = Baf.v().newGotoInst(first);
                    units.insertAfter(goUnit, storet);
                    jumps.add(jump);
                }
                Unit insertAfter = (Unit)key.get(key.size() - 1);
                TableSwitchInst swUnit = Baf.v().newTableSwitchInst(units.getSuccOf(insertAfter), 1, jumps.size(), jumps);
                units.insertAfter(swUnit, insertAfter);
                LoadInst loadUnit = Baf.v().newLoadInst(IntType.v(), controlLocal);
                units.insertAfter(loadUnit, insertAfter);
                for (List next : avalues) {
                    units.removeAll(next);
                }
            }
        }
        boolean dupsExist = false;
        if (output) {
            System.out.println("Duplicate Sequences for " + b.getMethod().getName());
        }
        for (int count = longestSeq; count >= 0; --count) {
            if (counts[count] <= 0) continue;
            if (output) {
                out.println(count + " total: " + counts[count]);
            }
            dupsExist = true;
            int n = count;
            this.totalcounts[n] = this.totalcounts[n] + counts[count];
        }
        if (!dupsExist) {
            if (output) {
                out.println("\tnone");
            }
        } else if (debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }

    private boolean equalUnits(Object o1, Object o2, Body b) {
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        List<Trap> l1 = this.getTrapsForUnit(o1, b);
        List<Trap> l2 = this.getTrapsForUnit(o2, b);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i) == l2.get(i)) continue;
            return false;
        }
        if (o1 instanceof NoArgInst) {
            return true;
        }
        if (o1 instanceof TargetArgInst) {
            if (o1 instanceof OpTypeArgInst) {
                return ((TargetArgInst)o1).getTarget() == ((TargetArgInst)o2).getTarget() && ((OpTypeArgInst)o1).getOpType() == ((OpTypeArgInst)o2).getOpType();
            }
            return ((TargetArgInst)o1).getTarget() == ((TargetArgInst)o2).getTarget();
        }
        if (o1 instanceof OpTypeArgInst) {
            return ((OpTypeArgInst)o1).getOpType() == ((OpTypeArgInst)o2).getOpType();
        }
        if (o1 instanceof MethodArgInst) {
            return ((MethodArgInst)o1).getMethod() == ((MethodArgInst)o2).getMethod();
        }
        if (o1 instanceof FieldArgInst) {
            return ((FieldArgInst)o1).getField() == ((FieldArgInst)o2).getField();
        }
        if (o1 instanceof PrimitiveCastInst) {
            return ((PrimitiveCastInst)o1).getFromType() == ((PrimitiveCastInst)o2).getFromType() && ((PrimitiveCastInst)o1).getToType() == ((PrimitiveCastInst)o2).getToType();
        }
        if (o1 instanceof DupInst) {
            return this.compareDups(o1, o2);
        }
        if (o1 instanceof LoadInst) {
            return ((LoadInst)o1).getLocal() == ((LoadInst)o2).getLocal();
        }
        if (o1 instanceof StoreInst) {
            return ((StoreInst)o1).getLocal() == ((StoreInst)o2).getLocal();
        }
        if (o1 instanceof PushInst) {
            return this.equalConstants(((PushInst)o1).getConstant(), ((PushInst)o2).getConstant());
        }
        if (o1 instanceof IncInst && this.equalConstants(((IncInst)o1).getConstant(), ((IncInst)o2).getConstant())) {
            return ((IncInst)o1).getLocal() == ((IncInst)o2).getLocal();
        }
        if (o1 instanceof InstanceCastInst) {
            return this.equalTypes(((InstanceCastInst)o1).getCastType(), ((InstanceCastInst)o2).getCastType());
        }
        if (o1 instanceof InstanceOfInst) {
            return this.equalTypes(((InstanceOfInst)o1).getCheckType(), ((InstanceOfInst)o2).getCheckType());
        }
        if (o1 instanceof NewArrayInst) {
            return this.equalTypes(((NewArrayInst)o1).getBaseType(), ((NewArrayInst)o2).getBaseType());
        }
        if (o1 instanceof NewInst) {
            return this.equalTypes(((NewInst)o1).getBaseType(), ((NewInst)o2).getBaseType());
        }
        if (o1 instanceof NewMultiArrayInst) {
            return this.equalTypes(((NewMultiArrayInst)o1).getBaseType(), ((NewMultiArrayInst)o2).getBaseType()) && ((NewMultiArrayInst)o1).getDimensionCount() == ((NewMultiArrayInst)o2).getDimensionCount();
        }
        if (o1 instanceof PopInst) {
            return ((PopInst)o1).getWordCount() == ((PopInst)o2).getWordCount();
        }
        if (o1 instanceof SwapInst) {
            return ((SwapInst)o1).getFromType() == ((SwapInst)o2).getFromType() && ((SwapInst)o1).getToType() == ((SwapInst)o2).getToType();
        }
        return false;
    }

    private List<Trap> getTrapsForUnit(Object o, Body b) {
        ArrayList<Trap> list = new ArrayList<Trap>();
        Chain<Trap> traps = b.getTraps();
        if (traps.size() != 0) {
            UnitPatchingChain units = b.getUnits();
            block0: for (Trap t : traps) {
                Iterator<Unit> tit = units.iterator(t.getBeginUnit(), t.getEndUnit());
                while (tit.hasNext()) {
                    if (tit.next() != o) continue;
                    list.add(t);
                    continue block0;
                }
            }
        }
        return list;
    }

    private boolean overlap(Object[] units, List<?> list, int idx, int count) {
        if (idx < 0 || list == null || list.size() == 0) {
            return false;
        }
        Object first = list.get(0);
        Object last = list.get(list.size() - 1);
        for (int i = idx; i < idx + count; ++i) {
            if (i >= units.length || first != units[i] && last != units[i]) continue;
            return true;
        }
        return false;
    }

    private boolean equalConstants(Constant c1, Constant c2) {
        Type t = c1.getType();
        if (t != c2.getType()) {
            return false;
        }
        if (t instanceof IntType) {
            return ((IntConstant)c1).value == ((IntConstant)c2).value;
        }
        if (t instanceof FloatType) {
            return ((FloatConstant)c1).value == ((FloatConstant)c2).value;
        }
        if (t instanceof LongType) {
            return ((LongConstant)c1).value == ((LongConstant)c2).value;
        }
        if (t instanceof DoubleType) {
            return ((DoubleConstant)c1).value == ((DoubleConstant)c2).value;
        }
        if (c1 instanceof StringConstant && c2 instanceof StringConstant) {
            return ((StringConstant)c1).value == ((StringConstant)c2).value;
        }
        return c1 instanceof NullConstant && c2 instanceof NullConstant;
    }

    private boolean compareDups(Object o1, Object o2) {
        DupInst d1 = (DupInst)o1;
        DupInst d2 = (DupInst)o2;
        List<Type> l1 = d1.getOpTypes();
        List<Type> l2 = d2.getOpTypes();
        for (int k = 0; k < 2; ++k) {
            if (k == 1) {
                l1 = d1.getUnderTypes();
                l2 = d2.getUnderTypes();
            }
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int i = 0; i < l1.size(); ++i) {
                if (l1.get(i) == l2.get(i)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equalTypes(Type t1, Type t2) {
        if (t1 instanceof RefType) {
            if (t2 instanceof RefType) {
                RefType rt1 = (RefType)t1;
                RefType rt2 = (RefType)t2;
                return rt1.compareTo(rt2) == 0;
            }
            return false;
        }
        if (t1 instanceof PrimType && t2 instanceof PrimType) {
            return t1.getClass() == t2.getClass();
        }
        return false;
    }

    private static List<List<Unit>> cullOverlaps(Body b, List<Unit> ids, List<List<Unit>> matches) {
        ArrayList<List<Unit>> newMatches = new ArrayList<List<Unit>>();
        for (int i = 0; i < matches.size(); ++i) {
            List<Unit> match = matches.get(i);
            Iterator<Unit> it = match.iterator();
            boolean clean = true;
            while (it.hasNext()) {
                if (ids.contains(it.next())) continue;
                clean = false;
                break;
            }
            if (clean) {
                List<UnitBox> targs = b.getUnitBoxes(true);
                block2: for (int j = 0; j < targs.size() && clean; ++j) {
                    Unit u = targs.get(j).getUnit();
                    it = match.iterator();
                    while (it.hasNext()) {
                        if (u != it.next()) continue;
                        clean = false;
                        continue block2;
                    }
                }
            }
            if (!clean) continue;
            it = match.iterator();
            while (it.hasNext()) {
                ids.remove(it.next());
            }
            newMatches.add(match);
        }
        return newMatches;
    }
}

