/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FastHierarchy;
import soot.FloatType;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.util.Chain;

public class LibraryMethodWrappersBuilder
extends SceneTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(LibraryMethodWrappersBuilder.class);
    public static final String name = "wjtp.jbco_blbc";
    public static final String[] dependencies = new String[]{"wjtp.jbco_blbc"};
    private static final Map<SootClass, Map<SootMethod, SootMethodRef>> libClassesToMethods = new HashMap<SootClass, Map<SootMethod, SootMethodRef>>();
    public static List<SootMethod> builtByMe = new ArrayList<SootMethod>();
    private int newmethods = 0;
    private int methodcalls = 0;

    @Override
    public String[] getDependencies() {
        return Arrays.copyOf(dependencies, dependencies.length);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        logger.info("Created {} new methods. Replaced {} method calls.", (Object)this.newmethods, (Object)this.methodcalls);
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (this.isVerbose()) {
            logger.info("Building Library Wrapper Methods...");
        }
        BodyBuilder.retrieveAllBodies();
        Iterator<SootClass> applicationClassesIterator = Scene.v().getApplicationClasses().snapshotIterator();
        while (applicationClassesIterator.hasNext()) {
            SootClass applicationClass = applicationClassesIterator.next();
            if (this.isVerbose()) {
                logger.info("\tProcessing class {}", (Object)applicationClass.getName());
            }
            ArrayList<SootMethod> methods = new ArrayList<SootMethod>(applicationClass.getMethods());
            for (SootMethod method : methods) {
                Body body;
                if (!method.isConcrete() || builtByMe.contains(method) || (body = LibraryMethodWrappersBuilder.getBodySafely(method)) == null) continue;
                int localName = 0;
                Unit first = LibraryMethodWrappersBuilder.getFirstNotIdentityStmt(body);
                Iterator unitIterator = body.getUnits().snapshotIterator();
                while (unitIterator.hasNext()) {
                    Unit unit = (Unit)unitIterator.next();
                    for (ValueBox valueBox : unit.getUseBoxes()) {
                        InvokeExpr invokeExpr;
                        SootMethod invokedMethod;
                        Value value = valueBox.getValue();
                        if (!(value instanceof InvokeExpr) || value instanceof SpecialInvokeExpr || (invokedMethod = LibraryMethodWrappersBuilder.getMethodSafely(invokeExpr = (InvokeExpr)value)) == null) continue;
                        SootMethodRef invokedMethodRef = this.getNewMethodRef(invokedMethod);
                        if (invokedMethodRef == null) {
                            invokedMethodRef = this.buildNewMethod(applicationClass, invokedMethod, invokeExpr);
                            this.setNewMethodRef(invokedMethod, invokedMethodRef);
                            ++this.newmethods;
                        }
                        if (this.isVerbose()) {
                            logger.info("\t\t\tChanging {} to {}\tUnit: ", invokedMethod.getSignature(), invokedMethodRef.getSignature(), unit);
                        }
                        List<Value> args = invokeExpr.getArgs();
                        List<Type> parameterTypes = invokedMethodRef.parameterTypes();
                        int argsCount = args.size();
                        int paramCount = parameterTypes.size();
                        if (invokeExpr instanceof InstanceInvokeExpr || invokeExpr instanceof StaticInvokeExpr) {
                            if (invokeExpr instanceof InstanceInvokeExpr) {
                                ++argsCount;
                                args.add(((InstanceInvokeExpr)invokeExpr).getBase());
                            }
                            while (argsCount < paramCount) {
                                Type pType = parameterTypes.get(argsCount);
                                Local newLocal = Jimple.v().newLocal("newLocal" + localName++, pType);
                                body.getLocals().add(newLocal);
                                body.getUnits().insertBeforeNoRedirect(Jimple.v().newAssignStmt(newLocal, LibraryMethodWrappersBuilder.getConstantType(pType)), first);
                                args.add(newLocal);
                                ++argsCount;
                            }
                            valueBox.setValue(Jimple.v().newStaticInvokeExpr(invokedMethodRef, args));
                        }
                        ++this.methodcalls;
                    }
                }
            }
        }
        Scene.v().releaseActiveHierarchy();
        Scene.v().setFastHierarchy(new FastHierarchy());
    }

    private SootMethodRef getNewMethodRef(SootMethod method) {
        Map methods = libClassesToMethods.computeIfAbsent(method.getDeclaringClass(), key -> new HashMap());
        return (SootMethodRef)methods.get(method);
    }

    private void setNewMethodRef(SootMethod sm, SootMethodRef smr) {
        Map methods = libClassesToMethods.computeIfAbsent(sm.getDeclaringClass(), key -> new HashMap());
        methods.put(sm, smr);
    }

    private SootMethodRef buildNewMethod(SootClass fromC, SootMethod sm, InvokeExpr origIE) {
        int index;
        SootClass randomClass;
        List<SootMethod> methods;
        SootMethod randMethod;
        String methodNewName;
        List<SootClass> availableClasses = LibraryMethodWrappersBuilder.getVisibleApplicationClasses(sm);
        int classCount = availableClasses.size();
        if (classCount == 0) {
            throw new RuntimeException("There appears to be no public non-interface Application classes!");
        }
        do {
            if ((randomClass = availableClasses.get(index = Rand.getInt(classCount))) != fromC || classCount <= 1) continue;
            index = Rand.getInt(classCount);
            randomClass = availableClasses.get(index);
        } while ((methodNewName = (randMethod = (methods = randomClass.getMethods()).get(index = Rand.getInt(methods.size()))).getName()).equals("<init>") || methodNewName.equals("<clinit>"));
        ArrayList<Type> smParamTypes = new ArrayList<Type>(sm.getParameterTypes());
        if (!sm.isStatic()) {
            smParamTypes.add(sm.getDeclaringClass().getType());
        }
        int extraParams = 0;
        if (randomClass.declaresMethod(methodNewName, smParamTypes)) {
            int rtmp = Rand.getInt(classCount + 7);
            if (rtmp >= classCount) {
                smParamTypes.add(LibraryMethodWrappersBuilder.getPrimType(rtmp -= classCount));
            } else {
                smParamTypes.add(availableClasses.get(rtmp).getType());
            }
        }
        int mods = (sm.getModifiers() | 8 | 1) & 0xFBFF & 0xFEFF & 0xFFDF;
        SootMethod newMethod = Scene.v().makeSootMethod(methodNewName, smParamTypes, sm.getReturnType(), mods);
        randomClass.addMethod(newMethod);
        JimpleBody body = Jimple.v().newBody(newMethod);
        newMethod.setActiveBody(body);
        Chain<Local> locals = body.getLocals();
        UnitPatchingChain units = body.getUnits();
        List<Local> args = BodyBuilder.buildParameterLocals(units, locals, smParamTypes);
        while (true) {
            int n = ++extraParams;
            --extraParams;
            if (n <= 0) break;
            args.remove(args.size() - 1);
        }
        InvokeExpr ie = null;
        if (sm.isStatic()) {
            ie = Jimple.v().newStaticInvokeExpr(sm.makeRef(), args);
        } else {
            Local libObj = args.remove(args.size() - 1);
            if (origIE instanceof InterfaceInvokeExpr) {
                ie = Jimple.v().newInterfaceInvokeExpr(libObj, sm.makeRef(), args);
            } else if (origIE instanceof VirtualInvokeExpr) {
                ie = Jimple.v().newVirtualInvokeExpr(libObj, sm.makeRef(), args);
            }
        }
        if (sm.getReturnType() instanceof VoidType) {
            units.add(Jimple.v().newInvokeStmt(ie));
            units.add(Jimple.v().newReturnVoidStmt());
        } else {
            Local assign = Jimple.v().newLocal("returnValue", sm.getReturnType());
            locals.add(assign);
            units.add(Jimple.v().newAssignStmt(assign, ie));
            units.add(Jimple.v().newReturnStmt(assign));
        }
        if (this.isVerbose()) {
            logger.info("{} was replaced by {} which calls {}", sm.getName(), newMethod.getName(), ie);
        }
        if (units.size() < 2) {
            logger.warn("THERE AREN'T MANY UNITS IN THIS METHOD {}", (Object)units);
        }
        builtByMe.add(newMethod);
        return newMethod.makeRef();
    }

    private static Type getPrimType(int idx) {
        switch (idx) {
            case 0: {
                return IntType.v();
            }
            case 1: {
                return CharType.v();
            }
            case 2: {
                return ByteType.v();
            }
            case 3: {
                return LongType.v();
            }
            case 4: {
                return BooleanType.v();
            }
            case 5: {
                return DoubleType.v();
            }
            case 6: {
                return FloatType.v();
            }
        }
        return IntType.v();
    }

    private static Value getConstantType(Type t) {
        if (t instanceof BooleanType) {
            return IntConstant.v(Rand.getInt(1));
        }
        if (t instanceof IntType) {
            return IntConstant.v(Rand.getInt());
        }
        if (t instanceof CharType) {
            return Jimple.v().newCastExpr(IntConstant.v(Rand.getInt()), CharType.v());
        }
        if (t instanceof ByteType) {
            return Jimple.v().newCastExpr(IntConstant.v(Rand.getInt()), ByteType.v());
        }
        if (t instanceof LongType) {
            return LongConstant.v(Rand.getLong());
        }
        if (t instanceof FloatType) {
            return FloatConstant.v(Rand.getFloat());
        }
        if (t instanceof DoubleType) {
            return DoubleConstant.v(Rand.getDouble());
        }
        return Jimple.v().newCastExpr(NullConstant.v(), t);
    }

    private static Body getBodySafely(SootMethod method) {
        try {
            return method.getActiveBody();
        }
        catch (Exception exception) {
            logger.warn("Getting Body from SootMethod {} caused exception that was suppressed.", exception);
            return method.retrieveActiveBody();
        }
    }

    private static Unit getFirstNotIdentityStmt(Body body) {
        Iterator unitIterator = body.getUnits().snapshotIterator();
        while (unitIterator.hasNext()) {
            Unit unit = (Unit)unitIterator.next();
            if (unit instanceof IdentityStmt) continue;
            return unit;
        }
        logger.debug("There are no non-identity units in the method body.");
        return null;
    }

    private static SootMethod getMethodSafely(InvokeExpr invokeExpr) {
        try {
            SootMethod invokedMethod = invokeExpr.getMethod();
            if (invokedMethod == null) {
                return null;
            }
            if ("<init>".equals(invokedMethod.getName()) || "<clinit>".equals(invokedMethod.getName())) {
                logger.debug("Skipping wrapping method {} as it is constructor/initializer.", (Object)invokedMethod);
                return null;
            }
            SootClass invokedMethodClass = invokedMethod.getDeclaringClass();
            if (!invokedMethodClass.isLibraryClass()) {
                logger.debug("Skipping wrapping method {} as it is not library one.", (Object)invokedMethod);
                return null;
            }
            if (invokeExpr.getMethodRef().declaringClass().isInterface() && !invokedMethodClass.isInterface()) {
                logger.debug("Skipping wrapping method {} as original code suppose to execute it on interface {} but resolved code trying to execute it on class {}", invokedMethod, invokeExpr.getMethodRef().declaringClass(), invokedMethodClass);
                return null;
            }
            return invokedMethod;
        }
        catch (RuntimeException exception) {
            logger.debug("Cannot resolve method of InvokeExpr: " + invokeExpr.toString(), exception);
            return null;
        }
    }

    private static List<SootClass> getVisibleApplicationClasses(SootMethod visibleBy) {
        ArrayList<SootClass> result = new ArrayList<SootClass>();
        Iterator<SootClass> applicationClassesIterator = Scene.v().getApplicationClasses().snapshotIterator();
        while (applicationClassesIterator.hasNext()) {
            SootClass applicationClass = applicationClassesIterator.next();
            if (!applicationClass.isConcrete() || applicationClass.isInterface() || !applicationClass.isPublic() || !Scene.v().getActiveHierarchy().isVisible(applicationClass, visibleBy)) continue;
            result.add(applicationClass);
        }
        return result;
    }
}

