/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.validation.FieldRefValidator;
import soot.jimple.validation.IdentityStatementsValidator;
import soot.jimple.validation.IdentityValidator;
import soot.jimple.validation.InvokeArgumentValidator;
import soot.jimple.validation.JimpleTrapValidator;
import soot.jimple.validation.MethodValidator;
import soot.jimple.validation.NewValidator;
import soot.jimple.validation.ReturnStatementsValidator;
import soot.jimple.validation.TypesValidator;
import soot.options.Options;
import soot.util.Chain;
import soot.validation.BodyValidator;
import soot.validation.ValidationException;

public class JimpleBody
extends StmtBody {
    private static final Logger logger = LoggerFactory.getLogger(JimpleBody.class);

    public JimpleBody(SootMethod m3) {
        super(m3);
        if (Options.v().verbose()) {
            logger.debug("[" + this.getMethod().getName() + "] Constructing JimpleBody...");
        }
    }

    public JimpleBody() {
    }

    @Override
    public Object clone() {
        JimpleBody b = new JimpleBody(this.getMethodUnsafe());
        b.importBodyContentsFrom(this);
        return b;
    }

    @Override
    public Object clone(boolean noLocalsClone) {
        JimpleBody b = new JimpleBody(this.getMethod());
        b.importBodyContentsFrom(this, true);
        return b;
    }

    @Override
    public void validate() {
        ArrayList<ValidationException> exceptionList = new ArrayList<ValidationException>();
        this.validate(exceptionList);
        if (!exceptionList.isEmpty()) {
            throw (ValidationException)exceptionList.get(0);
        }
    }

    @Override
    public void validate(List<ValidationException> exceptionList) {
        super.validate(exceptionList);
        boolean runAllValidators = Options.v().debug() || Options.v().validate();
        for (BodyValidator validator : LazyValidatorsSingleton.V) {
            if (!runAllValidators && !validator.isBasicValidator()) continue;
            validator.validate(this, exceptionList);
        }
    }

    public void validateIdentityStatements() {
        this.runValidation(IdentityStatementsValidator.v());
    }

    public void insertIdentityStmts() {
        this.insertIdentityStmts(this.getMethod().getDeclaringClass());
    }

    public void insertIdentityStmts(SootClass declaringClass) {
        Jimple jimple = Jimple.v();
        UnitPatchingChain unitChain = this.getUnits();
        Chain<Local> localChain = this.getLocals();
        IdentityStmt lastUnit = null;
        if (!this.getMethod().isStatic()) {
            if (declaringClass == null) {
                throw new IllegalArgumentException(String.format("No declaring class given for method %s", this.method.getSubSignature()));
            }
            Local l = jimple.newLocal("this", RefType.v(declaringClass));
            IdentityStmt s2 = jimple.newIdentityStmt(l, jimple.newThisRef((RefType)l.getType()));
            localChain.add(l);
            unitChain.addFirst(s2);
            lastUnit = s2;
        }
        int i = 0;
        for (Type t : this.getMethod().getParameterTypes()) {
            Local l = jimple.newLocal("parameter" + i, t);
            IdentityStmt s3 = jimple.newIdentityStmt(l, jimple.newParameterRef(l.getType(), i));
            localChain.add(l);
            if (lastUnit == null) {
                unitChain.addFirst(s3);
            } else {
                unitChain.insertAfter(s3, lastUnit);
            }
            lastUnit = s3;
            ++i;
        }
    }

    public Stmt getFirstNonIdentityStmt() {
        Unit u;
        Unit r = null;
        Iterator iterator = this.getUnits().iterator();
        while (iterator.hasNext() && (r = (u = (Unit)iterator.next())) instanceof IdentityStmt) {
        }
        if (r == null) {
            throw new RuntimeException("no non-id statements!");
        }
        return (Stmt)r;
    }

    private static class LazyValidatorsSingleton {
        static final BodyValidator[] V = new BodyValidator[]{IdentityStatementsValidator.v(), TypesValidator.v(), ReturnStatementsValidator.v(), InvokeArgumentValidator.v(), FieldRefValidator.v(), NewValidator.v(), JimpleTrapValidator.v(), IdentityValidator.v(), MethodValidator.v()};

        private LazyValidatorsSingleton() {
        }
    }
}

