/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.RefType;
import soot.Type;
import soot.jimple.Constant;
import soot.jimple.ConstantSwitch;
import soot.options.Options;
import soot.util.StringTools;
import soot.util.Switch;

public class StringConstant
extends Constant {
    public final String value;
    public static final StringConstant EMPTY_STRING = new StringConstant("");

    protected StringConstant(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("String constant cannot be null");
        }
        this.value = s2;
    }

    public static StringConstant v(String value) {
        if (value.isEmpty()) {
            return EMPTY_STRING;
        }
        return new StringConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof StringConstant && ((StringConstant)c).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return StringTools.getQuotedStringOf(this.value);
    }

    @Override
    public Type getType() {
        if (Options.v().src_prec() == 7) {
            return RefType.v("System.String");
        }
        return RefType.v("java.lang.String");
    }

    @Override
    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseStringConstant(this);
    }
}

