/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import soot.FastHierarchy;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.TypeUtils;

public class InfoflowManager {
    private final InfoflowConfiguration config;
    private IInfoflowSolver forwardSolver;
    private final IInfoflowCFG icfg;
    private final ISourceSinkManager sourceSinkManager;
    private final ITaintPropagationWrapper taintWrapper;
    private final TypeUtils typeUtils;
    private final FastHierarchy hierarchy;
    private final AccessPathFactory accessPathFactory;
    private final GlobalTaintManager globalTaintManager;
    private Aliasing aliasing;

    protected InfoflowManager(InfoflowConfiguration config, IInfoflowSolver forwardSolver, IInfoflowCFG icfg, ISourceSinkManager sourceSinkManager, ITaintPropagationWrapper taintWrapper, FastHierarchy hierarchy, AccessPathFactory accessPathFactory, GlobalTaintManager globalTaintManager) {
        this.config = config;
        this.forwardSolver = forwardSolver;
        this.icfg = icfg;
        this.sourceSinkManager = sourceSinkManager;
        this.taintWrapper = taintWrapper;
        this.typeUtils = new TypeUtils(this);
        this.hierarchy = hierarchy;
        this.accessPathFactory = accessPathFactory;
        this.globalTaintManager = globalTaintManager;
    }

    public InfoflowConfiguration getConfig() {
        return this.config;
    }

    public void setForwardSolver(IInfoflowSolver solver) {
        this.forwardSolver = solver;
    }

    public IInfoflowSolver getForwardSolver() {
        return this.forwardSolver;
    }

    public IInfoflowCFG getICFG() {
        return this.icfg;
    }

    public ISourceSinkManager getSourceSinkManager() {
        return this.sourceSinkManager;
    }

    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    public FastHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public AccessPathFactory getAccessPathFactory() {
        return this.accessPathFactory;
    }

    public boolean isAnalysisAborted() {
        if (this.forwardSolver instanceof IMemoryBoundedSolver) {
            return ((IMemoryBoundedSolver)((Object)this.forwardSolver)).isKilled();
        }
        return false;
    }

    public void cleanup() {
        this.forwardSolver = null;
        this.aliasing = null;
    }

    public void setAliasing(Aliasing aliasing) {
        this.aliasing = aliasing;
    }

    public Aliasing getAliasing() {
        return this.aliasing;
    }

    public GlobalTaintManager getGlobalTaintManager() {
        return this.globalTaintManager;
    }
}

