/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import soot.PointsToSet;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.AbstractInteractiveAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.solver.IInfoflowSolver;

public class LazyAliasingStrategy
extends AbstractInteractiveAliasStrategy {
    public LazyAliasingStrategy(InfoflowManager manager) {
        super(manager);
    }

    @Override
    public boolean isInteractive() {
        return true;
    }

    @Override
    public boolean mayAlias(AccessPath ap1, AccessPath ap2) {
        PointsToSet ptaAP2;
        if (ap1 == ap2 || ap1.equals(ap2)) {
            return true;
        }
        PointsToSet ptaAP1 = this.getPointsToSet(ap1);
        return ptaAP1.hasNonEmptyIntersection(ptaAP2 = this.getPointsToSet(ap2));
    }

    private PointsToSet getPointsToSet(AccessPath accessPath) {
        if (accessPath.isLocal()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue());
        }
        if (accessPath.isInstanceFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue(), accessPath.getFirstField());
        }
        if (accessPath.isStaticFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getFirstField());
        }
        throw new RuntimeException("Unexepected access path type");
    }

    @Override
    public void injectCallingContext(Abstraction abs, IInfoflowSolver fSolver, SootMethod callee, Unit callSite, Abstraction source, Abstraction d1) {
    }

    @Override
    public boolean isFlowSensitive() {
        return true;
    }

    @Override
    public boolean requiresAnalysisOnReturn() {
        return false;
    }

    @Override
    public boolean hasProcessedMethod(SootMethod method) {
        return true;
    }

    @Override
    public boolean isLazyAnalysis() {
        return true;
    }

    @Override
    public IInfoflowSolver getSolver() {
        return null;
    }

    @Override
    public void cleanup() {
    }
}

