/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.cfg;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.dexpler.DalvikThrowAnalysis;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.OnTheFlyJimpleBasedICFG;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraphFactory;

public class DefaultBiDiICFGFactory
implements BiDirICFGFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected boolean isAndroid = false;

    @Override
    public IInfoflowCFG buildBiDirICFG(InfoflowConfiguration.CallgraphAlgorithm callgraphAlgorithm, boolean enableExceptions) {
        if (callgraphAlgorithm == InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
            long beforeClassLoading = System.nanoTime();
            OnTheFlyJimpleBasedICFG.loadAllClassesOnClassPathToSignatures();
            this.logger.info("Class loading took {} seconds", (Object)((double)(System.nanoTime() - beforeClassLoading) / 1.0E9));
            long beforeHierarchy = System.nanoTime();
            Scene.v().getOrMakeFastHierarchy();
            assert (Scene.v().hasFastHierarchy());
            this.logger.info("Hierarchy building took {} seconds", (Object)((double)(System.nanoTime() - beforeHierarchy) / 1.0E9));
            long beforeCFG = System.nanoTime();
            InfoflowCFG cfg = new InfoflowCFG(new OnTheFlyJimpleBasedICFG(Scene.v().getEntryPoints()));
            this.logger.info("CFG generation took {} seconds", (Object)((double)(System.nanoTime() - beforeCFG) / 1.0E9));
            return cfg;
        }
        BiDiInterproceduralCFG<Unit, SootMethod> baseCFG = this.getBaseCFG(enableExceptions);
        return new InfoflowCFG(baseCFG);
    }

    protected BiDiInterproceduralCFG<Unit, SootMethod> getBaseCFG(boolean enableExceptions) {
        JimpleBasedInterproceduralCFG baseCFG = null;
        baseCFG = this.isAndroid ? new JimpleBasedInterproceduralCFG(enableExceptions, true){

            @Override
            protected DirectedGraph<Unit> makeGraph(Body body) {
                return this.enableExceptions ? ExceptionalUnitGraphFactory.createExceptionalUnitGraph(body, DalvikThrowAnalysis.interproc(), true) : new BriefUnitGraph(body);
            }
        } : new JimpleBasedInterproceduralCFG(enableExceptions, true);
        baseCFG.setIncludePhantomCallees(true);
        return baseCFG;
    }

    public void setIsAndroid(boolean isAndroid) {
        this.isAndroid = isAndroid;
    }
}

