/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMap;
import soot.util.AbstractMultiMap;
import soot.util.MultiMap;

public class ConcurrentIdentityHashMultiMap<K, V>
extends AbstractMultiMap<K, V> {
    private static final long serialVersionUID = -6721251660349964507L;
    Map<K, ConcurrentMap<V, V>> m = new ConcurrentIdentityHashMap<K, ConcurrentMap<V, V>>();

    public ConcurrentIdentityHashMultiMap() {
    }

    public ConcurrentIdentityHashMultiMap(MultiMap<K, V> m3) {
        this.putAll(m3);
    }

    @Override
    public int numKeys() {
        return this.m.size();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(V value) {
        for (Map map : this.m.values()) {
            if (!map.containsKey(value)) continue;
            return true;
        }
        return false;
    }

    protected ConcurrentMap<V, V> newSet() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<V, V> findSet(K key) {
        ConcurrentMap<V, V> s2 = this.m.get(key);
        if (s2 == null) {
            ConcurrentIdentityHashMultiMap concurrentIdentityHashMultiMap = this;
            synchronized (concurrentIdentityHashMultiMap) {
                s2 = this.m.get(key);
                if (s2 == null) {
                    s2 = this.newSet();
                    this.m.put(key, s2);
                }
            }
        }
        return s2;
    }

    @Override
    public boolean put(K key, V value) {
        return this.findSet(key).put(value, value) == null;
    }

    public V putIfAbsent(K key, V value) {
        return this.findSet(key).putIfAbsent(value, value);
    }

    @Override
    public boolean putAll(K key, Collection<V> values) {
        ConcurrentMap<V, V> set = this.findSet(key);
        boolean ok = false;
        for (V v : values) {
            if (set.put(v, v) != null) continue;
            ok = true;
        }
        return ok;
    }

    @Override
    public boolean remove(K key, V value) {
        boolean ret;
        Map s2 = this.m.get(key);
        if (s2 == null) {
            return false;
        }
        boolean bl = ret = s2.remove(value) != null;
        if (s2.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public boolean remove(K key) {
        return null != this.m.remove(key);
    }

    @Override
    public boolean removeAll(K key, Collection<V> values) {
        Map s2 = this.m.get(key);
        if (s2 == null) {
            return false;
        }
        boolean ret = false;
        for (V v : values) {
            if (s2.remove(v) == null) continue;
            ret = true;
        }
        if (s2.isEmpty()) {
            this.m.remove(key);
        }
        return ret;
    }

    @Override
    public Set<V> get(K o) {
        Map ret = this.m.get(o);
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret.keySet();
    }

    @Override
    public Set<K> keySet() {
        return this.m.keySet();
    }

    @Override
    public Set<V> values() {
        HashSet ret = new HashSet(this.m.size());
        for (Map map : this.m.values()) {
            ret.addAll(map.keySet());
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MultiMap)) {
            return false;
        }
        MultiMap mm3 = (MultiMap)o;
        if (!this.keySet().equals(mm3.keySet())) {
            return false;
        }
        for (Map.Entry<K, ConcurrentMap<V, V>> e : this.m.entrySet()) {
            Map s2 = e.getValue();
            Set otherValues = mm3.get(e.getKey());
            if (s2.keySet().equals(otherValues)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.m.hashCode();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public void clear() {
        this.m.clear();
    }
}

