/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import soot.Local;
import soot.NullType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Jimple;
import soot.jimple.StaticFieldRef;

public class AccessPath
implements Cloneable {
    private static AccessPath zeroAccessPath = null;
    private final Local value;
    private final SootField[] fields;
    private final Type baseType;
    private final Type[] fieldTypes;
    private final boolean taintSubFields;
    private final boolean cutOffApproximation;
    private final ArrayTaintType arrayTaintType;
    private final boolean canHaveImmutableAliases;
    private int hashCode = 0;
    private static final AccessPath emptyAccessPath = new AccessPath();

    private AccessPath() {
        this.value = null;
        this.fields = null;
        this.baseType = null;
        this.fieldTypes = null;
        this.taintSubFields = true;
        this.cutOffApproximation = false;
        this.arrayTaintType = ArrayTaintType.ContentsAndLength;
        this.canHaveImmutableAliases = false;
    }

    AccessPath(Local val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean isCutOffApproximation, ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        this.value = val;
        this.fields = appendingFields;
        this.baseType = valType;
        this.fieldTypes = appendingFieldTypes;
        this.taintSubFields = taintSubFields;
        this.cutOffApproximation = isCutOffApproximation;
        this.arrayTaintType = arrayTaintType;
        this.canHaveImmutableAliases = canHaveImmutableAliases;
    }

    public static boolean canContainValue(Value val) {
        if (val == null) {
            return false;
        }
        return val instanceof Local || val instanceof InstanceFieldRef || val instanceof StaticFieldRef || val instanceof ArrayRef;
    }

    public Local getPlainValue() {
        return this.value;
    }

    public Value getCompleteValue() {
        SootField f = this.getFirstField();
        if (this.value == null) {
            if (f == null) {
                return null;
            }
            return Jimple.v().newStaticFieldRef(f.makeRef());
        }
        if (f == null) {
            return this.value;
        }
        return Jimple.v().newInstanceFieldRef(this.value, f.makeRef());
    }

    public SootField getLastField() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[this.fields.length - 1];
    }

    public Type getLastFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return this.baseType;
        }
        return this.fieldTypes[this.fieldTypes.length - 1];
    }

    public SootField getFirstField() {
        if (this.fields == null || this.fields.length == 0) {
            return null;
        }
        return this.fields[0];
    }

    public boolean firstFieldMatches(SootField field) {
        if (this.fields == null || this.fields.length == 0) {
            return false;
        }
        return field == this.fields[0];
    }

    public Type getFirstFieldType() {
        if (this.fieldTypes == null || this.fieldTypes.length == 0) {
            return null;
        }
        return this.fieldTypes[0];
    }

    public SootField[] getFields() {
        return this.fields;
    }

    public Type[] getFieldTypes() {
        return this.fieldTypes;
    }

    public int getFieldCount() {
        return this.fields == null ? 0 : this.fields.length;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        result = 31 * result + (this.fields == null ? 0 : Arrays.hashCode(this.fields));
        result = 31 * result + (this.fieldTypes == null ? 0 : Arrays.hashCode(this.fieldTypes));
        result = 31 * result + (this.taintSubFields ? 1 : 0);
        result = 31 * result + this.arrayTaintType.hashCode();
        this.hashCode = result = 31 * result + (this.canHaveImmutableAliases ? 1 : 0);
        return this.hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this || super.equals(obj)) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (!Arrays.equals(this.fields, other.fields)) {
            return false;
        }
        if (!Arrays.equals(this.fieldTypes, other.fieldTypes)) {
            return false;
        }
        if (this.taintSubFields != other.taintSubFields) {
            return false;
        }
        if (this.arrayTaintType != other.arrayTaintType) {
            return false;
        }
        if (this.canHaveImmutableAliases != other.canHaveImmutableAliases) {
            return false;
        }
        assert (this.hashCode() == obj.hashCode());
        return true;
    }

    public boolean isStaticFieldRef() {
        return this.value == null && this.fields != null && this.fields.length > 0;
    }

    public boolean isInstanceFieldRef() {
        return this.value != null && this.fields != null && this.fields.length > 0;
    }

    public boolean isFieldRef() {
        return this.fields != null && this.fields.length > 0;
    }

    public boolean isLocal() {
        return this.value != null && this.value instanceof Local && (this.fields == null || this.fields.length == 0);
    }

    public String toString() {
        String str = "";
        if (this.value != null) {
            str = str + this.value.toString() + "(" + this.value.getType() + ")";
        }
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null) continue;
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + this.fields[i];
            }
        }
        if (this.taintSubFields) {
            str = str + " *";
        }
        if (this.arrayTaintType == ArrayTaintType.ContentsAndLength) {
            str = str + " <+length>";
        } else if (this.arrayTaintType == ArrayTaintType.Length) {
            str = str + " <length>";
        }
        return str;
    }

    public AccessPath clone() {
        if (this == emptyAccessPath) {
            return this;
        }
        AccessPath a = new AccessPath(this.value, this.fields, this.baseType, this.fieldTypes, this.taintSubFields, this.cutOffApproximation, this.arrayTaintType, this.canHaveImmutableAliases);
        assert (a.equals(this));
        return a;
    }

    public static AccessPath getEmptyAccessPath() {
        return emptyAccessPath;
    }

    public boolean isEmpty() {
        return this.value == null && (this.fields == null || this.fields.length == 0);
    }

    public boolean entails(AccessPath a2) {
        if (this.isEmpty() || a2.isEmpty()) {
            return false;
        }
        if (this.value != null && a2.value == null || this.value == null && a2.value != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(a2.value)) {
            return false;
        }
        if (this.fields != null && a2.fields != null) {
            if (this.fields.length > a2.fields.length) {
                return false;
            }
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i].equals(a2.fields[i])) continue;
                return false;
            }
        }
        return true;
    }

    public AccessPath dropLastField() {
        Type[] newTypes;
        SootField[] newFields;
        if (this.fields == null || this.fields.length == 0) {
            return this;
        }
        if (this.fields.length > 1) {
            newFields = new SootField[this.fields.length - 1];
            System.arraycopy(this.fields, 0, newFields, 0, this.fields.length - 1);
            newTypes = new Type[this.fields.length - 1];
            System.arraycopy(this.fieldTypes, 0, newTypes, 0, this.fields.length - 1);
        } else {
            newFields = null;
            newTypes = null;
        }
        return new AccessPath(this.value, newFields, this.baseType, newTypes, this.taintSubFields, this.cutOffApproximation, this.arrayTaintType, this.canHaveImmutableAliases);
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public boolean getTaintSubFields() {
        return this.taintSubFields;
    }

    public boolean isCutOffApproximation() {
        return this.cutOffApproximation;
    }

    public ArrayTaintType getArrayTaintType() {
        return this.arrayTaintType;
    }

    public boolean startsWith(Value val) {
        if (!AccessPath.canContainValue(val)) {
            return false;
        }
        if (val instanceof Local && this.value == val) {
            return true;
        }
        if (val instanceof StaticFieldRef) {
            return this.value == null && this.fields != null && this.fields.length > 0 && this.fields[0] == ((StaticFieldRef)val).getField();
        }
        if (val instanceof InstanceFieldRef) {
            InstanceFieldRef iref = (InstanceFieldRef)val;
            return this.value == iref.getBase() && this.fields != null && this.fields.length > 0 && this.fields[0] == iref.getField();
        }
        return false;
    }

    public boolean getCanHaveImmutableAliases() {
        return this.canHaveImmutableAliases;
    }

    static AccessPath getZeroAccessPath() {
        if (zeroAccessPath == null) {
            zeroAccessPath = new AccessPath(Jimple.v().newLocal("zero", NullType.v()), null, NullType.v(), null, false, false, ArrayTaintType.ContentsAndLength, false);
        }
        return zeroAccessPath;
    }

    public static enum ArrayTaintType {
        Contents,
        Length,
        ContentsAndLength;

    }
}

