/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.util.extensiblelist.ExtensibleList;

public class SourceContextAndPath
extends SourceContext
implements Cloneable {
    protected ExtensibleList<Abstraction> path = null;
    protected ExtensibleList<Stmt> callStack = null;
    protected int neighborCounter = 0;
    private int hashCode = 0;

    public SourceContextAndPath(ISourceSinkDefinition definition, AccessPath value, Stmt stmt) {
        this(definition, value, stmt, null);
    }

    public SourceContextAndPath(ISourceSinkDefinition definition, AccessPath value, Stmt stmt, Object userData) {
        super(definition, value, stmt, userData);
    }

    public List<Stmt> getPath() {
        if (this.path == null) {
            return Collections.emptyList();
        }
        ArrayList<Stmt> stmtPath = new ArrayList<Stmt>(this.path.size());
        ExtensibleList.ExtensibleListIterator<Abstraction> it = this.path.reverseIterator();
        while (it.hasNext()) {
            Abstraction abs = (Abstraction)it.next();
            if (abs.getCurrentStmt() == null) continue;
            stmtPath.add(abs.getCurrentStmt());
        }
        return stmtPath;
    }

    public List<Abstraction> getAbstractionPath() {
        if (this.path == null) {
            return null;
        }
        ArrayList<Abstraction> reversePath = new ArrayList<Abstraction>(this.path.size());
        ExtensibleList.ExtensibleListIterator<Abstraction> it = this.path.reverseIterator();
        while (it.hasNext()) {
            reversePath.add((Abstraction)it.next());
        }
        return reversePath;
    }

    public SourceContextAndPath extendPath(Abstraction abs) {
        return this.extendPath(abs, null);
    }

    public SourceContextAndPath extendPath(Abstraction abs, InfoflowConfiguration.PathConfiguration pathConfig) {
        boolean trackPath;
        if (abs == null) {
            return this;
        }
        if (abs.getCurrentStmt() == null && abs.getCorrespondingCallSite() == null) {
            return this;
        }
        boolean bl = trackPath = pathConfig == null ? true : pathConfig.getPathReconstructionMode().reconstructPaths();
        if (abs.getCorrespondingCallSite() == null && !trackPath) {
            return this;
        }
        if (this.path != null) {
            ExtensibleList.ExtensibleListIterator<Abstraction> it = this.path.reverseIterator();
            while (it.hasNext()) {
                Abstraction a = (Abstraction)it.next();
                if (a != abs) continue;
                return null;
            }
        }
        SourceContextAndPath scap = null;
        if (trackPath && abs.getCurrentStmt() != null) {
            Abstraction topAbs;
            if (this.path != null && (topAbs = this.path.getLast()).equals(abs) && topAbs.getCorrespondingCallSite() != null && topAbs.getCorrespondingCallSite() == abs.getCorrespondingCallSite() && topAbs.getCurrentStmt() != abs.getCurrentStmt()) {
                return null;
            }
            scap = this.clone();
            if (scap.path == null) {
                scap.path = new ExtensibleList();
            }
            scap.path.add(abs);
            if (pathConfig != null && pathConfig.getMaxPathLength() > 0 && scap.path.size() > pathConfig.getMaxPathLength()) {
                return null;
            }
        }
        if (abs.getCorrespondingCallSite() != null && abs.getCorrespondingCallSite() != abs.getCurrentStmt()) {
            if (scap == null) {
                scap = this.clone();
            }
            if (scap.callStack == null) {
                scap.callStack = new ExtensibleList();
            } else if (pathConfig != null && pathConfig.getMaxCallStackSize() > 0 && scap.callStack.size() >= pathConfig.getMaxCallStackSize()) {
                return null;
            }
            scap.callStack.add(abs.getCorrespondingCallSite());
        }
        this.neighborCounter = abs.getNeighbors() == null ? 0 : abs.getNeighbors().size();
        return scap == null ? this : scap;
    }

    public Pair<SourceContextAndPath, Stmt> popTopCallStackItem() {
        if (this.callStack == null || this.callStack.isEmpty()) {
            return null;
        }
        SourceContextAndPath scap = this.clone();
        Stmt lastStmt = null;
        Object c = scap.callStack.removeLast();
        if (c instanceof ExtensibleList) {
            lastStmt = scap.callStack.getLast();
            scap.callStack = (ExtensibleList)c;
        } else {
            lastStmt = (Stmt)c;
        }
        if (scap.callStack.isEmpty()) {
            scap.callStack = null;
        }
        return new Pair<SourceContextAndPath, Stmt>(scap, lastStmt);
    }

    public boolean isCallStackEmpty() {
        return this.callStack == null || this.callStack.isEmpty();
    }

    public void setNeighborCounter(int counter) {
        this.neighborCounter = counter;
    }

    public int getNeighborCounter() {
        return this.neighborCounter;
    }

    @Override
    public boolean equals(Object other) {
        boolean mergeDifferentPaths;
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof SourceContextAndPath)) {
            return false;
        }
        SourceContextAndPath scap = (SourceContextAndPath)other;
        if (this.hashCode != 0 && scap.hashCode != 0 && this.hashCode != scap.hashCode) {
            return false;
        }
        boolean bl = mergeDifferentPaths = !InfoflowConfiguration.getPathAgnosticResults() && this.path != null && scap.path != null;
        if (mergeDifferentPaths && this.path.size() != scap.path.size()) {
            return false;
        }
        if (this.callStack == null || this.callStack.isEmpty()) {
            if (scap.callStack != null && !scap.callStack.isEmpty()) {
                return false;
            }
        } else {
            if (scap.callStack == null || scap.callStack.isEmpty()) {
                return false;
            }
            if (this.callStack.size() != scap.callStack.size() || !this.callStack.equals(scap.callStack)) {
                return false;
            }
        }
        if (mergeDifferentPaths && !this.path.equals(scap.path)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = super.hashCode();
        if (!InfoflowConfiguration.getPathAgnosticResults()) {
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        }
        this.hashCode = result = 31 * result + (this.callStack == null ? 0 : this.callStack.hashCode());
        return this.hashCode;
    }

    @Override
    public SourceContextAndPath clone() {
        SourceContextAndPath scap = new SourceContextAndPath(this.definition, this.accessPath, this.stmt, this.userData);
        if (this.path != null) {
            scap.path = new ExtensibleList<Abstraction>(this.path);
        }
        if (this.callStack != null) {
            scap.callStack = new ExtensibleList<Stmt>(this.callStack);
        }
        return scap;
    }

    @Override
    public String toString() {
        return super.toString() + "\n\ton Path: " + this.getAbstractionPath();
    }
}

