/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.Pair;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMultiMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.ConcurrentAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class ContextSensitivePathBuilder
extends ConcurrentAbstractionPathBuilder {
    protected ConcurrentIdentityHashMultiMap<Abstraction, SourceContextAndPath> pathCache = new ConcurrentIdentityHashMultiMap();

    public ContextSensitivePathBuilder(InfoflowManager manager) {
        super(manager, ContextSensitivePathBuilder.createExecutor(manager));
    }

    private static InterruptableExecutor createExecutor(InfoflowManager manager) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        int mtn = manager.getConfig().getMaxThreadNum();
        InterruptableExecutor executor = new InterruptableExecutor(mtn == -1 ? numThreads : Math.min(mtn, numThreads), Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>());
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Path reconstruction");
            }
        });
        return executor;
    }

    protected boolean checkForSource(Abstraction abs, SourceContextAndPath scap) {
        if (abs.getPredecessor() != null) {
            return false;
        }
        assert (abs.getSourceContext() != null);
        if (abs.getNeighbors() != null) {
            // empty if block
        }
        SourceContext sourceContext = abs.getSourceContext();
        Pair<ResultSourceInfo, ResultSinkInfo> newResult = this.results.addResult(scap.getDefinition(), scap.getAccessPath(), scap.getStmt(), sourceContext.getDefinition(), sourceContext.getAccessPath(), sourceContext.getStmt(), sourceContext.getUserData(), scap.getAbstractionPath());
        if (this.resultAvailableHandlers != null) {
            for (IAbstractionPathBuilder.OnPathBuilderResultAvailable handler : this.resultAvailableHandlers) {
                handler.onResultAvailable(newResult.getO1(), newResult.getO2());
            }
        }
        return true;
    }

    @Override
    public void runIncrementalPathCompuation() {
        HashSet<AbstractionAtSink> incrementalAbs = new HashSet<AbstractionAtSink>();
        for (Abstraction abs : this.pathCache.keySet()) {
            for (SourceContextAndPath scap : this.pathCache.get(abs)) {
                if (abs.getNeighbors() == null || abs.getNeighbors().size() == scap.getNeighborCounter()) continue;
                scap.setNeighborCounter(abs.getNeighbors().size());
                for (Abstraction neighbor : abs.getNeighbors()) {
                    incrementalAbs.add(new AbstractionAtSink(scap.getDefinition(), neighbor, scap.getStmt()));
                }
            }
        }
        if (!incrementalAbs.isEmpty()) {
            this.computeTaintPaths(incrementalAbs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        try {
            super.computeTaintPaths(res);
            long pathTimeout = this.manager.getConfig().getPathConfiguration().getPathReconstructionTimeout();
            if (pathTimeout > 0L) {
                this.executor.awaitCompletion(pathTimeout + 20L, TimeUnit.SECONDS);
            } else {
                this.executor.awaitCompletion();
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Could not wait for executor termination", e);
        }
        finally {
            this.onTaintPathsComputed();
        }
    }

    protected void onTaintPathsComputed() {
        this.shutdown();
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    protected Runnable getTaintPathTask(AbstractionAtSink abs) {
        SourceContextAndPath scap = new SourceContextAndPath(abs.getSinkDefinition(), abs.getAbstraction().getAccessPath(), abs.getSinkStmt());
        scap = scap.extendPath(abs.getAbstraction(), this.pathConfig);
        if (this.pathCache.put(abs.getAbstraction(), scap) && !this.checkForSource(abs.getAbstraction(), scap)) {
            return new SourceFindingTask(abs.getAbstraction());
        }
        return null;
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    protected boolean triggerComputationForNeighbors() {
        return true;
    }

    protected class SourceFindingTask
    implements Runnable,
    Comparable<SourceFindingTask> {
        private final Abstraction abstraction;

        public SourceFindingTask(Abstraction abstraction) {
            this.abstraction = abstraction;
        }

        @Override
        public void run() {
            Set<SourceContextAndPath> paths = ContextSensitivePathBuilder.this.pathCache.get(this.abstraction);
            Abstraction pred = this.abstraction.getPredecessor();
            if (pred != null && paths != null) {
                for (SourceContextAndPath scap : paths) {
                    if (this.processPredecessor(scap, pred)) {
                        ContextSensitivePathBuilder.this.scheduleDependentTask(new SourceFindingTask(pred));
                    }
                    if (pred.getNeighbors() == null) continue;
                    for (Abstraction neighbor : pred.getNeighbors()) {
                        if (!this.processPredecessor(scap, neighbor)) continue;
                        ContextSensitivePathBuilder.this.scheduleDependentTask(new SourceFindingTask(neighbor));
                    }
                }
            }
        }

        private boolean processPredecessor(SourceContextAndPath scap, Abstraction pred) {
            Set<SourceContextAndPath> existingPaths;
            Pair<SourceContextAndPath, Stmt> pathAndItem;
            if (pred.getCurrentStmt() != null && pred.getCurrentStmt() == pred.getCorrespondingCallSite()) {
                SourceContextAndPath extendedScap = scap.extendPath(pred, ContextSensitivePathBuilder.this.pathConfig);
                if (extendedScap == null) {
                    return false;
                }
                ContextSensitivePathBuilder.this.checkForSource(pred, extendedScap);
                return ContextSensitivePathBuilder.this.pathCache.put(pred, extendedScap);
            }
            SourceContextAndPath extendedScap = scap.extendPath(pred, ContextSensitivePathBuilder.this.pathConfig);
            if (extendedScap == null) {
                return false;
            }
            if (pred.getCurrentStmt() != null && pred.getCurrentStmt().containsInvokeExpr() && (pathAndItem = extendedScap.popTopCallStackItem()) != null) {
                Stmt topCallStackItem = pathAndItem.getO2();
                if (topCallStackItem != pred.getCurrentStmt()) {
                    return false;
                }
                extendedScap = pathAndItem.getO1();
            }
            ContextSensitivePathBuilder.this.checkForSource(pred, extendedScap);
            int maxPaths = ContextSensitivePathBuilder.this.pathConfig.getMaxPathsPerAbstraction();
            if (maxPaths > 0 && (existingPaths = ContextSensitivePathBuilder.this.pathCache.get(pred)) != null && existingPaths.size() > maxPaths) {
                return false;
            }
            return ContextSensitivePathBuilder.this.pathCache.put(pred, extendedScap);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.abstraction == null ? 0 : this.abstraction.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceFindingTask other = (SourceFindingTask)obj;
            return this.abstraction == other.abstraction;
        }

        @Override
        public int compareTo(SourceFindingTask arg0) {
            return Integer.compare(this.abstraction.getPathLength(), arg0.abstraction.getPathLength());
        }
    }
}

