/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.pathBuilders.BatchPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.ContextInsensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.ContextInsensitiveSourceFinder;
import soot.jimple.infoflow.data.pathBuilders.ContextSensitivePathBuilder;
import soot.jimple.infoflow.data.pathBuilders.EmptyPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.RecursivePathBuilder;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class DefaultPathBuilderFactory
implements IPathBuilderFactory {
    private final InfoflowConfiguration.PathConfiguration pathConfiguration;

    public DefaultPathBuilderFactory(InfoflowConfiguration.PathConfiguration config) {
        this.pathConfiguration = config;
    }

    private InterruptableExecutor createExecutor(int maxThreadNum) {
        int numThreads = Runtime.getRuntime().availableProcessors();
        InterruptableExecutor executor = new InterruptableExecutor(maxThreadNum == -1 ? numThreads : Math.min(maxThreadNum, numThreads), Integer.MAX_VALUE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thr = new Thread(r, "Path reconstruction");
                return thr;
            }
        });
        return executor;
    }

    @Override
    public IAbstractionPathBuilder createPathBuilder(InfoflowManager manager, int maxThreadNum) {
        return this.createPathBuilder(manager, this.createExecutor(maxThreadNum));
    }

    @Override
    public IAbstractionPathBuilder createPathBuilder(InfoflowManager manager, InterruptableExecutor executor) {
        switch (this.pathConfiguration.getPathBuildingAlgorithm()) {
            case Recursive: {
                return new BatchPathBuilder(manager, new RecursivePathBuilder(manager, executor));
            }
            case ContextSensitive: {
                return new ShutdownBatchPathBuilder(manager, new RepeatableContextSensitivePathBuilder(manager));
            }
            case ContextInsensitive: {
                return new BatchPathBuilder(manager, new ContextInsensitivePathBuilder(manager, executor));
            }
            case ContextInsensitiveSourceFinder: {
                return new BatchPathBuilder(manager, new ContextInsensitiveSourceFinder(manager, executor));
            }
            case None: {
                return new EmptyPathBuilder();
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    @Override
    public boolean supportsPathReconstruction() {
        switch (this.pathConfiguration.getPathBuildingAlgorithm()) {
            case Recursive: 
            case ContextSensitive: 
            case ContextInsensitive: {
                return true;
            }
            case ContextInsensitiveSourceFinder: 
            case None: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported path building algorithm");
    }

    @Override
    public boolean isContextSensitive() {
        return this.pathConfiguration.getPathBuildingAlgorithm() == InfoflowConfiguration.PathBuildingAlgorithm.ContextSensitive;
    }

    private static class ShutdownBatchPathBuilder
    extends BatchPathBuilder {
        public ShutdownBatchPathBuilder(InfoflowManager manager, RepeatableContextSensitivePathBuilder innerBuilder) {
            super(manager, innerBuilder);
        }

        @Override
        public void computeTaintPaths(Set<AbstractionAtSink> res) {
            try {
                super.computeTaintPaths(res);
            }
            finally {
                ((RepeatableContextSensitivePathBuilder)this.innerBuilder).shutdown();
            }
        }
    }

    private static class RepeatableContextSensitivePathBuilder
    extends ContextSensitivePathBuilder {
        public RepeatableContextSensitivePathBuilder(InfoflowManager manager) {
            super(manager);
        }

        @Override
        protected void onTaintPathsComputed() {
        }
    }
}

