/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.TypeUtils;

public class BackwardsInfoflowProblem
extends AbstractInfoflowProblem {
    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public BackwardsInfoflowProblem(InfoflowManager manager) {
        super(manager);
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef() ? abs.getAccessPath().getBaseType() instanceof PrimType : abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                    return null;
                }
                return abs;
            }

            /*
             * WARNING - void declaration
             */
            private Set<Abstraction> computeAliases(DefinitionStmt defStmt, Value leftValue, Abstraction d1, Abstraction source) {
                boolean bl;
                assert (!source.getAccessPath().isEmpty());
                if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                    return null;
                }
                MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                boolean leftSideMatches = Aliasing.baseMatches(leftValue, source);
                if (!leftSideMatches) {
                    res.add(source);
                } else {
                    for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                        BackwardsInfoflowProblem.this.manager.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, source));
                    }
                }
                if (defStmt instanceof IdentityStmt) {
                    res.add(source);
                    return res;
                }
                if (!(defStmt instanceof AssignStmt)) {
                    return res;
                }
                Value rightValue = BaseSelector.selectBase(defStmt.getRightOp(), false);
                if (leftSideMatches && !(rightValue instanceof Local) && !(rightValue instanceof FieldRef)) {
                    res.add(source);
                    return res;
                }
                if (rightValue instanceof Constant) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof NewArrayExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof BinopExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof UnopExpr) {
                    return res;
                }
                boolean bl2 = bl = Aliasing.baseMatchesStrict(rightValue, source) && rightValue.getType() instanceof RefType && !source.dependsOnCutAP();
                if (!bl && !(rightValue.getType() instanceof PrimType)) {
                    FieldRef ref;
                    Abstraction newLeftAbs = null;
                    if (rightValue instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)rightValue;
                        if (source.getAccessPath().isInstanceFieldRef() && ref.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                            AccessPath accessPath = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getFirstFieldType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                        }
                    } else if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && rightValue instanceof StaticFieldRef) {
                        ref = (StaticFieldRef)rightValue;
                        if (source.getAccessPath().isStaticFieldRef() && source.getAccessPath().firstFieldMatches(((StaticFieldRef)ref).getField())) {
                            AccessPath accessPath = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getBaseType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                        }
                    } else if (rightValue == source.getAccessPath().getPlainValue()) {
                        Object newType = source.getAccessPath().getBaseType();
                        if (leftValue instanceof ArrayRef) {
                            ArrayRef arrayRef = (ArrayRef)leftValue;
                            newType = TypeUtils.buildArrayOrAddDimension((Type)newType, arrayRef.getType().getArrayType());
                        } else if (defStmt.getRightOp() instanceof ArrayRef) {
                            newType = newType instanceof ArrayType ? ((ArrayType)newType).getElementType() : null;
                        } else if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), leftValue.getType())) {
                            return null;
                        }
                        if (defStmt.getRightOp() instanceof CastExpr) {
                            CastExpr castExpr = (CastExpr)defStmt.getRightOp();
                            if (!BackwardsInfoflowProblem.this.manager.getHierarchy().canStoreType((Type)newType, castExpr.getCastType())) {
                                newType = castExpr.getCastType();
                            }
                        } else {
                            if (defStmt.getRightOp() instanceof LengthExpr) {
                                return res;
                            }
                            if (defStmt.getRightOp() instanceof InstanceOfExpr) {
                                return res;
                            }
                        }
                        AccessPath accessPath = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, (Type)newType, false);
                        newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                    }
                    if (newLeftAbs != null) {
                        if (newLeftAbs.getAccessPath().getLastFieldType() instanceof PrimType) {
                            return res;
                        }
                        if (!newLeftAbs.getAccessPath().equals(source.getAccessPath())) {
                            res.add(newLeftAbs);
                            for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                BackwardsInfoflowProblem.this.manager.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newLeftAbs));
                            }
                        }
                    }
                }
                if ((rightValue instanceof Local || rightValue instanceof FieldRef) && !(leftValue.getType() instanceof PrimType)) {
                    boolean addRightValue = false;
                    boolean cutFirstField = false;
                    Object var11_23 = null;
                    if (leftValue instanceof InstanceFieldRef) {
                        InstanceFieldRef leftRef;
                        if (source.getAccessPath().isInstanceFieldRef() && (leftRef = (InstanceFieldRef)leftValue).getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(leftRef.getField())) {
                            Type type = source.getAccessPath().getFirstFieldType();
                            addRightValue = true;
                            cutFirstField = true;
                        }
                    } else if (leftValue instanceof Local && source.getAccessPath().isInstanceFieldRef()) {
                        Local base = source.getAccessPath().getPlainValue();
                        if (leftValue == base) {
                            Type type = source.getAccessPath().getBaseType();
                            addRightValue = true;
                        }
                    } else if (leftValue instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)leftValue;
                        Local leftBase = (Local)ar.getBase();
                        if (leftBase == source.getAccessPath().getPlainValue()) {
                            addRightValue = true;
                            Type type = source.getAccessPath().getBaseType();
                        }
                    } else if (leftValue == source.getAccessPath().getPlainValue()) {
                        if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), defStmt.getRightOp().getType())) {
                            return null;
                        }
                        addRightValue = true;
                        Type type = source.getAccessPath().getBaseType();
                    }
                    if (addRightValue) {
                        AccessPath ap;
                        Abstraction newAbs;
                        void var11_39;
                        void var11_31;
                        if (var11_31 != null) {
                            if (defStmt.getRightOp() instanceof ArrayRef) {
                                ArrayRef arrayRef = (ArrayRef)defStmt.getRightOp();
                                Type type = TypeUtils.buildArrayOrAddDimension((Type)var11_31, arrayRef.getType().getArrayType());
                            } else if (leftValue instanceof ArrayRef) {
                                void var11_36;
                                if (TypeUtils.isObjectLikeType((Type)var11_31)) {
                                    Type type = rightValue.getType();
                                } else if (var11_31 instanceof ArrayType) {
                                    Type type = ((ArrayType)var11_31).getElementType();
                                } else {
                                    Object var11_35 = null;
                                }
                                if (var11_36 != null && !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_36)) {
                                    addRightValue = false;
                                }
                            }
                        }
                        if (defStmt.getRightOp() instanceof LengthExpr) {
                            Object var11_38 = null;
                        }
                        if ((var11_39 instanceof PrimType || var11_39 instanceof ArrayType && ((ArrayType)var11_39).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if ((rightValue.getType() instanceof PrimType || rightValue.getType() instanceof ArrayType && ((ArrayType)rightValue.getType()).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if (addRightValue && !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_39)) {
                            addRightValue = false;
                        }
                        if (addRightValue && rightValue instanceof StaticFieldRef && BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None) {
                            addRightValue = false;
                        }
                        if (addRightValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rightValue, (Type)var11_39, cutFirstField), defStmt))) != null && !newAbs.getAccessPath().equals(source.getAccessPath())) {
                            if (rightValue instanceof StaticFieldRef && BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                BackwardsInfoflowProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                            } else {
                                res.add(newAbs);
                                for (Unit unit : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                    BackwardsInfoflowProblem.this.manager.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newAbs));
                                }
                            }
                        }
                    }
                }
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, Unit dest) {
                if (src instanceof DefinitionStmt) {
                    final DefinitionStmt defStmt = (DefinitionStmt)src;
                    final Value leftValue = BaseSelector.selectBase(defStmt.getLeftOp(), true);
                    final DefinitionStmt destDefStmt = dest instanceof DefinitionStmt ? (DefinitionStmt)dest : null;
                    final Value destLeftValue = destDefStmt == null ? null : BaseSelector.selectBase(destDefStmt.getLeftOp(), true);
                    return new SolverNormalFlowFunction(){

                        @Override
                        public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                            if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                                return null;
                            }
                            assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                            if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                                BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(src, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                            }
                            Set res = this.computeAliases(defStmt, leftValue, d1, source);
                            if (destDefStmt != null && res != null && !res.isEmpty() && BackwardsInfoflowProblem.this.interproceduralCFG().isExitStmt(destDefStmt)) {
                                for (Abstraction abs : res) {
                                    this.computeAliases(destDefStmt, destLeftValue, d1, abs);
                                }
                            }
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                    };
                }
                return Identity.v();
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                boolean isSource;
                if (!dest.isConcrete()) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final boolean isReflectiveCallSite = BackwardsInfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                final Value[] paramLocals = new Value[dest.getParameterCount()];
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals[i] = dest.getActiveBody().getParameterLocal(i);
                }
                boolean bl = BackwardsInfoflowProblem.this.manager.getSourceSinkManager() != null ? BackwardsInfoflowProblem.this.manager.getSourceSinkManager().getSourceInfo((Stmt)src, BackwardsInfoflowProblem.this.manager) != null : (isSource = false);
                final boolean isSink = BackwardsInfoflowProblem.this.manager.getSourceSinkManager() != null ? BackwardsInfoflowProblem.this.manager.getSourceSinkManager().getSinkInfo(stmt, BackwardsInfoflowProblem.this.manager, null) != null : false;
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, dest);
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Abstraction abs;
                        DefinitionStmt defnStmt;
                        Value leftOp;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.isCallSiteActivatingTaint(stmt, source.getActivationUnit())) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.taintWrapper != null && BackwardsInfoflowProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (src instanceof DefinitionStmt && (leftOp = (defnStmt = (DefinitionStmt)src).getLeftOp()) == source.getAccessPath().getPlainValue()) {
                            for (Unit u : dest.getActiveBody().getUnits()) {
                                AccessPath ap;
                                Abstraction abs2;
                                ReturnStmt rStmt;
                                if (!(u instanceof ReturnStmt) || !((rStmt = (ReturnStmt)u).getOp() instanceof Local) && !(rStmt.getOp() instanceof FieldRef) || !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), rStmt.getOp().getType()) || (abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rStmt.getOp(), null, false), (Stmt)src))) == null) continue;
                                res.add(abs2);
                            }
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), stmt))) != null) {
                            res.add(abs);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        if (!(isExecutorExecute || source.getAccessPath().isStaticFieldRef() || dest.isStatic())) {
                            Value callBase;
                            InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
                            Value value = callBase = isReflectiveCallSite ? iIExpr.getArg(0) : iIExpr.getBase();
                            if (callBase == sourceBase && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass())) {
                                AccessPath ap;
                                Abstraction abs3;
                                boolean param = false;
                                if (!isReflectiveCallSite) {
                                    for (int i = 0; i < dest.getParameterCount(); ++i) {
                                        if (stmt.getInvokeExpr().getArg(i) != sourceBase) continue;
                                        param = true;
                                        break;
                                    }
                                }
                                if (!param && (abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal), (Stmt)src))) != null) {
                                    res.add(abs3);
                                }
                            }
                        }
                        if (isExecutorExecute) {
                            AccessPath ap;
                            Abstraction abs4;
                            if (ie.getArg(0) == source.getAccessPath().getPlainValue() && (abs4 = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal), stmt))) != null) {
                                res.add(abs4);
                            }
                        } else if (ie != null && dest.getParameterCount() > 0) {
                            int i;
                            assert (dest.getParameterCount() == ie.getArgCount());
                            int n = i = isReflectiveCallSite ? 1 : 0;
                            while (i < ie.getArgCount()) {
                                if (ie.getArg(i) == source.getAccessPath().getPlainValue()) {
                                    if (isReflectiveCallSite) {
                                        int j = 0;
                                        while (i < paramLocals.length) {
                                            AccessPath ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[j], null, false);
                                            Abstraction abs5 = this.checkAbstraction(source.deriveNewAbstraction(ap, stmt));
                                            if (abs5 != null) {
                                                res.add(abs5);
                                            }
                                            ++i;
                                        }
                                    } else {
                                        AccessPath ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[i]);
                                        Abstraction abs6 = this.checkAbstraction(source.deriveNewAbstraction(ap, stmt));
                                        if (abs6 != null) {
                                            res.add(abs6);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        if (res != null && !res.isEmpty()) {
                            for (Abstraction d3 : res) {
                                BackwardsInfoflowProblem.this.manager.getForwardSolver().injectContext(BackwardsInfoflowProblem.this.solver, dest, d3, src, source, d1);
                            }
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final boolean isReflectiveCallSite = BackwardsInfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsInfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (callSite == null) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, source);
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (isExecutorExecute) {
                            AccessPath ap;
                            Abstraction abs;
                            if (source.getAccessPath().getPlainValue() == thisLocal && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), ie.getArg(0)), (Stmt)exitStmt))) != null) {
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                        } else {
                            Stmt stmt2;
                            boolean parameterAliases = false;
                            for (int i = 0; i < paramLocals.length; ++i) {
                                AccessPath ap;
                                Abstraction abs;
                                Value originalCallArg;
                                if (paramLocals[i] != sourceBase) continue;
                                parameterAliases = true;
                                if (!(callSite instanceof Stmt) || !AccessPath.canContainValue(originalCallArg = ie.getArg(isReflectiveCallSite ? 1 : i)) || !isReflectiveCallSite && !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || BackwardsInfoflowProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) == null) continue;
                                res.add(abs);
                                BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                            if (!callee.isStatic() && thisLocal == sourceBase && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && !parameterAliases && callSite instanceof Stmt && (stmt2 = (Stmt)callSite).getInvokeExpr() instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt2.getInvokeExpr();
                                Value callerBaseLocal = BackwardsInfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(iIExpr) ? iIExpr.getArg(0) : iIExpr.getBase();
                                AccessPath ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), callerBaseLocal, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false);
                                Abstraction abs = this.checkAbstraction(source.deriveNewAbstraction(ap, (Stmt)exitStmt));
                                if (abs != null) {
                                    res.add(abs);
                                    BackwardsInfoflowProblem.this.registerActivationCallSite(callSite, callee, abs);
                                }
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == source) continue;
                            abs.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                final Stmt iStmt = (Stmt)call;
                InvokeExpr invExpr = iStmt.getInvokeExpr();
                final Value[] callArgs = new Value[iStmt.getInvokeExpr().getArgCount()];
                for (int i = 0; i < iStmt.getInvokeExpr().getArgCount(); ++i) {
                    callArgs[i] = iStmt.getInvokeExpr().getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final DefinitionStmt defStmt = iStmt instanceof DefinitionStmt ? (DefinitionStmt)iStmt : null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iinv;
                        Set<Abstraction> wrapperAliases;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || BackwardsInfoflowProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(call, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (BackwardsInfoflowProblem.this.taintWrapper != null && (wrapperAliases = BackwardsInfoflowProblem.this.taintWrapper.getAliasesForMethod(iStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                            HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                            for (Abstraction abs : wrapperAliases) {
                                if (defStmt == null || defStmt.getLeftOp() != abs.getAccessPath().getPlainValue()) {
                                    passOnSet.add(abs);
                                }
                                for (Unit u : BackwardsInfoflowProblem.this.interproceduralCFG().getPredsOf(call)) {
                                    BackwardsInfoflowProblem.this.manager.getForwardSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, u, abs));
                                }
                            }
                            return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, passOnSet, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        boolean mustPropagate = BackwardsInfoflowProblem.this.isExcluded(callee);
                        if (!(mustPropagate |= BackwardsInfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) && BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        if (iStmt instanceof DefinitionStmt && ((DefinitionStmt)iStmt).getLeftOp() == source.getAccessPath().getPlainValue()) {
                            return null;
                        }
                        if (!mustPropagate && iStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iinv = (InstanceInvokeExpr)iStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue() && !BackwardsInfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) {
                            return null;
                        }
                        if (!mustPropagate) {
                            for (int i = 0; i < callArgs.length; ++i) {
                                if (callArgs[i] != source.getAccessPath().getPlainValue()) continue;
                                return null;
                            }
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }
                };
            }
        };
    }
}

