/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.KillAll;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.BooleanType;
import soot.Local;
import soot.NullType;
import soot.PrimType;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.IPropagationRuleManagerFactory;
import soot.jimple.infoflow.problems.rules.PropagationRuleManager;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.TypeUtils;

public class InfoflowProblem
extends AbstractInfoflowProblem {
    private final PropagationRuleManager propagationRules;
    protected final TaintPropagationResults results;

    public InfoflowProblem(InfoflowManager manager, Abstraction zeroValue, IPropagationRuleManagerFactory ruleManagerFactory) {
        super(manager);
        this.zeroValue = zeroValue == null ? this.createZeroValue() : zeroValue;
        this.results = new TaintPropagationResults(manager);
        this.propagationRules = ruleManagerFactory.createRuleManager(manager, this.zeroValue, this.results);
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private void addTaintViaStmt(Abstraction d1, AssignStmt assignStmt, Abstraction source, Set<Abstraction> taintSet, boolean cutFirstField, SootMethod method, Type targetType) {
                Value leftValue = assignStmt.getLeftOp();
                Value rightValue = assignStmt.getRightOp();
                if (leftValue instanceof StaticFieldRef && InfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None) {
                    return;
                }
                Abstraction newAbs = null;
                if (!source.getAccessPath().isEmpty()) {
                    if (leftValue instanceof ArrayRef && targetType != null) {
                        ArrayRef arrayRef = (ArrayRef)leftValue;
                        targetType = TypeUtils.buildArrayOrAddDimension(targetType, arrayRef.getType().getArrayType());
                    }
                    if (rightValue instanceof CastExpr) {
                        CastExpr cast = (CastExpr)assignStmt.getRightOp();
                        targetType = cast.getType();
                    } else if (rightValue instanceof InstanceOfExpr) {
                        newAbs = source.deriveNewAbstraction(InfoflowProblem.this.manager.getAccessPathFactory().createAccessPath(leftValue, BooleanType.v(), true, AccessPath.ArrayTaintType.ContentsAndLength), assignStmt);
                    }
                } else assert (targetType == null);
                AccessPath.ArrayTaintType arrayTaintType = source.getAccessPath().getArrayTaintType();
                if (leftValue instanceof ArrayRef && InfoflowProblem.this.manager.getConfig().getEnableArraySizeTainting()) {
                    arrayTaintType = AccessPath.ArrayTaintType.Contents;
                }
                if (newAbs == null) {
                    if (source.getAccessPath().isEmpty()) {
                        newAbs = source.deriveNewAbstraction(InfoflowProblem.this.manager.getAccessPathFactory().createAccessPath(leftValue, true), assignStmt, true);
                    } else {
                        AccessPath ap = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, targetType, cutFirstField, true, arrayTaintType);
                        newAbs = source.deriveNewAbstraction(ap, assignStmt);
                    }
                }
                if (newAbs != null) {
                    if (leftValue instanceof StaticFieldRef && InfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                        InfoflowProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                    } else {
                        taintSet.add(newAbs);
                        Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                        if (aliasing != null && aliasing.canHaveAliases(assignStmt, leftValue, newAbs)) {
                            aliasing.computeAliases(d1, assignStmt, leftValue, taintSet, method, newAbs);
                        }
                    }
                }
            }

            private boolean hasValidCallees(Unit call) {
                Collection callees = InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call);
                for (SootMethod callee : callees) {
                    if (!callee.isConcrete()) continue;
                    return true;
                }
                return false;
            }

            private Set<Abstraction> createNewTaintOnAssignment(AssignStmt assignStmt, Value[] rightVals, Abstraction d1, Abstraction newSource) {
                boolean implicitTaint;
                Value leftValue = assignStmt.getLeftOp();
                Value rightValue = assignStmt.getRightOp();
                boolean addLeftValue = false;
                if (rightValue instanceof LengthExpr) {
                    return Collections.singleton(newSource);
                }
                boolean bl = implicitTaint = newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() != null;
                if (implicitTaint |= newSource.getAccessPath().isEmpty()) {
                    if ((d1 == null || d1.getAccessPath().isEmpty()) && !(leftValue instanceof FieldRef)) {
                        return Collections.singleton(newSource);
                    }
                    if (newSource.getAccessPath().isEmpty()) {
                        addLeftValue = true;
                    }
                }
                boolean aliasOverwritten = !addLeftValue && !newSource.isAbstractionActive() && Aliasing.baseMatchesStrict(rightValue, newSource) && rightValue.getType() instanceof RefType && !newSource.dependsOnCutAP();
                Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return null;
                }
                boolean cutFirstField = false;
                AccessPath mappedAP = newSource.getAccessPath();
                Type targetType = null;
                if (!addLeftValue && !aliasOverwritten) {
                    for (Value rightVal : rightVals) {
                        if (rightVal instanceof FieldRef) {
                            FieldRef rightRef = (FieldRef)rightVal;
                            if (rightRef instanceof InstanceFieldRef && ((InstanceFieldRef)rightRef).getBase().getType() instanceof NullType) {
                                return null;
                            }
                            mappedAP = aliasing.mayAlias(newSource.getAccessPath(), (Value)rightRef);
                            if (rightVal instanceof StaticFieldRef) {
                                if (InfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && mappedAP != null) {
                                    addLeftValue = true;
                                    cutFirstField = true;
                                }
                            } else if (rightVal instanceof InstanceFieldRef) {
                                Local rightBase = (Local)((InstanceFieldRef)rightRef).getBase();
                                Local sourceBase = newSource.getAccessPath().getPlainValue();
                                SootField rightField = rightRef.getField();
                                if (mappedAP != null) {
                                    addLeftValue = true;
                                    cutFirstField = mappedAP.getFieldCount() > 0 && mappedAP.getFirstField() == rightField;
                                } else if (aliasing.mayAlias(rightBase, (Value)sourceBase) && newSource.getAccessPath().getFieldCount() == 0 && newSource.getAccessPath().getTaintSubFields()) {
                                    addLeftValue = true;
                                    targetType = rightField.getType();
                                    if (mappedAP == null) {
                                        mappedAP = InfoflowProblem.this.manager.getAccessPathFactory().createAccessPath(rightBase, true);
                                    }
                                }
                            }
                        } else if (rightVal instanceof Local && newSource.getAccessPath().isInstanceFieldRef()) {
                            Local base = newSource.getAccessPath().getPlainValue();
                            if (aliasing.mayAlias(rightVal, (Value)base)) {
                                addLeftValue = true;
                                targetType = newSource.getAccessPath().getBaseType();
                            }
                        } else if (aliasing.mayAlias(rightVal, (Value)newSource.getAccessPath().getPlainValue()) && !(assignStmt.getRightOp() instanceof NewArrayExpr) && (InfoflowProblem.this.manager.getConfig().getEnableArraySizeTainting() || !(rightValue instanceof NewArrayExpr))) {
                            addLeftValue = true;
                            targetType = newSource.getAccessPath().getBaseType();
                        }
                        if (addLeftValue) break;
                    }
                }
                if (!addLeftValue) {
                    return null;
                }
                if (!newSource.isAbstractionActive() && (assignStmt.getLeftOp().getType() instanceof PrimType || TypeUtils.isStringType(assignStmt.getLeftOp().getType()) && !newSource.getAccessPath().getCanHaveImmutableAliases())) {
                    return Collections.singleton(newSource);
                }
                HashSet<Abstraction> res = new HashSet<Abstraction>();
                Abstraction targetAB = mappedAP.equals(newSource.getAccessPath()) ? newSource : newSource.deriveNewAbstraction(mappedAP, null);
                this.addTaintViaStmt(d1, assignStmt, targetAB, res, cutFirstField, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(assignStmt), targetType);
                res.add(newSource);
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, final Unit dest) {
                if (!(src instanceof Stmt)) {
                    return KillAll.v();
                }
                return new NotifyingNormalFlowFunction((Stmt)src){

                    @Override
                    public Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        Value right;
                        Value[] rightVals;
                        AssignStmt assignStmt;
                        Set resAssign;
                        Abstraction newSource = !source.isAbstractionActive() && src == source.getActivationUnit() ? source.getActiveCopy() : source;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set res = InfoflowProblem.this.propagationRules.applyNormalFlowFunction(d1, newSource, this.stmt, (Stmt)dest, killSource, killAll);
                        if (killAll.value) {
                            return Collections.emptySet();
                        }
                        if (src instanceof AssignStmt && (resAssign = this.createNewTaintOnAssignment(assignStmt = (AssignStmt)src, rightVals = BaseSelector.selectBaseList(right = assignStmt.getRightOp(), true), d1, newSource)) != null && !resAssign.isEmpty()) {
                            if (res != null) {
                                res.addAll(resAssign);
                                return res;
                            }
                            res = resAssign;
                        }
                        return res == null || res.isEmpty() ? Collections.emptySet() : res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    InfoflowProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)src, (Object)dest);
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        if (res != null && !res.isEmpty() && d1 != null) {
                            for (Abstraction abs : res) {
                                aliasing.getAliasingStrategy().injectCallingContext(abs, InfoflowProblem.this.solver, dest, src, source, d1);
                            }
                        }
                        return InfoflowProblem.this.notifyOutFlowHandlers(stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (InfoflowProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, InfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (!source.isAbstractionActive() && source.getActivationUnit() == src) {
                            source = source.getActiveCopy();
                        }
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyCallFlowFunction(d1, source, stmt, dest, killAll);
                        if (killAll.value) {
                            return null;
                        }
                        Set resMapping = this.mapAccessPathToCallee(dest, ie, paramLocals, thisLocal, source.getAccessPath());
                        if (resMapping == null) {
                            return res;
                        }
                        HashSet<Abstraction> resAbs = new HashSet<Abstraction>(resMapping.size());
                        if (res != null && !res.isEmpty()) {
                            resAbs.addAll(res);
                        }
                        for (AccessPath ap : resMapping) {
                            Abstraction newAbs;
                            if (ap == null || !aliasing.getAliasingStrategy().isLazyAnalysis() && !source.isImplicit() && !InfoflowProblem.this.interproceduralCFG().methodReadsValue(dest, ap.getPlainValue()) || (newAbs = source.deriveNewAbstraction(ap, stmt)) == null) continue;
                            resAbs.add(newAbs);
                        }
                        return resAbs;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, final Unit retSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)callSite;
                final boolean isReflectiveCallSite = callSite != null && InfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(callSite);
                final ReturnStmt returnStmt = exitStmt instanceof ReturnStmt ? (ReturnStmt)exitStmt : null;
                final Local[] paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        Set<Abstraction> res = this.computeTargetsInternal(source, callerD1s);
                        return InfoflowProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source, Collection<Abstraction> callerD1s) {
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(exitStmt, source, InfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        boolean callerD1sConditional = false;
                        for (Abstraction d1 : callerD1s) {
                            if (!d1.getAccessPath().isEmpty()) continue;
                            callerD1sConditional = true;
                            break;
                        }
                        Abstraction newSource = source;
                        if (!source.isAbstractionActive() && callSite != null && (callSite == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(callSite, source.getActivationUnit()))) {
                            newSource = source.getActiveCopy();
                        }
                        if (!newSource.isAbstractionActive() && newSource.getActivationUnit() != null && InfoflowProblem.this.interproceduralCFG().getMethodOf(newSource.getActivationUnit()) == callee) {
                            return null;
                        }
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyReturnFlowFunction(callerD1s, newSource, (Stmt)exitStmt, (Stmt)retSite, (Stmt)callSite, killAll);
                        if (killAll.value) {
                            return null;
                        }
                        if (res == null) {
                            res = new HashSet<Abstraction>();
                        }
                        if (callSite == null) {
                            return null;
                        }
                        if (aliasing.getAliasingStrategy().isLazyAnalysis() && Aliasing.canHaveAliases(newSource.getAccessPath())) {
                            res.add(newSource);
                        }
                        if (!newSource.getAccessPath().isStaticFieldRef() && !callee.isStaticInitializer()) {
                            DefinitionStmt defnStmt;
                            Value leftOp;
                            if (returnStmt != null && callSite instanceof DefinitionStmt) {
                                AccessPath ap;
                                Abstraction abs;
                                Value retLocal = returnStmt.getOp();
                                DefinitionStmt defnStmt2 = (DefinitionStmt)callSite;
                                Value leftOp2 = defnStmt2.getLeftOp();
                                if (aliasing.mayAlias(retLocal, (Value)newSource.getAccessPath().getPlainValue()) && !InfoflowProblem.this.isExceptionHandler(retSite) && (abs = newSource.deriveNewAbstraction(ap = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(newSource.getAccessPath(), leftOp2), (Stmt)exitStmt)) != null) {
                                    res.add(abs);
                                    if (aliasing.getAliasingStrategy().requiresAnalysisOnReturn()) {
                                        for (Abstraction d1 : callerD1s) {
                                            aliasing.computeAliases(d1, iCallStmt, leftOp2, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                        }
                                    }
                                }
                            }
                            Local sourceBase = newSource.getAccessPath().getPlainValue();
                            boolean parameterAliases = false;
                            Value originalCallArg = null;
                            for (int i = 0; i < callee.getParameterCount(); ++i) {
                                if (callSite instanceof DefinitionStmt && !InfoflowProblem.this.isExceptionHandler(retSite)) {
                                    DefinitionStmt defnStmt3 = (DefinitionStmt)callSite;
                                    Value leftOp3 = defnStmt3.getLeftOp();
                                    originalCallArg = defnStmt3.getInvokeExpr().getArg(i);
                                    if (originalCallArg == leftOp3) continue;
                                }
                                if (!aliasing.mayAlias(paramLocals[i], (Value)sourceBase)) continue;
                                parameterAliases = true;
                                originalCallArg = iCallStmt.getInvokeExpr().getArg(isReflectiveCallSite ? 1 : i);
                                if (!AccessPath.canContainValue(originalCallArg) || !isReflectiveCallSite && !InfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || !source.getAccessPath().getTaintSubFields() || InfoflowProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i])) continue;
                                AccessPath ap = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(newSource.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : newSource.getAccessPath().getBaseType(), false);
                                Abstraction abs = newSource.deriveNewAbstraction(ap, (Stmt)exitStmt);
                                if (abs == null) continue;
                                res.add(abs);
                            }
                            boolean thisAliases = false;
                            if (callSite instanceof DefinitionStmt && !InfoflowProblem.this.isExceptionHandler(retSite) && thisLocal == (leftOp = (defnStmt = (DefinitionStmt)callSite).getLeftOp())) {
                                thisAliases = true;
                            }
                            if (!parameterAliases && !thisAliases && source.getAccessPath().getTaintSubFields() && iCallStmt.getInvokeExpr() instanceof InstanceInvokeExpr && aliasing.mayAlias(thisLocal, (Value)sourceBase) && InfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), thisLocal.getType())) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)iCallStmt.getInvokeExpr();
                                Value callerBaseLocal = InfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(iIExpr) ? iIExpr.getArg(0) : iIExpr.getBase();
                                AccessPath ap = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(newSource.getAccessPath(), callerBaseLocal, isReflectiveCallSite ? null : newSource.getAccessPath().getBaseType(), false);
                                Abstraction abs = newSource.deriveNewAbstraction(ap, (Stmt)exitStmt);
                                if (abs != null) {
                                    res.add(abs);
                                }
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs.isImplicit() && !callerD1sConditional || aliasing.getAliasingStrategy().requiresAnalysisOnReturn()) {
                                for (Abstraction d1 : callerD1s) {
                                    aliasing.computeAliases(d1, iCallStmt, null, res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(callSite), abs);
                                }
                            }
                            if (abs == newSource) continue;
                            abs.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                boolean isSink;
                if (!(call instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt iCallStmt = (Stmt)call;
                final InvokeExpr invExpr = iCallStmt.getInvokeExpr();
                final Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                boolean bl = InfoflowProblem.this.manager.getSourceSinkManager() != null ? InfoflowProblem.this.manager.getSourceSinkManager().getSinkInfo(iCallStmt, InfoflowProblem.this.manager, null) != null : (isSink = false);
                final boolean isSource = InfoflowProblem.this.manager.getSourceSinkManager() != null ? InfoflowProblem.this.manager.getSourceSinkManager().getSourceInfo(iCallStmt, InfoflowProblem.this.manager) != null : false;
                final SootMethod callee = invExpr.getMethod();
                final boolean hasValidCallees = this.hasValidCallees(call);
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return InfoflowProblem.this.notifyOutFlowHandlers(call, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        boolean passOn;
                        if (InfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !InfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        if (InfoflowProblem.this.taintPropagationHandler != null) {
                            InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(call, source, InfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        Abstraction newSource = !source.isAbstractionActive() && (call == source.getActivationUnit() || InfoflowProblem.this.isCallSiteActivatingTaint(call, source.getActivationUnit())) ? source.getActiveCopy() : source;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        Set<Abstraction> res = InfoflowProblem.this.propagationRules.applyCallToReturnFlowFunction(d1, newSource, iCallStmt, killSource, killAll, true);
                        if (killAll.value) {
                            return null;
                        }
                        boolean bl = passOn = !killSource.value;
                        if (source == InfoflowProblem.this.getZeroValue()) {
                            return res == null || res.isEmpty() ? Collections.emptySet() : res;
                        }
                        if (res == null) {
                            res = new HashSet<Abstraction>();
                        }
                        if (newSource.getTopPostdominator() != null && newSource.getTopPostdominator().getUnit() == null) {
                            return Collections.singleton(newSource);
                        }
                        if (newSource.getAccessPath().isStaticFieldRef()) {
                            passOn = false;
                        }
                        if (passOn && invExpr instanceof InstanceInvokeExpr && (InfoflowProblem.this.manager.getConfig().getInspectSources() || !isSource) && (InfoflowProblem.this.manager.getConfig().getInspectSinks() || !isSink) && newSource.getAccessPath().isInstanceFieldRef() && (hasValidCallees || InfoflowProblem.this.taintWrapper != null && InfoflowProblem.this.taintWrapper.isExclusive(iCallStmt, newSource))) {
                            Collection callees = InfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(call);
                            int allCalleesRead = !callees.isEmpty() ? 1 : 0;
                            block0: for (SootMethod callee2 : callees) {
                                Set calleeAPs;
                                if (callee2.isConcrete() && callee2.hasActiveBody() && (calleeAPs = this.mapAccessPathToCallee(callee2, invExpr, null, null, source.getAccessPath())) != null) {
                                    for (AccessPath ap : calleeAPs) {
                                        if (ap == null || InfoflowProblem.this.interproceduralCFG().methodReadsValue(callee2, ap.getPlainValue())) continue;
                                        allCalleesRead = 0;
                                        break block0;
                                    }
                                }
                                if (!InfoflowProblem.this.isExcluded(callee2)) continue;
                                allCalleesRead = 0;
                                break;
                            }
                            if (allCalleesRead != 0) {
                                if (aliasing.mayAlias(((InstanceInvokeExpr)invExpr).getBase(), (Value)newSource.getAccessPath().getPlainValue())) {
                                    passOn = false;
                                }
                                if (passOn) {
                                    for (int i = 0; i < callArgs.length; ++i) {
                                        if (!aliasing.mayAlias(callArgs[i], (Value)newSource.getAccessPath().getPlainValue())) continue;
                                        passOn = false;
                                        break;
                                    }
                                }
                                if (newSource.getAccessPath().isStaticFieldRef()) {
                                    passOn = false;
                                }
                            }
                        }
                        if (source.getAccessPath().isStaticFieldRef() && !InfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            passOn = true;
                        }
                        if ((passOn |= source.getTopPostdominator() != null || source.getAccessPath().isEmpty()) && newSource != InfoflowProblem.this.getZeroValue()) {
                            res.add(newSource);
                        }
                        if (callee.isNative()) {
                            for (Value callVal : callArgs) {
                                if (callVal != newSource.getAccessPath().getPlainValue()) continue;
                                Set<Abstraction> nativeAbs = InfoflowProblem.this.ncHandler.getTaintedValues(iCallStmt, newSource, callArgs);
                                if (nativeAbs == null) break;
                                res.addAll(nativeAbs);
                                for (Abstraction abs : nativeAbs) {
                                    if (!abs.getAccessPath().isStaticFieldRef() && !aliasing.canHaveAliases(iCallStmt, abs.getAccessPath().getCompleteValue(), abs)) continue;
                                    aliasing.computeAliases(d1, iCallStmt, abs.getAccessPath().getPlainValue(), res, (SootMethod)InfoflowProblem.this.interproceduralCFG().getMethodOf(call), abs);
                                }
                                break;
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == newSource) continue;
                            abs.setCorrespondingCallSite(iCallStmt);
                        }
                        return res;
                    }
                };
            }

            private Set<AccessPath> mapAccessPathToCallee(SootMethod callee, InvokeExpr ie, Value[] paramLocals, Local thisLocal, AccessPath ap) {
                if (ap.isEmpty()) {
                    return null;
                }
                boolean isExecutorExecute = InfoflowProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                HashSet<AccessPath> res = null;
                Aliasing aliasing = InfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return null;
                }
                if (aliasing.getAliasingStrategy().isLazyAnalysis() && Aliasing.canHaveAliases(ap)) {
                    res = new HashSet<AccessPath>();
                    res.add(ap);
                }
                Value baseLocal = null;
                if (!(isExecutorExecute || ap.isStaticFieldRef() || callee.isStatic())) {
                    if (InfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(ie)) {
                        baseLocal = ie.getArg(0);
                    } else {
                        assert (ie instanceof InstanceInvokeExpr);
                        InstanceInvokeExpr vie = (InstanceInvokeExpr)ie;
                        baseLocal = vie.getBase();
                    }
                }
                if (baseLocal != null && aliasing.mayAlias(baseLocal, (Value)ap.getPlainValue()) && InfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(ap, callee.getDeclaringClass())) {
                    if (res == null) {
                        res = new HashSet();
                    }
                    if (thisLocal == null) {
                        thisLocal = callee.getActiveBody().getThisLocal();
                    }
                    res.add(InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, thisLocal));
                }
                if (isExecutorExecute) {
                    if (aliasing.mayAlias(ie.getArg(0), (Value)ap.getPlainValue())) {
                        if (res == null) {
                            res = new HashSet();
                        }
                        res.add(InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, callee.getActiveBody().getThisLocal()));
                    }
                } else if (callee.getParameterCount() > 0) {
                    int i;
                    boolean isReflectiveCallSite = InfoflowProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                    int n = i = isReflectiveCallSite ? 1 : 0;
                    while (i < ie.getArgCount()) {
                        if (aliasing.mayAlias(ie.getArg(i), (Value)ap.getPlainValue())) {
                            if (res == null) {
                                res = new HashSet();
                            }
                            if (paramLocals == null) {
                                paramLocals = callee.getActiveBody().getParameterLocals().toArray(new Local[callee.getParameterCount()]);
                            }
                            if (isReflectiveCallSite) {
                                for (int j = 0; j < paramLocals.length; ++j) {
                                    AccessPath newAP = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, paramLocals[j], null, false);
                                    if (newAP == null) continue;
                                    res.add(newAP);
                                }
                            } else {
                                AccessPath newAP = InfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, paramLocals[i]);
                                if (newAP != null) {
                                    res.add(newAP);
                                }
                            }
                        }
                        ++i;
                    }
                }
                return res;
            }

            abstract class NotifyingNormalFlowFunction
            extends SolverNormalFlowFunction {
                protected final Stmt stmt;

                public NotifyingNormalFlowFunction(Stmt stmt) {
                    this.stmt = stmt;
                }

                @Override
                public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                    if (InfoflowProblem.this.taintPropagationHandler != null) {
                        InfoflowProblem.this.taintPropagationHandler.notifyFlowIn(this.stmt, source, InfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                    }
                    Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                    return InfoflowProblem.this.notifyOutFlowHandlers(this.stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                }

                public abstract Set<Abstraction> computeTargetsInternal(Abstraction var1, Abstraction var2);
            }
        };
    }

    @Override
    public boolean autoAddZero() {
        return false;
    }

    public TaintPropagationResults getResults() {
        return this.results;
    }

    public PropagationRuleManager getPropagationRules() {
        return this.propagationRules;
    }
}

