/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.Collections;
import soot.SootMethod;
import soot.Value;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class ExceptionPropagationRule
extends AbstractTaintPropagationRule {
    public ExceptionPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        DefinitionStmt def;
        if (source == this.getZeroValue()) {
            return null;
        }
        if (source.getExceptionThrown() && stmt instanceof DefinitionStmt && (def = (DefinitionStmt)stmt).getRightOp() instanceof CaughtExceptionRef) {
            killSource.value = true;
            AccessPath ap = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), def.getLeftOp());
            return ap == null ? null : Collections.singleton(source.deriveNewAbstractionOnCatch(ap));
        }
        if (stmt instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)stmt;
            if (this.getAliasing().mayAlias(throwStmt.getOp(), (Value)source.getAccessPath().getPlainValue())) {
                killSource.value = true;
                return Collections.singleton(source.deriveNewAbstractionOnThrow(throwStmt));
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        DefinitionStmt defRetStmt;
        if (stmt instanceof ThrowStmt && retSite instanceof DefinitionStmt && (defRetStmt = (DefinitionStmt)retSite).getRightOp() instanceof CaughtExceptionRef) {
            ThrowStmt throwStmt = (ThrowStmt)stmt;
            if (this.getAliasing().mayAlias(throwStmt.getOp(), (Value)source.getAccessPath().getPlainValue())) {
                return Collections.singleton(source.deriveNewAbstractionOnThrow(throwStmt));
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        return null;
    }
}

