/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.Collections;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class StaticPropagationRule
extends AbstractTaintPropagationRule {
    public StaticPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        InfoflowConfiguration.StaticFieldTrackingMode staticFieldMode = this.getManager().getConfig().getStaticFieldTrackingMode();
        if (staticFieldMode == InfoflowConfiguration.StaticFieldTrackingMode.None && (dest.isStaticInitializer() || source.getAccessPath().isStaticFieldRef())) {
            killAll.value = true;
            return null;
        }
        AccessPath ap = source.getAccessPath();
        if (ap.isStaticFieldRef()) {
            Abstraction newAbs;
            boolean isLazyAnalysis = false;
            Aliasing aliasing = this.getAliasing();
            if (aliasing != null) {
                IAliasingStrategy strategy = aliasing.getAliasingStrategy();
                boolean bl = isLazyAnalysis = strategy != null && strategy.isLazyAnalysis();
            }
            if ((isLazyAnalysis || this.manager.getICFG().isStaticFieldRead(dest, ap.getFirstField())) && (newAbs = source.deriveNewAbstraction(ap, stmt)) != null) {
                return Collections.singleton(newAbs);
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (this.getManager().getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
            killAll.value = true;
            return null;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        if (!source.getAccessPath().isStaticFieldRef()) {
            return null;
        }
        if (this.getManager().getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
            killAll.value = true;
            return null;
        }
        return Collections.singleton(source.deriveNewAbstraction(source.getAccessPath(), stmt));
    }
}

