/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.RefType;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.ByReferenceBoolean;
import soot.jimple.infoflow.util.TypeUtils;

public class WrapperPropagationRule
extends AbstractTaintPropagationRule {
    public WrapperPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    private Set<Abstraction> computeWrapperTaints(Abstraction d1, Stmt iStmt, Abstraction source) {
        Set<Abstraction> res;
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.getManager().getTaintWrapper() == null) {
            return null;
        }
        Aliasing aliasing = this.getAliasing();
        if (aliasing != null && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isEmpty()) {
            boolean found = false;
            if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)iStmt.getInvokeExpr();
                found = aliasing.mayAlias(iiExpr.getBase(), (Value)source.getAccessPath().getPlainValue());
            }
            if (!found) {
                for (int paramIdx = 0; paramIdx < iStmt.getInvokeExpr().getArgCount(); ++paramIdx) {
                    if (!aliasing.mayAlias(source.getAccessPath().getPlainValue(), iStmt.getInvokeExpr().getArg(paramIdx))) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                return null;
            }
        }
        if (!this.getManager().getConfig().getInspectSources()) {
            SourceInfo sourceInfo;
            SourceInfo sourceInfo2 = sourceInfo = this.getManager().getSourceSinkManager() != null ? this.getManager().getSourceSinkManager().getSourceInfo(iStmt, this.getManager()) : null;
            if (sourceInfo != null) {
                return null;
            }
        }
        if ((res = this.getManager().getTaintWrapper().getTaintsForMethod(iStmt, d1, source)) != null) {
            HashSet<Abstraction> resWithAliases = new HashSet<Abstraction>(res);
            for (Abstraction abs : res) {
                if (abs.equals(source)) continue;
                this.checkAndPropagateAlias(d1, iStmt, resWithAliases, abs);
            }
            res = resWithAliases;
        }
        return res;
    }

    protected void checkAndPropagateAlias(Abstraction d1, Stmt iStmt, Set<Abstraction> resWithAliases, Abstraction abs) {
        boolean taintedValueOverwritten;
        AccessPath val = abs.getAccessPath();
        boolean isBasicString = TypeUtils.isStringType(val.getBaseType()) && !val.getCanHaveImmutableAliases() && !this.getAliasing().isStringConstructorCall(iStmt);
        boolean taintsObjectValue = val.getBaseType() instanceof RefType && abs.getAccessPath().getBaseType() instanceof RefType && !isBasicString;
        boolean taintsStaticField = this.getManager().getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && abs.getAccessPath().isStaticFieldRef();
        boolean bl = taintedValueOverwritten = iStmt instanceof DefinitionStmt ? Aliasing.baseMatches(((DefinitionStmt)iStmt).getLeftOp(), abs) : false;
        if (!taintedValueOverwritten && (taintsStaticField || taintsObjectValue && abs.getAccessPath().getTaintSubFields() || this.manager.getAliasing().canHaveAliases(iStmt, val.getCompleteValue(), abs))) {
            this.getAliasing().computeAliases(d1, iStmt, val.getPlainValue(), resWithAliases, (SootMethod)this.getManager().getICFG().getMethodOf(iStmt), abs);
        }
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        Set<Abstraction> wrapperTaints = this.computeWrapperTaints(d1, stmt, source);
        if (wrapperTaints != null) {
            for (Abstraction wrapperAbs : wrapperTaints) {
                if (!wrapperAbs.getAccessPath().equals(source.getAccessPath())) continue;
                if (wrapperAbs == source) break;
                killSource.value = true;
                break;
            }
        }
        return wrapperTaints;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (this.getManager().getTaintWrapper() != null && this.getManager().getTaintWrapper().isExclusive(stmt, source)) {
            killAll.value = true;
        }
        return null;
    }
}

