/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import java.util.Objects;

public class InfoflowPerformanceData {
    private int callgraphConstructionSeconds = -1;
    private int taintPropagationSeconds = -1;
    private int pathReconstructionSeconds = -1;
    private int totalRuntimeSeconds = -1;
    private int maxMemoryConsumption = -1;
    private long edgePropagationCount = -1L;
    private int sourceCount = -1;
    private int sinkCount = -1;

    public int getCallgraphConstructionSeconds() {
        return this.callgraphConstructionSeconds;
    }

    public void setCallgraphConstructionSeconds(int callgraphSeconds) {
        this.callgraphConstructionSeconds = callgraphSeconds;
    }

    public int getTaintPropagationSeconds() {
        return this.taintPropagationSeconds;
    }

    public void setTaintPropagationSeconds(int taintPropagationSeconds) {
        this.taintPropagationSeconds = taintPropagationSeconds;
    }

    public int getPathReconstructionSeconds() {
        return this.pathReconstructionSeconds;
    }

    public void setPathReconstructionSeconds(int pathReconstructionSeconds) {
        this.pathReconstructionSeconds = pathReconstructionSeconds;
    }

    public int getTotalRuntimeSeconds() {
        return this.totalRuntimeSeconds;
    }

    public void setTotalRuntimeSeconds(int totalRuntimeSeconds) {
        this.totalRuntimeSeconds = totalRuntimeSeconds;
    }

    public int getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    public void setMaxMemoryConsumption(int maxMemoryConsumption) {
        this.maxMemoryConsumption = maxMemoryConsumption;
    }

    public boolean isEmpty() {
        return this.callgraphConstructionSeconds <= 0 && this.taintPropagationSeconds <= 0 && this.pathReconstructionSeconds <= 0 && this.totalRuntimeSeconds <= 0 && this.maxMemoryConsumption <= 0;
    }

    public void add(InfoflowPerformanceData performanceData) {
        if (performanceData.callgraphConstructionSeconds > 0) {
            this.callgraphConstructionSeconds = this.callgraphConstructionSeconds < 0 ? performanceData.callgraphConstructionSeconds : (this.callgraphConstructionSeconds += performanceData.callgraphConstructionSeconds);
        }
        if (performanceData.taintPropagationSeconds > 0) {
            this.taintPropagationSeconds = this.taintPropagationSeconds < 0 ? performanceData.taintPropagationSeconds : (this.taintPropagationSeconds += performanceData.taintPropagationSeconds);
        }
        if (performanceData.totalRuntimeSeconds > 0) {
            this.totalRuntimeSeconds = this.totalRuntimeSeconds < 0 ? performanceData.totalRuntimeSeconds : (this.totalRuntimeSeconds += performanceData.totalRuntimeSeconds);
        }
        if (performanceData.maxMemoryConsumption > 0) {
            this.maxMemoryConsumption = this.maxMemoryConsumption < 0 ? performanceData.maxMemoryConsumption : Math.max(this.maxMemoryConsumption, performanceData.maxMemoryConsumption);
        }
        if (performanceData.sourceCount > 0) {
            this.sourceCount = this.sourceCount < 0 ? performanceData.sourceCount : (this.sourceCount += performanceData.sourceCount);
        }
        if (performanceData.sinkCount > 0) {
            this.sinkCount = this.sinkCount < 0 ? performanceData.sinkCount : (this.sinkCount += performanceData.sinkCount);
        }
    }

    public void updateMaxMemoryConsumption(int usedMemory) {
        int mem = this.maxMemoryConsumption;
        this.maxMemoryConsumption = mem < 0 ? usedMemory : Math.max(mem, usedMemory);
    }

    public void addTaintPropagationSeconds(int toAdd) {
        int time = this.taintPropagationSeconds;
        this.taintPropagationSeconds = time < 0 ? toAdd : time + toAdd;
    }

    public void addEdgePropagationCount(long toAdd) {
        long edges = this.edgePropagationCount;
        this.edgePropagationCount = edges < 0L ? toAdd : edges + toAdd;
    }

    public void setSourceCount(int sourceCount) {
        this.sourceCount = sourceCount;
    }

    public int getSourceCount() {
        return this.sourceCount;
    }

    public void setSinkCount(int sinkCount) {
        this.sinkCount = sinkCount;
    }

    public int getSinkCount() {
        return this.sinkCount;
    }

    public long getEdgePropagationCount() {
        return this.edgePropagationCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.callgraphConstructionSeconds > 0) {
            sb.append(String.format("Callgraph Construction: %d seconds\n", this.callgraphConstructionSeconds));
        }
        if (this.taintPropagationSeconds > 0) {
            sb.append(String.format("Taint Propagation: %d seconds\n", this.taintPropagationSeconds));
        }
        if (this.pathReconstructionSeconds > 0) {
            sb.append(String.format("Path Reconstruction: %d seconds\n", this.pathReconstructionSeconds));
        }
        if (this.totalRuntimeSeconds > 0) {
            sb.append(String.format("Total Runtime: %d seconds\n", this.totalRuntimeSeconds));
        }
        if (this.maxMemoryConsumption > 0) {
            sb.append(String.format("Max Memory Consumption: %d MB\n", this.maxMemoryConsumption));
        }
        if (this.edgePropagationCount > 0L) {
            sb.append(String.format("Edge Propagation Count: %d\n", this.edgePropagationCount));
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.callgraphConstructionSeconds, this.edgePropagationCount, this.maxMemoryConsumption, this.pathReconstructionSeconds, this.sinkCount, this.sourceCount, this.taintPropagationSeconds, this.totalRuntimeSeconds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InfoflowPerformanceData other = (InfoflowPerformanceData)obj;
        return this.callgraphConstructionSeconds == other.callgraphConstructionSeconds && this.edgePropagationCount == other.edgePropagationCount && this.maxMemoryConsumption == other.maxMemoryConsumption && this.pathReconstructionSeconds == other.pathReconstructionSeconds && this.sinkCount == other.sinkCount && this.sourceCount == other.sourceCount && this.taintPropagationSeconds == other.taintPropagationSeconds && this.totalRuntimeSeconds == other.totalRuntimeSeconds;
    }
}

