/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.rifl.RIFLDocument;

public class RIFLParser {
    public RIFLDocument parseRIFL(File riflFile) throws SAXException, IOException {
        if (!riflFile.exists()) {
            throw new FileNotFoundException("RIFL file " + riflFile + " not found");
        }
        final RIFLDocument doc = new RIFLDocument();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(riflFile, new DefaultHandler(){
                private Stack<RIFLState> stateStack = new Stack();
                private String assignableHandle = "";
                private RIFLDocument.Assignable assignable = null;
                private RIFLDocument.SourceSinkSpec sourceSinkSpec = null;

                @Override
                public void startDocument() throws SAXException {
                    super.startDocument();
                    this.stateStack.push(RIFLState.RiflSpec);
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    super.startElement(uri, localName, qName, attributes);
                    RIFLState curState = this.stateStack.peek();
                    if (curState == RIFLState.RiflSpec && (qName.equalsIgnoreCase("interfacespec") || localName.equalsIgnoreCase("interfacespec"))) {
                        this.stateStack.push(RIFLState.InterfaceSpec);
                    } else if (curState == RIFLState.InterfaceSpec && (qName.equalsIgnoreCase("assignable") || localName.equalsIgnoreCase("assignable"))) {
                        this.stateStack.push(RIFLState.Assignable);
                        this.assignableHandle = attributes.getValue("handle");
                    } else if ((curState == RIFLState.Source || curState == RIFLState.Sink) && (qName.equalsIgnoreCase("parameter") || localName.equalsIgnoreCase("parameter"))) {
                        this.stateStack.push(RIFLState.Parameter);
                        int parameterIdx = Integer.parseInt(attributes.getValue("parameter"));
                        String className = attributes.getValue("class");
                        String methodSig = attributes.getValue("method");
                        RIFLDocument.SourceSinkType type = this.getSourceSinkTypeFromState(curState);
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        RIFLDocument.JavaParameterSpec newSpec = rIFLDocument.new RIFLDocument.JavaParameterSpec(type, className, methodSig, parameterIdx);
                        if (this.sourceSinkSpec == null) {
                            this.sourceSinkSpec = newSpec;
                        } else if (this.sourceSinkSpec instanceof RIFLDocument.Category) {
                            ((RIFLDocument.Category)this.sourceSinkSpec).getElements().add(newSpec);
                        }
                    } else if ((curState == RIFLState.Source || curState == RIFLState.Sink) && (qName.equalsIgnoreCase("returnvalue") || localName.equalsIgnoreCase("returnvalue"))) {
                        this.stateStack.push(RIFLState.Field);
                        String className = attributes.getValue("class");
                        String methodSig = attributes.getValue("method");
                        RIFLDocument.SourceSinkType type = this.getSourceSinkTypeFromState(curState);
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        RIFLDocument.JavaReturnValueSpec newSpec = rIFLDocument.new RIFLDocument.JavaReturnValueSpec(type, className, methodSig);
                        if (this.sourceSinkSpec == null) {
                            this.sourceSinkSpec = newSpec;
                        } else if (this.sourceSinkSpec instanceof RIFLDocument.Category) {
                            ((RIFLDocument.Category)this.sourceSinkSpec).getElements().add(newSpec);
                        }
                    } else if (curState == RIFLState.Assignable && (qName.equalsIgnoreCase("category") || localName.equalsIgnoreCase("category"))) {
                        this.stateStack.push(RIFLState.Category);
                    } else if (curState == RIFLState.Category && (qName.equalsIgnoreCase("category") || localName.equalsIgnoreCase("category"))) {
                        this.stateStack.push(RIFLState.Category);
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        this.sourceSinkSpec = rIFLDocument.new RIFLDocument.Category(attributes.getValue("name"));
                    } else if (curState == RIFLState.Category && (qName.equalsIgnoreCase("source") || localName.equalsIgnoreCase("source"))) {
                        this.stateStack.push(RIFLState.Source);
                    } else if (curState == RIFLState.Category && (qName.equalsIgnoreCase("sink") || localName.equalsIgnoreCase("sink"))) {
                        this.stateStack.push(RIFLState.Sink);
                    } else if (curState == RIFLState.RiflSpec && (qName.equalsIgnoreCase("domains") || localName.equalsIgnoreCase("domains"))) {
                        this.stateStack.push(RIFLState.Domains);
                    } else if (curState == RIFLState.Domains && (qName.equalsIgnoreCase("domain") || localName.equalsIgnoreCase("domain"))) {
                        this.stateStack.push(RIFLState.Domain);
                        List<RIFLDocument.DomainSpec> list = doc.getDomains();
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        list.add(rIFLDocument.new RIFLDocument.DomainSpec(attributes.getValue("name")));
                    } else if (curState == RIFLState.RiflSpec && (qName.equalsIgnoreCase("flowrelation") || localName.equalsIgnoreCase("flowrelation"))) {
                        this.stateStack.push(RIFLState.FlowRelation);
                    } else if (curState == RIFLState.FlowRelation && (qName.equalsIgnoreCase("flow") || localName.equalsIgnoreCase("flow"))) {
                        this.stateStack.push(RIFLState.Flow);
                        String fromDomain = attributes.getValue("from");
                        String toDomain = attributes.getValue("to");
                        List<RIFLDocument.FlowPair> list = doc.getFlowPolicy();
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        list.add(rIFLDocument.new RIFLDocument.FlowPair(doc.getDomainByName(fromDomain), doc.getDomainByName(toDomain)));
                    } else if (curState == RIFLState.RiflSpec && (qName.equalsIgnoreCase("domainassignment") || localName.equalsIgnoreCase("domainassignment"))) {
                        this.stateStack.push(RIFLState.DomainAssignments);
                    } else if (curState == RIFLState.DomainAssignments && (qName.equalsIgnoreCase("assign") || localName.equalsIgnoreCase("assign"))) {
                        this.stateStack.push(RIFLState.Assign);
                        String assignableName = attributes.getValue("handle");
                        String domainName = attributes.getValue("domain");
                        List<RIFLDocument.DomainAssignment> list = doc.getDomainAssignment();
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        list.add(rIFLDocument.new RIFLDocument.DomainAssignment(doc.getInterfaceSpec().getElementByHandle(assignableName), doc.getDomainByName(domainName)));
                    }
                }

                private RIFLDocument.SourceSinkType getSourceSinkTypeFromState(RIFLState curState) {
                    switch (curState) {
                        case Source: {
                            return RIFLDocument.SourceSinkType.Source;
                        }
                        case Sink: {
                            return RIFLDocument.SourceSinkType.Sink;
                        }
                    }
                    throw new RuntimeException("Invalid source/sink type: " + (Object)((Object)curState));
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    super.endElement(uri, localName, qName);
                    RIFLState curState = this.stateStack.pop();
                    if (curState == RIFLState.Assignable) {
                        RIFLDocument rIFLDocument = doc;
                        rIFLDocument.getClass();
                        this.assignable = rIFLDocument.new RIFLDocument.Assignable(this.assignableHandle, this.sourceSinkSpec);
                        doc.getInterfaceSpec().getSourcesSinks().add(this.assignable);
                        this.sourceSinkSpec = null;
                    }
                }
            });
            return doc;
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    private static enum RIFLState {
        RiflSpec,
        InterfaceSpec,
        Assignable,
        Source,
        Sink,
        ReturnValue,
        Parameter,
        Field,
        Category,
        Domains,
        Domain,
        FlowRelation,
        Flow,
        DomainAssignments,
        Assign;

    }
}

