/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.xml.sax.SAXException;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.rifl.RIFLDocument;
import soot.jimple.infoflow.rifl.RIFLParser;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class RIFLSourceSinkDefinitionProvider
implements ISourceSinkDefinitionProvider {
    private final Set<ISourceSinkDefinition> sources = new HashSet<ISourceSinkDefinition>();
    private final Set<ISourceSinkDefinition> sinks = new HashSet<ISourceSinkDefinition>();
    private Set<ISourceSinkDefinition> allMethods = null;
    private String lastCategory = null;

    public RIFLSourceSinkDefinitionProvider(String file) throws SAXException, IOException {
        RIFLParser parser = new RIFLParser();
        RIFLDocument doc = parser.parseRIFL(new File(file));
        for (RIFLDocument.Assignable assign : doc.getInterfaceSpec().getSourcesSinks()) {
            this.parseRawDefinition(assign.getElement());
        }
    }

    private void parseRawDefinition(RIFLDocument.SourceSinkSpec element) {
        if (element.getType() == RIFLDocument.SourceSinkType.Source) {
            ISourceSinkDefinition sourceSinkDefinition = this.parseDefinition(element, RIFLDocument.SourceSinkType.Source);
            final String permanentCategory = this.lastCategory;
            sourceSinkDefinition.setCategory(new ISourceSinkCategory(){

                @Override
                public String getHumanReadableDescription() {
                    return permanentCategory;
                }

                @Override
                public String getID() {
                    return permanentCategory;
                }
            });
            this.sources.add(sourceSinkDefinition);
        } else if (element.getType() == RIFLDocument.SourceSinkType.Sink) {
            ISourceSinkDefinition sourceSinkDefinition = this.parseDefinition(element, RIFLDocument.SourceSinkType.Sink);
            final String permanentCategory = this.lastCategory;
            sourceSinkDefinition.setCategory(new ISourceSinkCategory(){

                @Override
                public String getHumanReadableDescription() {
                    return permanentCategory;
                }

                @Override
                public String getID() {
                    return permanentCategory.toUpperCase(Locale.US);
                }
            });
            this.sinks.add(sourceSinkDefinition);
        } else if (element.getType() == RIFLDocument.SourceSinkType.Category) {
            RIFLDocument.Category cat = (RIFLDocument.Category)element;
            this.lastCategory = cat.getName();
            String[] s2 = this.lastCategory.split("_");
            this.lastCategory = "";
            for (int i = 0; i < s2.length - 1; ++i) {
                if (i != 0) {
                    this.lastCategory = this.lastCategory + " ";
                }
                this.lastCategory = this.lastCategory + s2[i];
            }
            for (RIFLDocument.SourceSinkSpec spec : cat.getElements()) {
                this.parseRawDefinition(spec);
            }
        } else {
            throw new RuntimeException("Invalid element type");
        }
    }

    private ISourceSinkDefinition parseDefinition(RIFLDocument.SourceSinkSpec element, RIFLDocument.SourceSinkType sourceSinkType) {
        if (element instanceof RIFLDocument.JavaMethodSourceSinkSpec) {
            RIFLDocument.JavaMethodSourceSinkSpec javaElement = (RIFLDocument.JavaMethodSourceSinkSpec)element;
            String methodName = SootMethodRepresentationParser.v().getMethodNameFromSubSignature(javaElement.getHalfSignature());
            String[] parameters = SootMethodRepresentationParser.v().getParameterTypesFromSubSignature(javaElement.getHalfSignature());
            ArrayList<String> parameterTypes = new ArrayList<String>();
            if (parameters != null) {
                for (String p : parameters) {
                    parameterTypes.add(p);
                }
            }
            if (element instanceof RIFLDocument.JavaParameterSpec) {
                RIFLDocument.JavaParameterSpec paramSpec = (RIFLDocument.JavaParameterSpec)element;
                HashSet<AccessPathTuple> returnValue = new HashSet<AccessPathTuple>();
                SootMethodAndClass am = new SootMethodAndClass(methodName, javaElement.getClassName(), "", parameterTypes);
                return new MethodSourceSinkDefinition(am, null, null, returnValue, MethodSourceSinkDefinition.CallType.MethodCall);
            }
            if (element instanceof RIFLDocument.JavaReturnValueSpec) {
                AccessPathTuple apt = AccessPathTuple.fromPathElements((String[])null, null, sourceSinkType == RIFLDocument.SourceSinkType.Source, sourceSinkType == RIFLDocument.SourceSinkType.Sink);
                SootMethodAndClass am = new SootMethodAndClass(methodName, javaElement.getClassName(), "", parameterTypes);
                return new MethodSourceSinkDefinition(am, null, null, null, MethodSourceSinkDefinition.CallType.MethodCall);
            }
        } else if (element instanceof RIFLDocument.JavaFieldSpec) {
            // empty if block
        }
        throw new RuntimeException("Invalid source/sink specification element");
    }

    public Set<ISourceSinkDefinition> getSources() {
        return this.sources;
    }

    public Set<ISourceSinkDefinition> getSinks() {
        return this.sinks;
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        if (this.allMethods == null) {
            this.allMethods = new HashSet<ISourceSinkDefinition>(this.sources.size() + this.sinks.size());
            this.allMethods.addAll(this.sources);
            this.allMethods.addAll(this.sinks);
        }
        return this.allMethods;
    }
}

