/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.rifl;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import soot.jimple.infoflow.rifl.RIFLDocument;

public class RIFLWriter {
    private final RIFLDocument document;

    public RIFLWriter(RIFLDocument document) {
        this.document = document;
    }

    public String write() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement("riflspec");
            document.appendChild(rootElement);
            this.writeInterfaceSpec(document, rootElement);
            this.writeDomains(document, rootElement);
            this.writeDomainAssignment(document, rootElement);
            this.writeFlowPolicy(document, rootElement);
            StringWriter stringWriter = new StringWriter();
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stringWriter);
            transformer.transform(source, result);
            return stringWriter.toString();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        catch (TransformerException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void writeInterfaceSpec(Document document, Element rootElement) {
        Element attackerIO = document.createElement("interfacespec");
        rootElement.appendChild(attackerIO);
        for (RIFLDocument.Assignable assign : this.document.getInterfaceSpec().getSourcesSinks()) {
            this.writeAssignable(assign, document, attackerIO);
        }
    }

    private void writeAssignable(RIFLDocument.Assignable assign, Document document, Element rootElement) {
        Element attackerIO = document.createElement("assignable");
        rootElement.appendChild(attackerIO);
        attackerIO.setAttribute("handle", assign.getHandle());
        this.writeSourceSinkSpec(assign.getElement(), document, attackerIO);
    }

    private void writeSourceSinkSpec(RIFLDocument.SourceSinkSpec spec, Document document, Element parentElement) {
        Element containerElement = null;
        switch (spec.getType()) {
            case Source: {
                containerElement = document.createElement("source");
                break;
            }
            case Sink: {
                containerElement = document.createElement("sink");
                break;
            }
            case Category: {
                containerElement = document.createElement("category");
                break;
            }
            default: {
                throw new RuntimeException("Invalid source/sink type");
            }
        }
        parentElement.appendChild(containerElement);
        if (spec instanceof RIFLDocument.JavaParameterSpec) {
            this.writeJavaParameterSpec((RIFLDocument.JavaParameterSpec)spec, document, containerElement);
        } else if (spec instanceof RIFLDocument.JavaFieldSpec) {
            this.writeJavaFieldSpec((RIFLDocument.JavaFieldSpec)spec, document, containerElement);
        } else if (spec instanceof RIFLDocument.JavaReturnValueSpec) {
            this.writeJavaReturnValueSpec((RIFLDocument.JavaReturnValueSpec)spec, document, containerElement);
        } else if (spec instanceof RIFLDocument.Category) {
            this.writeCategory((RIFLDocument.Category)spec, document, containerElement);
        } else {
            throw new RuntimeException("Unsupported source or sink specification type");
        }
    }

    private void writeJavaParameterSpec(RIFLDocument.JavaParameterSpec spec, Document document, Element parentElement) {
        Element parameter = document.createElement("parameter");
        parentElement.appendChild(parameter);
        parameter.setAttribute("class", spec.getClassName());
        parameter.setAttribute("method", spec.getHalfSignature());
        parameter.setAttribute("parameter", Integer.toString(spec.getParamIdx()));
    }

    private void writeJavaFieldSpec(RIFLDocument.JavaFieldSpec spec, Document document, Element parentElement) {
        Element parameter = document.createElement("field");
        parentElement.appendChild(parameter);
        parameter.setAttribute("class", spec.getClassName());
        parameter.setAttribute("field", spec.getFieldName());
    }

    private void writeJavaReturnValueSpec(RIFLDocument.JavaReturnValueSpec spec, Document document, Element parentElement) {
        Element parameter = document.createElement("returnvalue");
        parentElement.appendChild(parameter);
        parameter.setAttribute("class", spec.getClassName());
        parameter.setAttribute("method", spec.getHalfSignature());
    }

    private void writeCategory(RIFLDocument.Category category, Document document, Element parentElement) {
        Element categoryElement = document.createElement("category");
        parentElement.appendChild(categoryElement);
        categoryElement.setAttribute("name", category.getName());
        for (RIFLDocument.SourceSinkSpec element : category.getElements()) {
            this.writeSourceSinkSpec(element, document, categoryElement);
        }
    }

    private void writeDomains(Document document, Element rootElement) {
        Element domains = document.createElement("domains");
        rootElement.appendChild(domains);
        for (RIFLDocument.DomainSpec spec : this.document.getDomains()) {
            this.writeDomainSpec(spec, document, domains);
        }
    }

    private void writeDomainSpec(RIFLDocument.DomainSpec spec, Document document, Element parentElement) {
        Element categoryDomain = document.createElement("domain");
        parentElement.appendChild(categoryDomain);
        categoryDomain.setAttribute("name", spec.getName());
    }

    private void writeDomainAssignment(Document document, Element rootElement) {
        Element domainAssignment = document.createElement("domainassignment");
        rootElement.appendChild(domainAssignment);
        for (RIFLDocument.DomainAssignment spec : this.document.getDomainAssignment()) {
            this.writeDomainAssignment(spec, document, domainAssignment);
        }
    }

    private void writeDomainAssignment(RIFLDocument.DomainAssignment pair, Document document, Element rootElement) {
        Element pairElement = document.createElement("assign");
        rootElement.appendChild(pairElement);
        pairElement.setAttribute("handle", pair.getSourceOrSink().getHandle());
        pairElement.setAttribute("domain", pair.getDomain().getName());
    }

    private void writeFlowPolicy(Document document, Element rootElement) {
        Element flowPolicy = document.createElement("flowrelation");
        rootElement.appendChild(flowPolicy);
        for (RIFLDocument.FlowPair pair : this.document.getFlowPolicy()) {
            this.writeFlowPair(pair, document, flowPolicy);
        }
    }

    private void writeFlowPair(RIFLDocument.FlowPair pair, Document document, Element parentElement) {
        Element flowPair = document.createElement("flow");
        parentElement.appendChild(flowPair);
        flowPair.setAttribute("from", pair.getFirstDomain().getName());
        flowPair.setAttribute("to", pair.getSecondDomain().getName());
    }

    public RIFLDocument getDocument() {
        return this.document;
    }
}

