/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.executors;

import heros.solver.CountingThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.collect.BlackHoleCollection;

public class InterruptableExecutor
extends CountingThreadPoolExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(InterruptableExecutor.class);
    private boolean interrupted = false;
    private boolean terminated = false;

    public InterruptableExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public void interrupt() {
        this.interrupted = true;
        this.getQueue().clear();
        this.getQueue().drainTo(new BlackHoleCollection());
        this.purge();
        this.numRunningTasks.resetAndInterrupt();
    }

    public void reset() {
        this.terminated = false;
        this.interrupted = false;
    }

    @Override
    public void execute(Runnable command) {
        if (this.terminated) {
            logger.warn("Executor has terminated. Call reset() before submitting new tasks.");
            return;
        }
        try {
            if (!this.interrupted) {
                super.execute(command);
            }
        }
        catch (RejectedExecutionException ex) {
            this.interrupted = true;
        }
    }

    @Override
    public void awaitCompletion() throws InterruptedException {
        if (this.terminated) {
            return;
        }
        super.awaitCompletion();
        this.terminated = true;
    }

    @Override
    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.terminated) {
            return;
        }
        super.awaitCompletion(timeout, unit);
        this.terminated = true;
    }

    public boolean isFinished() {
        return this.terminated || this.numRunningTasks.isAtZero();
    }

    @Override
    public boolean isTerminated() {
        return this.terminated || super.isTerminated();
    }
}

